/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.util.ArrayList;
import java.util.List;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Name;
import jdk.jfr.ValueDescriptor;

public final class EventTypePrototype {
    private final List<ValueDescriptor> fields;
    private final List<AnnotationElement> annotations;
    private final String name;

    public EventTypePrototype(String name, List<AnnotationElement> as, List<ValueDescriptor> fields) {
        this.annotations = new ArrayList<AnnotationElement>(as);
        this.annotations.add(new AnnotationElement(Name.class, name));
        this.fields = fields;
        this.name = name;
    }

    public EventTypePrototype(String name) {
        this(name, new ArrayList<AnnotationElement>(), new ArrayList<ValueDescriptor>());
    }

    public int getFieldIndex(String key) {
        int index = 0;
        for (ValueDescriptor f : this.fields) {
            if (f.getName().equals(key)) {
                return index;
            }
            ++index;
        }
        throw new NoSuchFieldError(key);
    }

    public void addField(ValueDescriptor fieldDescriptor) {
        this.fields.add(fieldDescriptor);
    }

    public void addAnnotation(AnnotationElement annotation) {
        this.annotations.add(annotation);
    }

    public List<ValueDescriptor> getFields() {
        return this.fields;
    }

    public List<AnnotationElement> getAnnotations() {
        return this.annotations;
    }

    public String getName() {
        return this.name;
    }
}

