/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.whitebox.code;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.EnumSet;
import jdk.test.whitebox.WhiteBox;

public enum BlobType {
    MethodNonProfiled(0, "CodeHeap 'non-profiled nmethods'", "NonProfiledCodeHeapSize"){

        @Override
        public boolean allowTypeWhenOverflow(BlobType type) {
            return super.allowTypeWhenOverflow(type) || type == MethodProfiled;
        }
    }
    ,
    MethodProfiled(1, "CodeHeap 'profiled nmethods'", "ProfiledCodeHeapSize"){

        @Override
        public boolean allowTypeWhenOverflow(BlobType type) {
            return super.allowTypeWhenOverflow(type) || type == MethodNonProfiled;
        }
    }
    ,
    NonNMethod(2, "CodeHeap 'non-nmethods'", "NonNMethodCodeHeapSize"){

        @Override
        public boolean allowTypeWhenOverflow(BlobType type) {
            return super.allowTypeWhenOverflow(type) || type == MethodNonProfiled || type == MethodProfiled;
        }
    }
    ,
    All(3, "CodeCache", "ReservedCodeCacheSize");

    public final int id;
    public final String sizeOptionName;
    public final String beanName;

    private BlobType(int id, String beanName, String sizeOptionName) {
        this.id = id;
        this.beanName = beanName;
        this.sizeOptionName = sizeOptionName;
    }

    public MemoryPoolMXBean getMemoryPool() {
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = bean.getName();
            if (!this.beanName.equals(name)) continue;
            return bean;
        }
        return null;
    }

    public boolean allowTypeWhenOverflow(BlobType type) {
        return type == this;
    }

    public static EnumSet<BlobType> getAvailable() {
        WhiteBox whiteBox = WhiteBox.getWhiteBox();
        if (!whiteBox.getBooleanVMFlag("SegmentedCodeCache").booleanValue()) {
            return EnumSet.of(All);
        }
        if (System.getProperty("java.vm.info").startsWith("interpreted ")) {
            return EnumSet.of(NonNMethod);
        }
        EnumSet<BlobType> result = EnumSet.complementOf(EnumSet.of(All));
        if (!whiteBox.getBooleanVMFlag("TieredCompilation").booleanValue() || whiteBox.getIntxVMFlag("TieredStopAtLevel") <= 1L) {
            result.remove((Object)MethodProfiled);
        }
        return result;
    }

    public long getSize() {
        return WhiteBox.getWhiteBox().getUintxVMFlag(this.sizeOptionName);
    }
}

