/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.parser.HprofReader;
import jdk.test.lib.hprof.parser.PositionDataInputStream;

public abstract class Reader {
    protected PositionDataInputStream in;
    private static final int GZIP_HEADER_MAGIC = 2067208;

    protected Reader(PositionDataInputStream in) {
        this.in = in;
    }

    public abstract Snapshot read() throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Snapshot readFile(String heapFile, boolean callStack, int debugLevel) throws IOException {
        int dumpNumber = 1;
        int pos = heapFile.lastIndexOf(35);
        if (pos > -1) {
            String num = heapFile.substring(pos + 1, heapFile.length());
            try {
                dumpNumber = Integer.parseInt(num, 10);
            }
            catch (NumberFormatException ex) {
                String msg = "In file name \"" + heapFile + "\", a dump number was expected after the :, but \"" + num + "\" was found instead.";
                System.err.println(msg);
                throw new IOException(msg);
            }
            heapFile = heapFile.substring(0, pos);
        }
        try (FileInputStream fis = new FileInputStream(heapFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             PositionDataInputStream in = new PositionDataInputStream(bis);){
            int i = in.readInt();
            if (i == 1245795905) {
                HprofReader r = new HprofReader(heapFile, in, dumpNumber, callStack, debugLevel);
                Snapshot snapshot = ((Reader)r).read();
                return snapshot;
            }
            if (i >>> 8 != 2067208) throw new IOException("Unrecognized magic number: " + i);
            in.close();
            String deCompressedFile = "heapdump" + System.currentTimeMillis() + ".hprof";
            File out = new File(deCompressedFile);
            try (FileInputStream heapFis = new FileInputStream(heapFile);
                 GZIPInputStream gis = new GZIPInputStream(heapFis);
                 FileOutputStream fos = new FileOutputStream(out);){
                byte[] buffer = new byte[0x100000];
                int len = 0;
                while ((len = gis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                out.delete();
                throw new IOException("Cannot decompress the compressed hprof file", e);
            }
            try (FileInputStream outFis = new FileInputStream(out);
                 BufferedInputStream outBis = new BufferedInputStream(outFis);
                 PositionDataInputStream pdin = new PositionDataInputStream(outBis);){
                i = pdin.readInt();
                if (i != 1245795905) throw new IOException("Unrecognized magic number found in decompressed data: " + i);
                HprofReader r = new HprofReader(deCompressedFile, pdin, dumpNumber, true, debugLevel);
                Snapshot snapshot = r.read();
                return snapshot;
            }
            finally {
                out.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStack(String heapFile, int debugLevel) throws IOException {
        int dumpNumber = 1;
        int pos = heapFile.lastIndexOf(35);
        if (pos > -1) {
            String num = heapFile.substring(pos + 1, heapFile.length());
            try {
                dumpNumber = Integer.parseInt(num, 10);
            }
            catch (NumberFormatException ex) {
                String msg = "In file name \"" + heapFile + "\", a dump number was expected after the :, but \"" + num + "\" was found instead.";
                System.err.println(msg);
                throw new IOException(msg);
            }
            heapFile = heapFile.substring(0, pos);
        }
        try (FileInputStream fis = new FileInputStream(heapFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             PositionDataInputStream in = new PositionDataInputStream(bis);){
            int i = in.readInt();
            if (i == 1245795905) {
                HprofReader r = new HprofReader(heapFile, in, dumpNumber, true, debugLevel);
                r.read();
                String string = r.printStackTraces();
                return string;
            }
            if (i >>> 8 != 2067208) throw new IOException("Unrecognized magic number: " + i);
            in.close();
            String deCompressedFile = "heapdump" + System.currentTimeMillis() + ".hprof";
            File out = new File(deCompressedFile);
            try (FileInputStream heapFis = new FileInputStream(heapFile);
                 GZIPInputStream gis = new GZIPInputStream(heapFis);
                 FileOutputStream fos = new FileOutputStream(out);){
                byte[] buffer = new byte[0x100000];
                int len = 0;
                while ((len = gis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                out.delete();
                throw new IOException("Cannot decompress the compressed hprof file", e);
            }
            try (FileInputStream outFis = new FileInputStream(out);
                 BufferedInputStream outBis = new BufferedInputStream(outFis);
                 PositionDataInputStream pdin = new PositionDataInputStream(outBis);){
                i = pdin.readInt();
                if (i != 1245795905) throw new IOException("Unrecognized magic number found in decompressed data: " + i);
                HprofReader r = new HprofReader(deCompressedFile, pdin, dumpNumber, true, debugLevel);
                r.read();
                String string = r.printStackTraces();
                return string;
            }
            finally {
                out.delete();
            }
        }
    }
}

