/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: malloc_statePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the malloc_statePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=malloc_state.class)
public class malloc_statePointer extends StructurePointer {

	// NULL
	public static final malloc_statePointer NULL = new malloc_statePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected malloc_statePointer(long address) {
		super(address);
	}

	public static malloc_statePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static malloc_statePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static malloc_statePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new malloc_statePointer(address);
	}

	public malloc_statePointer add(long count) {
		return malloc_statePointer.cast(address + (malloc_state.SIZEOF * count));
	}

	public malloc_statePointer add(Scalar count) {
		return add(count.longValue());
	}

	public malloc_statePointer addOffset(long offset) {
		return malloc_statePointer.cast(address + offset);
	}

	public malloc_statePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public malloc_statePointer sub(long count) {
		return malloc_statePointer.cast(address - (malloc_state.SIZEOF * count));
	}

	public malloc_statePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public malloc_statePointer subOffset(long offset) {
		return malloc_statePointer.cast(address - offset);
	}

	public malloc_statePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public malloc_statePointer untag(long mask) {
		return malloc_statePointer.cast(address & ~mask);
	}

	public malloc_statePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return malloc_state.SIZEOF;
	}

	// Implementation methods

	// mchunkptr dv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dvOffset_", declaredType="mchunkptr")
	public malloc_chunkPointer dv() throws CorruptDataException {
		return malloc_chunkPointer.cast(getPointerAtOffset(malloc_state._dvOffset_));
	}

	// mchunkptr dv
	public PointerPointer dvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._dvOffset_));
	}

	// size_t dvsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dvsizeOffset_", declaredType="size_t")
	public UDATA dvsize() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_state._dvsizeOffset_));
	}

	// size_t dvsize
	public UDATAPointer dvsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._dvsizeOffset_));
	}

	// size_t footprint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_footprintOffset_", declaredType="size_t")
	public UDATA footprint() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_state._footprintOffset_));
	}

	// size_t footprint
	public UDATAPointer footprintEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._footprintOffset_));
	}

	// U8* least_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_least_addrOffset_", declaredType="U8*")
	public U8Pointer least_addr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(malloc_state._least_addrOffset_));
	}

	// U8* least_addr
	public PointerPointer least_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._least_addrOffset_));
	}

	// size_t magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_magicOffset_", declaredType="size_t")
	public UDATA magic() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_state._magicOffset_));
	}

	// size_t magic
	public UDATAPointer magicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._magicOffset_));
	}

	// size_t max_footprint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_footprintOffset_", declaredType="size_t")
	public UDATA max_footprint() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_state._max_footprintOffset_));
	}

	// size_t max_footprint
	public UDATAPointer max_footprintEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._max_footprintOffset_));
	}

	// flag_t mflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mflagsOffset_", declaredType="flag_t")
	public UDATA mflags() throws CorruptDataException {
		return new U32(getIntAtOffset(malloc_state._mflagsOffset_));
	}

	// flag_t mflags
	public UDATAPointer mflagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._mflagsOffset_));
	}

	// pthread_mutex_t mutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mutexOffset_", declaredType="pthread_mutex_t")
	public pthread_mutex_tPointer mutex() throws CorruptDataException {
		return pthread_mutex_tPointer.cast(nonNullFieldEA(malloc_state._mutexOffset_));
	}

	// pthread_mutex_t mutex
	public PointerPointer mutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._mutexOffset_));
	}

	// msegment seg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_segOffset_", declaredType="msegment")
	public malloc_segmentPointer seg() throws CorruptDataException {
		return malloc_segmentPointer.cast(nonNullFieldEA(malloc_state._segOffset_));
	}

	// msegment seg
	public PointerPointer segEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._segOffset_));
	}

	// mchunkptr[] smallbins
	public PointerPointer smallbinsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._smallbinsOffset_));
	}

	// binmap_t smallmap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_smallmapOffset_", declaredType="binmap_t")
	public UDATA smallmap() throws CorruptDataException {
		return new U32(getIntAtOffset(malloc_state._smallmapOffset_));
	}

	// binmap_t smallmap
	public UDATAPointer smallmapEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._smallmapOffset_));
	}

	// mchunkptr top
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_topOffset_", declaredType="mchunkptr")
	public malloc_chunkPointer top() throws CorruptDataException {
		return malloc_chunkPointer.cast(getPointerAtOffset(malloc_state._topOffset_));
	}

	// mchunkptr top
	public PointerPointer topEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._topOffset_));
	}

	// size_t topsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_topsizeOffset_", declaredType="size_t")
	public UDATA topsize() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_state._topsizeOffset_));
	}

	// size_t topsize
	public UDATAPointer topsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._topsizeOffset_));
	}

	// tbinptr[] treebins
	public PointerPointer treebinsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_state._treebinsOffset_));
	}

	// binmap_t treemap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_treemapOffset_", declaredType="binmap_t")
	public UDATA treemap() throws CorruptDataException {
		return new U32(getIntAtOffset(malloc_state._treemapOffset_));
	}

	// binmap_t treemap
	public UDATAPointer treemapEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._treemapOffset_));
	}

	// size_t trim_check
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_trim_checkOffset_", declaredType="size_t")
	public UDATA trim_check() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_state._trim_checkOffset_));
	}

	// size_t trim_check
	public UDATAPointer trim_checkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_state._trim_checkOffset_));
	}

}
