/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32C;
import jdk.test.lib.Asserts;
import jdk.test.lib.NetworkConfiguration;
import jdk.test.lib.Platform;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public final class Utils {
    public static final String TEST_CLASS_PATH = System.getProperty("test.class.path", ".");
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String VM_OPTIONS = System.getProperty("test.vm.opts", "").trim();
    public static final String JAVA_OPTIONS = System.getProperty("test.java.opts", "").trim();
    public static final String TEST_SRC = System.getProperty("test.src", "").trim();
    public static final String TEST_ROOT = System.getProperty("test.root", "").trim();
    public static final String TEST_JDK = System.getProperty("test.jdk");
    public static final String COMPILE_JDK = System.getProperty("compile.jdk", TEST_JDK);
    public static final String TEST_CLASSES = System.getProperty("test.classes", ".");
    public static final String TEST_NAME = System.getProperty("test.name", ".");
    public static final String TEST_NATIVE_PATH = System.getProperty("test.nativepath", ".");
    public static final String SEED_PROPERTY_NAME = "jdk.test.lib.random.seed";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static volatile Random RANDOM_GENERATOR;
    private static final int MAX_SOCKET_TRIES = 10;
    public static final long SEED;
    public static final double TIMEOUT_FACTOR;
    public static final long DEFAULT_TEST_TIMEOUT;
    private static final Pattern useGcPattern;
    private static Map<Class<?>, Object> NULL_VALUES;

    private Utils() {
    }

    public static List<String> getForwardVmOptions() {
        String[] opts = Utils.safeSplitString(VM_OPTIONS);
        for (int i = 0; i < opts.length; ++i) {
            opts[i] = "-J" + opts[i];
        }
        return Arrays.asList(opts);
    }

    public static String[] getTestJavaOpts() {
        ArrayList opts = new ArrayList();
        Collections.addAll(opts, Utils.safeSplitString(VM_OPTIONS));
        Collections.addAll(opts, Utils.safeSplitString(JAVA_OPTIONS));
        return opts.toArray(new String[0]);
    }

    public static String[] prependTestJavaOpts(String ... userArgs) {
        ArrayList opts = new ArrayList();
        Collections.addAll(opts, Utils.getTestJavaOpts());
        Collections.addAll(opts, userArgs);
        return opts.toArray(new String[0]);
    }

    public static String[] appendTestJavaOpts(String ... userArgs) {
        ArrayList opts = new ArrayList();
        Collections.addAll(opts, userArgs);
        Collections.addAll(opts, Utils.getTestJavaOpts());
        return opts.toArray(new String[0]);
    }

    public static String[] addTestJavaOpts(String ... userArgs) {
        return Utils.prependTestJavaOpts(userArgs);
    }

    public static List<String> removeGcOpts(List<String> opts) {
        ArrayList<String> optsWithoutGC = new ArrayList<String>();
        for (String opt : opts) {
            if (useGcPattern.matcher(opt).matches()) {
                System.out.println("removeGcOpts: removed " + opt);
                continue;
            }
            optsWithoutGC.add(opt);
        }
        return optsWithoutGC;
    }

    public static String[] getFilteredTestJavaOpts(String ... filters) {
        String[] options = Utils.getTestJavaOpts();
        if (filters.length == 0) {
            return options;
        }
        ArrayList<String> filteredOptions = new ArrayList<String>(options.length);
        Pattern[] patterns = new Pattern[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            patterns[i] = Pattern.compile(filters[i]);
        }
        for (String option : options) {
            boolean matched = false;
            for (int i = 0; i < patterns.length && !matched; ++i) {
                Matcher matcher = patterns[i].matcher(option);
                matched = matcher.find();
            }
            if (matched) continue;
            filteredOptions.add(option);
        }
        return filteredOptions.toArray(new String[filteredOptions.size()]);
    }

    private static String[] safeSplitString(String s) {
        if (s == null || s.trim().isEmpty()) {
            return new String[0];
        }
        return s.trim().split("\\s+");
    }

    public static String getCommandLine(ProcessBuilder pb) {
        StringBuilder cmd = new StringBuilder();
        for (String s : pb.command()) {
            cmd.append(s).append(" ");
        }
        return cmd.toString();
    }

    public static InetSocketAddress refusingEndpoint() {
        InetAddress lb = InetAddress.getLoopbackAddress();
        for (int port = 1; port < 1024; ++port) {
            InetSocketAddress sa = new InetSocketAddress(lb, port);
            try {
                SocketChannel.open(sa).close();
                continue;
            }
            catch (IOException ioe) {
                return sa;
            }
        }
        throw new RuntimeException("Unable to find system port that is refusing connections");
    }

    public static List<InetAddress> getAddressesWithSymbolicAndNumericScopes() {
        LinkedList<InetAddress> result = new LinkedList<InetAddress>();
        try {
            NetworkConfiguration conf = NetworkConfiguration.probe();
            conf.ip4Addresses().forEach(result::add);
            conf.ip6Addresses().filter(addr -> addr.isLinkLocalAddress() || addr.isLoopbackAddress()).forEach(addr6 -> {
                try {
                    result.add(Inet6Address.getByAddress(null, addr6.getAddress(), addr6.getScopeId()));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException("Unexpected", e);
                }
                if (!Platform.isWindows()) {
                    result.add((InetAddress)addr6);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
        return result;
    }

    public static int getFreePort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0, 5, InetAddress.getLoopbackAddress());){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    public static int findUnreservedFreePort(int ... reservedPorts) {
        int numTries = 0;
        while (numTries++ < 10) {
            int port = -1;
            try {
                port = Utils.getFreePort();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (port <= 0 || Utils.isReserved(port, reservedPorts)) continue;
            return port;
        }
        return -1;
    }

    private static boolean isReserved(int port, int[] reservedPorts) {
        for (int p : reservedPorts) {
            if (p != port) continue;
            return true;
        }
        return false;
    }

    public static String getHostname() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String hostName = inetAddress.getHostName();
        Asserts.assertTrue(hostName != null && !hostName.isEmpty(), "Cannot get hostname");
        return hostName;
    }

    public static long adjustTimeout(long tOut) {
        return Math.round((double)tOut * TIMEOUT_FACTOR);
    }

    public static String fileAsString(String filename) throws IOException {
        Path filePath = Paths.get(filename, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return null;
        }
        return new String(Files.readAllBytes(filePath));
    }

    @Deprecated
    public static String toHexString(byte[] bytes) {
        return HexFormat.ofDelimiter(" ").withUpperCase().formatHex(bytes);
    }

    public static byte[] toByteArray(String hex) {
        return HexFormat.of().parseHex(hex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Random getRandomInstance() {
        if (RANDOM_GENERATOR != null) return RANDOM_GENERATOR;
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            if (RANDOM_GENERATOR != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return RANDOM_GENERATOR;
            }
            RANDOM_GENERATOR = new Random(SEED);
            // ** MonitorExit[var0] (shouldn't be in output)
            System.out.printf("For random generator using seed: %d%n", SEED);
            System.out.printf("To re-run test with same seed value please add \"-D%s=%d\" to command line.%n", SEED_PROPERTY_NAME, SEED);
            return RANDOM_GENERATOR;
        }
    }

    public static <T> T getRandomElement(Collection<T> collection) throws IllegalArgumentException {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty collection");
        }
        Random random = Utils.getRandomInstance();
        int elementIndex = 1 + random.nextInt(collection.size() - 1);
        Iterator<T> iterator = collection.iterator();
        while (--elementIndex != 0) {
            iterator.next();
        }
        return iterator.next();
    }

    public static <T> T getRandomElement(T[] array) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Empty or null array");
        }
        Random random = Utils.getRandomInstance();
        return array[random.nextInt(array.length)];
    }

    public static final void waitForCondition(BooleanSupplier condition) {
        Utils.waitForCondition(condition, -1L, 100L);
    }

    public static final boolean waitForCondition(BooleanSupplier condition, long timeout) {
        return Utils.waitForCondition(condition, timeout, 100L);
    }

    public static final boolean waitForCondition(BooleanSupplier condition, long timeout, long sleepTime) {
        long startTime = System.currentTimeMillis();
        while (!(condition.getAsBoolean() || timeout != -1L && System.currentTimeMillis() - startTime > timeout)) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error(e);
            }
        }
        return condition.getAsBoolean();
    }

    public static Throwable filterException(ThrowingRunnable test, Function<Throwable, Boolean> filter) throws Throwable {
        try {
            test.run();
        }
        catch (Throwable t) {
            if (filter.apply(t).booleanValue()) {
                return t;
            }
            throw t;
        }
        return null;
    }

    public static void ensureClassIsLoaded(Class<?> aClass) {
        if (aClass == null) {
            throw new Error("Requested null class");
        }
        try {
            Class.forName(aClass.getName(), true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new Error("Class not found", e);
        }
    }

    public static URLClassLoader getTestClassPathURLClassLoader(ClassLoader parent) {
        URL[] urls = (URL[])Arrays.stream(TEST_CLASS_PATH.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toUri).map(x -> {
            try {
                return x.toURL();
            }
            catch (MalformedURLException ex) {
                throw new Error("Test issue. JTREG property 'test.class.path' is not defined correctly", ex);
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(urls, parent);
    }

    public static void runAndCheckException(ThrowingRunnable runnable, Class<? extends Throwable> expectedException) {
        Utils.runAndCheckException(runnable, (Throwable t) -> {
            if (t == null) {
                if (expectedException != null) {
                    throw new AssertionError((Object)("Didn't get expected exception " + expectedException.getSimpleName()));
                }
            } else {
                String message = "Got unexpected exception " + t.getClass().getSimpleName();
                if (expectedException == null) {
                    throw new AssertionError(message, (Throwable)t);
                }
                if (!expectedException.isAssignableFrom(t.getClass())) {
                    message = message + " instead of " + expectedException.getSimpleName();
                    throw new AssertionError(message, (Throwable)t);
                }
            }
        });
    }

    public static void runAndCheckException(ThrowingRunnable runnable, Consumer<Throwable> checkException) {
        Throwable throwable = null;
        try {
            runnable.run();
        }
        catch (Throwable t) {
            throwable = t;
        }
        checkException.accept(throwable);
    }

    public static String toJVMTypeSignature(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new Error("Unsupported type: " + String.valueOf(type));
        }
        String result = type.getName().replaceAll("\\.", "/");
        if (!type.isArray()) {
            return "L" + result + ";";
        }
        return result;
    }

    public static Object[] getNullValues(Class<?> ... types) {
        Object[] result = new Object[types.length];
        int i = 0;
        for (Class<?> type : types) {
            result[i++] = NULL_VALUES.get(type);
        }
        return result;
    }

    public static OutputAnalyzer uname(String ... args) throws Throwable {
        String[] cmds = new String[args.length + 1];
        cmds[0] = "uname";
        System.arraycopy(args, 0, cmds, 1, args.length);
        return ProcessTools.executeCommand(cmds);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        Path dir = Paths.get(System.getProperty("user.dir", "."), new String[0]);
        return Files.createTempFile(dir, prefix, suffix, attrs);
    }

    public static Path createTempFileOfSize(String prefix, String suffix, long size, FileAttribute<?> ... attrs) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("file size cannot be negative: " + size);
        }
        int prime1 = Integer.MAX_VALUE;
        int prime2 = 1047483649;
        int seed = Long.hashCode(SEED);
        Path path = Utils.createTempFile(prefix, suffix, attrs);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.US_ASCII, new OpenOption[0]);){
            long remainingSize = size;
            int rowIndex = 0;
            while (remainingSize > 0L) {
                for (int colIndex = 0; remainingSize > 0L && colIndex < 80; --remainingSize, ++colIndex) {
                    int r = (rowIndex ^ seed) * prime1 ^ (colIndex ^ seed) * prime2;
                    char c = (char)(33 + Math.abs(r) % 93);
                    writer.append(c);
                }
                if (remainingSize > (long)System.lineSeparator().length()) {
                    writer.write(System.lineSeparator());
                    remainingSize -= (long)System.lineSeparator().length();
                }
                ++rowIndex;
            }
        }
        return path;
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        Path dir = Paths.get(System.getProperty("user.dir", "."), new String[0]);
        return Files.createTempDirectory(dir, prefix, attrs);
    }

    public static String convertPath(String path) {
        if (FILE_SEPARATOR.length() == 1 && FILE_SEPARATOR.charAt(0) == '/') {
            return path;
        }
        char[] cs = path.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != '/') continue;
            cs[i] = 92;
        }
        String newPath = new String(cs);
        return newPath;
    }

    public static List<Path> findFiles(Path searchDirectory, FilenameFilter filter) {
        return Arrays.stream(searchDirectory.toFile().listFiles(filter)).map(f -> f.toPath()).collect(Collectors.toList());
    }

    public static List<Path> copyFiles(List<Path> source, Path target, Function<String, String> filenameMapper, CopyOption ... options) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        if (!target.toFile().exists()) {
            Files.createDirectory(target, new FileAttribute[0]);
        }
        for (Path file : source) {
            if (!file.toFile().exists()) continue;
            String baseName = file.getFileName().toString();
            Path targetFile = target.resolve(filenameMapper.apply(baseName));
            Files.copy(file, targetFile, options);
            result.add(targetFile);
        }
        return result;
    }

    public static List<Path> copyFiles(List<Path> source, Path target, CopyOption ... options) throws IOException {
        return Utils.copyFiles(source, target, (String s) -> s, options);
    }

    public static void replaceFileString(Path source, Function<String, String> contentMapper) throws IOException {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        try (BufferedReader reader = new BufferedReader(new FileReader(source.toFile()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(contentMapper.apply(line)).append(lineSep);
            }
        }
        try (FileWriter writer = new FileWriter(source.toFile());){
            writer.write(sb.toString());
        }
    }

    public static void replaceFilesString(List<Path> source, Function<String, String> contentMapper) throws IOException {
        for (Path file : source) {
            Utils.replaceFileString(file, contentMapper);
        }
    }

    public static void grantFileAccess(Path file, boolean userOnly) throws IOException {
        Set<String> attr = file.getFileSystem().supportedFileAttributeViews();
        if (attr.contains("posix")) {
            String perms = userOnly ? "rwx------" : "rwxrwxrwx";
            Files.setPosixFilePermissions(file, PosixFilePermissions.fromString(perms));
        } else if (attr.contains("acl")) {
            AclFileAttributeView view = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
            ArrayList<AclEntry> acl = new ArrayList<AclEntry>();
            for (AclEntry thisEntry : view.getAcl()) {
                if (userOnly) {
                    if (thisEntry.principal().getName().equals(view.getOwner().getName())) {
                        acl.add(Utils.allowAccess(thisEntry));
                        continue;
                    }
                    if (thisEntry.type() == AclEntryType.ALLOW) {
                        acl.add(Utils.revokeAccess(thisEntry));
                        continue;
                    }
                    acl.add(thisEntry);
                    continue;
                }
                if (thisEntry.type() != AclEntryType.ALLOW) {
                    acl.add(Utils.allowAccess(thisEntry));
                    continue;
                }
                acl.add(thisEntry);
            }
            view.setAcl(acl);
        } else {
            throw new RuntimeException("Unsupported file attributes: " + String.valueOf(attr));
        }
    }

    public static AclEntry revokeAccess(AclEntry acl) {
        return Utils.buildAclEntry(acl, AclEntryType.DENY);
    }

    public static AclEntry allowAccess(AclEntry acl) {
        return Utils.buildAclEntry(acl, AclEntryType.ALLOW);
    }

    public static AclEntry buildAclEntry(AclEntry acl, AclEntryType type) {
        return AclEntry.newBuilder(acl).setType(type).build();
    }

    public static void userAccess(Path file) throws IOException {
        Utils.grantFileAccess(file, true);
    }

    public static void fullAccess(Path file) throws IOException {
        Utils.grantFileAccess(file, false);
    }

    static {
        Long seed = Long.getLong(SEED_PROPERTY_NAME);
        if (seed != null) {
            SEED = seed;
        } else {
            Runtime.Version v = Runtime.version();
            if (v.build().orElse(0) > 0) {
                byte[] bytes = v.toString().getBytes(StandardCharsets.UTF_8);
                CRC32C crc = new CRC32C();
                crc.update(bytes);
                SEED = crc.getValue();
            } else {
                SEED = new Random().nextLong();
            }
        }
        String toFactor = System.getProperty("test.timeout.factor", "1.0");
        TIMEOUT_FACTOR = Double.parseDouble(toFactor);
        DEFAULT_TEST_TIMEOUT = TimeUnit.SECONDS.toMillis(120L);
        useGcPattern = Pattern.compile("(?:\\-XX\\:[\\+\\-]Use.+GC)");
        NULL_VALUES = new HashMap();
        NULL_VALUES.put(Boolean.TYPE, false);
        NULL_VALUES.put(Byte.TYPE, (byte)0);
        NULL_VALUES.put(Short.TYPE, (short)0);
        NULL_VALUES.put(Character.TYPE, Character.valueOf('\u0000'));
        NULL_VALUES.put(Integer.TYPE, 0);
        NULL_VALUES.put(Long.TYPE, 0L);
        NULL_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        NULL_VALUES.put(Double.TYPE, 0.0);
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

