/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassModel;
import java.lang.constant.ClassDesc;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import jdk.test.lib.compiler.InMemoryJavaCompiler;
import jdk.test.lib.helpers.ClassFileInstaller;

public class RedefineClassHelper {
    public static Instrumentation instrumentation;

    public static void premain(String agentArgs, Instrumentation inst) {
        instrumentation = inst;
    }

    public static void redefineClass(Class<?> clazz, String javacode) throws Exception {
        byte[] bytecode = InMemoryJavaCompiler.compile(clazz.getName(), javacode, new String[0]);
        RedefineClassHelper.redefineClass(clazz, bytecode);
    }

    public static void redefineClass(Class<?> clazz, byte[] bytecode) throws Exception {
        instrumentation.redefineClasses(new ClassDefinition(clazz, bytecode));
    }

    private static byte[] getBytecodes(ClassLoader loader, String name) throws Exception {
        try (InputStream is = loader.getResourceAsStream(name + ".class");){
            byte[] buf = is.readAllBytes();
            System.out.println("sizeof(" + name + ".class) == " + buf.length);
            byte[] byArray = buf;
            return byArray;
        }
    }

    public static byte[] replaceClassName(byte[] bytes, String newClassName) throws Exception {
        ClassModel classModel = ClassFile.of().parse(bytes);
        return ClassFile.of().build(ClassDesc.of(newClassName), arg_0 -> ((ClassModel)classModel).forEach(arg_0));
    }

    public static byte[] replaceClassName(ClassLoader loader, String oldClassName, String newClassName) throws Exception {
        byte[] buf = RedefineClassHelper.getBytecodes(loader, oldClassName);
        return RedefineClassHelper.replaceClassName(buf, newClassName);
    }

    public static void main(String[] args) throws Exception {
        String manifest = "Premain-Class: RedefineClassHelper\nCan-Redefine-Classes: true\n";
        ClassFileInstaller.writeJar("redefineagent.jar", ClassFileInstaller.Manifest.fromString(manifest), "RedefineClassHelper");
    }
}

