/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.spi.ToolProvider;
import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.StringArrayUtils;
import jdk.test.lib.cds.CDSTestUtils;
import jdk.test.lib.compiler.CompilerUtils;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;
import jdk.test.lib.util.FileUtils;

public class CDSJarUtils {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("CDSJarUtils.DEBUG", "false"));
    private static final String classDir = System.getProperty("test.classes");
    private static final ToolProvider JAR = ToolProvider.findFirst("jar").orElseThrow(() -> new RuntimeException("ToolProvider for jar not found"));
    static final String keyTool = JDKToolFinder.getJDKTool("keytool");
    static final String jarSigner = JDKToolFinder.getJDKTool("jarsigner");

    public static String getJarFilePath(String jarName) {
        return CDSTestUtils.getOutputDir() + File.separator + jarName + ".jar";
    }

    public static String build(String jarName, File dir, String man, String ... versionArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (man != null) {
            args.add("cfm");
        } else {
            args.add("cf");
        }
        String jarFile = CDSJarUtils.getJarFilePath(jarName);
        args.add(jarFile);
        if (man != null) {
            args.add(man);
        }
        args.add("-C");
        args.add(dir.getAbsolutePath());
        args.add(".");
        for (String verArg : versionArgs) {
            args.add(verArg);
        }
        CDSJarUtils.createJar(args);
        return jarFile;
    }

    public static String build(String jarName, String ... classNames) throws Exception {
        return CDSJarUtils.createSimpleJar(classDir, CDSJarUtils.getJarFilePath(jarName), classNames);
    }

    public static String build(boolean classesInWorkDir, String jarName, String ... classNames) throws Exception {
        if (classesInWorkDir) {
            return CDSJarUtils.createSimpleJar(".", CDSJarUtils.getJarFilePath(jarName), classNames);
        }
        return CDSJarUtils.build(jarName, classNames);
    }

    public static String buildWithManifest(String jarName, String manifest, String jarClassesDir, String ... classNames) throws Exception {
        String jarPath = CDSJarUtils.getJarFilePath(jarName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("cvfm");
        args.add(jarPath);
        args.add(System.getProperty("test.src") + File.separator + "test-classes" + File.separator + manifest);
        CDSJarUtils.addClassArgs(args, jarClassesDir, classNames);
        CDSJarUtils.createJar(args);
        return jarPath;
    }

    public static void update(String jarFile, String dir) throws Exception {
        String jarExe = JDKToolFinder.getJDKTool("jar");
        ArrayList<String> args = new ArrayList<String>();
        args.add(jarExe);
        args.add("uvf");
        args.add(jarFile);
        args.add("-C");
        args.add(dir);
        args.add(".");
        CDSJarUtils.executeProcess(args.toArray(new String[1]));
    }

    private static String createSimpleJar(String jarclassDir, String jarName, String[] classNames) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("cf");
        args.add(jarName);
        CDSJarUtils.addClassArgs(args, jarclassDir, classNames);
        CDSJarUtils.createJar(args);
        return jarName;
    }

    private static void addClassArgs(ArrayList<String> args, String jarclassDir, String[] classNames) {
        for (String name : classNames) {
            args.add("-C");
            args.add(jarclassDir);
            args.add(name + ".class");
        }
    }

    public static void buildFromDirectory(String jarPath, String classesDir) throws Exception {
        CDSJarUtils.buildFromDirectory(jarPath, classesDir, null);
    }

    public static void buildFromDirectory(String jarPath, String classesDir, JarOptions jarOptions) throws Exception {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("--create");
        argList.add("--file=" + jarPath);
        if (jarOptions != null) {
            for (String s : jarOptions.options) {
                argList.add(s);
            }
        }
        argList.add("-C");
        argList.add(classesDir);
        argList.add(".");
        CDSJarUtils.createJar(argList);
    }

    public static void buildFromSourceDirectory(String jarName, String srcDir, String ... extraJavacArgs) throws Exception {
        CDSJarUtils.buildFromSourceDirectory(jarName, srcDir, null, extraJavacArgs);
    }

    public static void buildFromSourceDirectory(String jarName, String srcDir, JarOptions jarOptions, String ... extraJavacArgs) throws Exception {
        System.out.print("Compiling " + srcDir + " into " + jarName);
        if (extraJavacArgs.length > 0) {
            System.out.print(" with");
            for (String s : extraJavacArgs) {
                System.out.print(" " + s);
            }
        }
        System.out.println();
        Path dst = Files.createTempDirectory(Paths.get("", new String[0]), "tmp-classes", new FileAttribute[0]);
        if (!CompilerUtils.compile(Paths.get(srcDir, new String[0]), dst, extraJavacArgs)) {
            throw new RuntimeException("Compilation of " + srcDir + " failed");
        }
        CDSJarUtils.buildFromDirectory(jarName, dst.toString(), jarOptions);
        try {
            FileUtils.deleteFileTreeWithRetry(dst);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createJar(ArrayList<String> args) {
        if (DEBUG) {
            CDSJarUtils.printIterable("createJar args: ", args);
        }
        if (JAR.run(System.out, System.err, args.toArray(new String[1])) != 0) {
            throw new RuntimeException("jar operation failed");
        }
    }

    public static String getOrCreateHelloJar() throws Exception {
        String jarPath = CDSJarUtils.getJarFilePath("hello");
        File jarFile = new File(jarPath);
        if (jarFile.exists()) {
            return jarPath;
        }
        return CDSJarUtils.build("hello", "Hello");
    }

    public static void compile(String dstPath, String source, String ... extraArgs) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(JDKToolFinder.getCompileJDKTool("javac"));
        args.add("-d");
        args.add(dstPath);
        if (extraArgs != null) {
            for (String s : extraArgs) {
                args.add(s);
            }
        }
        args.add(source);
        if (DEBUG) {
            CDSJarUtils.printIterable("compile args: ", args);
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        OutputAnalyzer output = new OutputAnalyzer(pb.start());
        output.shouldHaveExitValue(0);
    }

    public static void compileModule(Path src, Path dest, String modulePathArg) throws Exception {
        boolean compiled = false;
        compiled = modulePathArg == null ? CompilerUtils.compile(src, dest, new String[0]) : CompilerUtils.compile(src, dest, "--module-path", modulePathArg);
        if (!compiled) {
            throw new RuntimeException("module did not compile");
        }
    }

    public static void signJarWithDisabledAlgorithm(String jarName) throws Exception {
        String keyName = "key_with_disabled_alg";
        CDSJarUtils.executeProcess(keyTool, "-genkey", "-keystore", "./keystore", "-alias", keyName, "-storepass", "abc123", "-keypass", "abc123", "-keyalg", "dsa", "-sigalg", "SHA1withDSA", "-keysize", "512", "-dname", "CN=jvmtest2").shouldHaveExitValue(0);
        CDSJarUtils.doSigning(jarName, keyName);
    }

    public static void signJar(String jarName) throws Exception {
        String keyName = "mykey";
        CDSJarUtils.executeProcess(keyTool, "-genkey", "-keystore", "./keystore", "-alias", keyName, "-storepass", "abc123", "-keypass", "abc123", "-keyalg", "dsa", "-dname", "CN=jvmtest").shouldHaveExitValue(0);
        CDSJarUtils.doSigning(jarName, keyName);
    }

    private static void doSigning(String jarName, String keyName) throws Exception {
        CDSJarUtils.executeProcess(jarSigner, "-keystore", "./keystore", "-storepass", "abc123", "-keypass", "abc123", "-signedjar", CDSJarUtils.getJarFilePath("signed_" + jarName), CDSJarUtils.getJarFilePath(jarName), keyName).shouldHaveExitValue(0);
    }

    private static OutputAnalyzer executeProcess(String ... cmds) throws Exception {
        CDSJarUtils.printArray("executeProcess: ", cmds);
        return ProcessTools.executeProcess(new ProcessBuilder(cmds));
    }

    public static void printIterable(String msg, Iterable<String> l) {
        StringBuilder sum = new StringBuilder();
        for (String s : l) {
            sum.append(s).append(' ');
        }
        System.out.println(msg + sum.toString());
    }

    public static void printArray(String msg, String[] l) {
        StringBuilder sum = new StringBuilder();
        for (String s : l) {
            sum.append(s).append(' ');
        }
        System.out.println(msg + sum.toString());
    }

    public static class JarOptions {
        private String[] options;

        private JarOptions() {
        }

        public static JarOptions of(String ... options) {
            JarOptions jo = new JarOptions();
            jo.options = options;
            return jo;
        }

        public JarOptions setMainClass(String mainClass) {
            if (mainClass != null) {
                this.options = StringArrayUtils.concat(this.options, new String[]{"--main-class=" + mainClass});
            }
            return this;
        }

        public JarOptions setManifest(String manifest) {
            if (manifest != null) {
                this.options = StringArrayUtils.concat(this.options, new String[]{"--manifest=" + manifest});
            }
            return this;
        }
    }
}

