/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.util.ArrayList;
import java.util.Collections;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public class AppExecutorHelper {
    public static OutputAnalyzer executeAndRecord(String settings, String jfrFilename, String[] additionalVmFlags, String className, String ... classArguments) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        String baseStartFlightRecording = "-XX:StartFlightRecording";
        String additionalStartFlightRecording = "";
        if (additionalVmFlags != null) {
            Collections.addAll(arguments, additionalVmFlags);
        }
        if (settings != null & jfrFilename != null) {
            additionalStartFlightRecording = String.format("=settings=%s,filename=%s", settings, jfrFilename);
        } else if (settings != null) {
            additionalStartFlightRecording = String.format("=settings=%s", settings);
        } else if (jfrFilename != null) {
            additionalStartFlightRecording = String.format("=filename=%s", jfrFilename);
        }
        arguments.add(baseStartFlightRecording + additionalStartFlightRecording);
        arguments.add(className);
        if (classArguments.length > 0) {
            Collections.addAll(arguments, classArguments);
        }
        ProcessBuilder pb = ProcessTools.createTestJavaProcessBuilder(arguments);
        return ProcessTools.executeProcess(pb);
    }
}

