/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import jdk.test.lib.Platform;
import jdk.test.lib.Utils;
import jdk.test.lib.management.InputArguments;
import jdk.test.lib.process.ExitCode;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public abstract class CommandLineOptionTest {
    public static final String UNLOCK_DIAGNOSTIC_VM_OPTIONS = "-XX:+UnlockDiagnosticVMOptions";
    public static final String UNLOCK_EXPERIMENTAL_VM_OPTIONS = "-XX:+UnlockExperimentalVMOptions";
    protected static final String UNRECOGNIZED_OPTION_ERROR_FORMAT = "Unrecognized VM option '[+-]?%s(=.*)?'";
    protected static final String EXPERIMENTAL_OPTION_ERROR_FORMAT = "VM option '%s' is experimental and must be enabled via -XX:\\+UnlockExperimentalVMOptions.";
    protected static final String DIAGNOSTIC_OPTION_ERROR_FORMAT = " VM option '%s' is diagnostic and must be enabled via -XX:\\+UnlockDiagnosticVMOptions.";
    private static final String PRINT_FLAGS_FINAL_FORMAT = "%s\\s*:?=\\s*%s";
    private final BooleanSupplier predicate;

    public static void verifyJVMStartup(String option, String[] expectedMessages, String[] unexpectedMessages, String exitErrorMessage, String wrongWarningMessage, ExitCode exitCode) throws Throwable {
        CommandLineOptionTest.verifyJVMStartup(expectedMessages, unexpectedMessages, exitErrorMessage, wrongWarningMessage, exitCode, false, option);
    }

    public static void verifyJVMStartup(String[] expectedMessages, String[] unexpectedMessages, String exitErrorMessage, String wrongWarningMessage, ExitCode exitCode, boolean addTestVMOptions, String ... options) throws Throwable {
        ArrayList<String> finalOptions = new ArrayList<String>();
        if (addTestVMOptions) {
            Collections.addAll(finalOptions, InputArguments.getVmInputArgs());
            Collections.addAll(finalOptions, Utils.getTestJavaOpts());
        }
        Collections.addAll(finalOptions, options);
        finalOptions.add("-version");
        ProcessBuilder processBuilder = ProcessTools.createLimitedTestJavaProcessBuilder(finalOptions.toArray(new String[finalOptions.size()]));
        OutputAnalyzer outputAnalyzer = new OutputAnalyzer(processBuilder.start());
        try {
            outputAnalyzer.shouldHaveExitValue(exitCode.value);
        }
        catch (RuntimeException e) {
            String errorMessage = String.format("JVM process should have exit value '%d', but has '%d'.%n%s", exitCode.value, outputAnalyzer.getExitValue(), exitErrorMessage);
            throw new AssertionError(errorMessage, e);
        }
        CommandLineOptionTest.verifyOutput(expectedMessages, unexpectedMessages, wrongWarningMessage, outputAnalyzer);
    }

    public static void verifyOutput(String[] expectedMessages, String[] unexpectedMessages, String wrongWarningMessage, OutputAnalyzer outputAnalyzer) {
        if (expectedMessages != null) {
            for (String expectedMessage : expectedMessages) {
                try {
                    outputAnalyzer.shouldMatch(expectedMessage);
                }
                catch (RuntimeException e) {
                    String errorMessage = String.format("Expected message not found: '%s'.%n%s", expectedMessage, wrongWarningMessage);
                    throw new AssertionError(errorMessage, e);
                }
            }
        }
        if (unexpectedMessages != null) {
            for (String unexpectedMessage : unexpectedMessages) {
                try {
                    outputAnalyzer.shouldNotMatch(unexpectedMessage);
                }
                catch (RuntimeException e) {
                    String errorMessage = String.format("Unexpected message found: '%s'.%n%s", unexpectedMessage, wrongWarningMessage);
                    throw new AssertionError(errorMessage, e);
                }
            }
        }
    }

    public static void verifySameJVMStartup(String[] expectedMessages, String[] unexpectedMessages, String exitErrorMessage, String wrongWarningMessage, ExitCode exitCode, String ... options) throws Throwable {
        String extraFlagForEmulated;
        ArrayList<String> finalOptions = new ArrayList<String>();
        if (!Platform.isStatic()) {
            finalOptions.add(CommandLineOptionTest.getVMTypeOption());
        }
        if ((extraFlagForEmulated = CommandLineOptionTest.getVMTypeOptionForEmulated()) != null) {
            finalOptions.add(extraFlagForEmulated);
        }
        Collections.addAll(finalOptions, options);
        CommandLineOptionTest.verifyJVMStartup(expectedMessages, unexpectedMessages, exitErrorMessage, wrongWarningMessage, exitCode, false, finalOptions.toArray(new String[finalOptions.size()]));
    }

    public static void verifyOptionValue(String optionName, String expectedValue, String optionErrorString, String ... additionalVMOpts) throws Throwable {
        CommandLineOptionTest.verifyOptionValue(optionName, expectedValue, optionErrorString, true, additionalVMOpts);
    }

    public static void verifyOptionValue(String optionName, String expectedValue, String optionErrorString, boolean addTestVmOptions, String ... additionalVMOpts) throws Throwable {
        ArrayList vmOpts = new ArrayList();
        if (addTestVmOptions) {
            Collections.addAll(vmOpts, Utils.getFilteredTestJavaOpts(optionName));
        }
        Collections.addAll(vmOpts, additionalVMOpts);
        Collections.addAll(vmOpts, "-XX:+PrintFlagsFinal", "-version");
        ProcessBuilder processBuilder = ProcessTools.createLimitedTestJavaProcessBuilder(vmOpts.toArray(new String[vmOpts.size()]));
        OutputAnalyzer outputAnalyzer = new OutputAnalyzer(processBuilder.start());
        try {
            outputAnalyzer.shouldHaveExitValue(0);
        }
        catch (RuntimeException e) {
            String errorMessage = String.format("JVM should start with option '%s' without errors.", optionName);
            throw new AssertionError(errorMessage, e);
        }
        CommandLineOptionTest.verifyOptionValue(optionName, expectedValue, optionErrorString, outputAnalyzer);
    }

    public static void verifyOptionValue(String optionName, String expectedValue, String optionErrorString, OutputAnalyzer outputAnalyzer) {
        try {
            outputAnalyzer.shouldMatch(String.format(PRINT_FLAGS_FINAL_FORMAT, optionName, expectedValue));
        }
        catch (RuntimeException e) {
            String observedValue = outputAnalyzer.firstMatch(String.format(PRINT_FLAGS_FINAL_FORMAT, optionName, "\\S"));
            String errorMessage = String.format("Option '%s' is expected to have '%s' value, but is '%s'.%n%s", optionName, expectedValue, observedValue, optionErrorString);
            throw new AssertionError(errorMessage, e);
        }
    }

    public static OutputAnalyzer startVMWithOptions(String[] optionNames, String[] optionValues, String ... additionalVMOpts) throws Throwable {
        ArrayList<String> vmOpts = new ArrayList<String>();
        if (optionNames == null || optionValues == null || optionNames.length != optionValues.length) {
            throw new IllegalArgumentException("optionNames and/or optionValues");
        }
        for (int i = 0; i < optionNames.length; ++i) {
            vmOpts.add(CommandLineOptionTest.prepareFlag(optionNames[i], optionValues[i]));
        }
        Collections.addAll(vmOpts, additionalVMOpts);
        Collections.addAll(vmOpts, "-version");
        ProcessBuilder processBuilder = ProcessTools.createLimitedTestJavaProcessBuilder(vmOpts.toArray(new String[vmOpts.size()]));
        return new OutputAnalyzer(processBuilder.start());
    }

    public static void verifyOptionValuesFromOutput(OutputAnalyzer outputAnalyzer, String[] optionNames, String[] expectedValues) throws Throwable {
        outputAnalyzer.shouldHaveExitValue(0);
        for (int i = 0; i < optionNames.length; ++i) {
            outputAnalyzer.shouldMatch(String.format(PRINT_FLAGS_FINAL_FORMAT, optionNames[i], expectedValues[i]));
        }
    }

    public static void verifyOptionValues(String[] optionNames, String[] expectedValues) throws Throwable {
        OutputAnalyzer outputAnalyzer = CommandLineOptionTest.startVMWithOptions(optionNames, expectedValues, "-XX:+PrintFlagsFinal");
        CommandLineOptionTest.verifyOptionValuesFromOutput(outputAnalyzer, optionNames, expectedValues);
    }

    public static void verifyOptionValueForSameVM(String optionName, String expectedValue, String optionErrorString, String ... additionalVMOpts) throws Throwable {
        String extraFlagForEmulated;
        ArrayList<String> finalOptions = new ArrayList<String>();
        if (!Platform.isStatic()) {
            finalOptions.add(CommandLineOptionTest.getVMTypeOption());
        }
        if ((extraFlagForEmulated = CommandLineOptionTest.getVMTypeOptionForEmulated()) != null) {
            finalOptions.add(extraFlagForEmulated);
        }
        Collections.addAll(finalOptions, additionalVMOpts);
        CommandLineOptionTest.verifyOptionValue(optionName, expectedValue, optionErrorString, false, finalOptions.toArray(new String[finalOptions.size()]));
    }

    public static String prepareBooleanFlag(String name, boolean value) {
        return String.format("-XX:%c%s", Character.valueOf(value ? (char)'+' : '-'), name);
    }

    public static String prepareNumericFlag(String name, Number value) {
        return String.format("-XX:%s=%s", name, value.toString());
    }

    public static String prepareFlag(String name, String value) {
        if (value.equals("+") || value.equalsIgnoreCase("true")) {
            return "-XX:+" + name;
        }
        if (value.equals("-") || value.equalsIgnoreCase("false")) {
            return "-XX:-" + name;
        }
        return "-XX:" + name + "=" + value;
    }

    public static String getUnrecognizedOptionErrorMessage(String optionName) {
        return String.format(UNRECOGNIZED_OPTION_ERROR_FORMAT, optionName);
    }

    public static String getExperimentalOptionErrorMessage(String optionName) {
        return String.format(EXPERIMENTAL_OPTION_ERROR_FORMAT, optionName);
    }

    public static String getDiagnosticOptionErrorMessage(String optionName) {
        return String.format(DIAGNOSTIC_OPTION_ERROR_FORMAT, optionName);
    }

    private static String getVMTypeOption() {
        if (Platform.isServer()) {
            return "-server";
        }
        if (Platform.isClient()) {
            return "-client";
        }
        if (Platform.isMinimal()) {
            return "-minimal";
        }
        if (Platform.isZero()) {
            return "-zero";
        }
        throw new RuntimeException("Unknown VM mode.");
    }

    private static String getVMTypeOptionForEmulated() {
        if (Platform.isServer() && !Platform.isEmulatedClient()) {
            return "-XX:-NeverActAsServerClassMachine";
        }
        if (Platform.isEmulatedClient()) {
            return "-XX:+NeverActAsServerClassMachine";
        }
        return null;
    }

    public CommandLineOptionTest(BooleanSupplier predicate) {
        this.predicate = predicate;
    }

    public final void test() throws Throwable {
        if (this.predicate.getAsBoolean()) {
            this.runTestCases();
        }
    }

    protected abstract void runTestCases() throws Throwable;
}

