/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9RelocationListPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9RelocationListPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9RelocationList.class)
public class J9RelocationListPointer extends StructurePointer {

	// NULL
	public static final J9RelocationListPointer NULL = new J9RelocationListPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9RelocationListPointer(long address) {
		super(address);
	}

	public static J9RelocationListPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9RelocationListPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9RelocationListPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9RelocationListPointer(address);
	}

	public J9RelocationListPointer add(long count) {
		return J9RelocationListPointer.cast(address + (J9RelocationList.SIZEOF * count));
	}

	public J9RelocationListPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9RelocationListPointer addOffset(long offset) {
		return J9RelocationListPointer.cast(address + offset);
	}

	public J9RelocationListPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9RelocationListPointer sub(long count) {
		return J9RelocationListPointer.cast(address - (J9RelocationList.SIZEOF * count));
	}

	public J9RelocationListPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9RelocationListPointer subOffset(long offset) {
		return J9RelocationListPointer.cast(address - offset);
	}

	public J9RelocationListPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9RelocationListPointer untag(long mask) {
		return J9RelocationListPointer.cast(address & ~mask);
	}

	public J9RelocationListPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9RelocationList.SIZEOF;
	}

	// Implementation methods

	// UDATA containsAllZeroRelocations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_containsAllZeroRelocationsOffset_", declaredType="UDATA")
	public UDATA containsAllZeroRelocations() throws CorruptDataException {
		return getUDATAAtOffset(J9RelocationList._containsAllZeroRelocationsOffset_);
	}

	// UDATA containsAllZeroRelocations
	public UDATAPointer containsAllZeroRelocationsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9RelocationList._containsAllZeroRelocationsOffset_));
	}

	// J9JavaVM* globalInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_globalInfoOffset_", declaredType="J9JavaVM*")
	public J9JavaVMPointer globalInfo() throws CorruptDataException {
		return J9JavaVMPointer.cast(getPointerAtOffset(J9RelocationList._globalInfoOffset_));
	}

	// J9JavaVM* globalInfo
	public PointerPointer globalInfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationList._globalInfoOffset_));
	}

	// J9Relocation* lastFound
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lastFoundOffset_", declaredType="J9Relocation*")
	public J9RelocationPointer lastFound() throws CorruptDataException {
		return J9RelocationPointer.cast(getPointerAtOffset(J9RelocationList._lastFoundOffset_));
	}

	// J9Relocation* lastFound
	public PointerPointer lastFoundEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationList._lastFoundOffset_));
	}

	// UDATA relocateROM
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_relocateROMOffset_", declaredType="UDATA")
	public UDATA relocateROM() throws CorruptDataException {
		return getUDATAAtOffset(J9RelocationList._relocateROMOffset_);
	}

	// UDATA relocateROM
	public UDATAPointer relocateROMEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9RelocationList._relocateROMOffset_));
	}

	// J9Pool* relocations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_relocationsOffset_", declaredType="J9Pool*")
	public J9PoolPointer relocations() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(J9RelocationList._relocationsOffset_));
	}

	// J9Pool* relocations
	public PointerPointer relocationsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationList._relocationsOffset_));
	}

	// UDATA sortedElements
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sortedElementsOffset_", declaredType="UDATA")
	public UDATA sortedElements() throws CorruptDataException {
		return getUDATAAtOffset(J9RelocationList._sortedElementsOffset_);
	}

	// UDATA sortedElements
	public UDATAPointer sortedElementsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9RelocationList._sortedElementsOffset_));
	}

	// void** sortedRelocations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sortedRelocationsOffset_", declaredType="void**")
	public PointerPointer sortedRelocations() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(J9RelocationList._sortedRelocationsOffset_));
	}

	// void** sortedRelocations
	public PointerPointer sortedRelocationsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationList._sortedRelocationsOffset_));
	}

}
