/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9RelocationPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9RelocationPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9Relocation.class)
public class J9RelocationPointer extends StructurePointer {

	// NULL
	public static final J9RelocationPointer NULL = new J9RelocationPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9RelocationPointer(long address) {
		super(address);
	}

	public static J9RelocationPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9RelocationPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9RelocationPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9RelocationPointer(address);
	}

	public J9RelocationPointer add(long count) {
		return J9RelocationPointer.cast(address + (J9Relocation.SIZEOF * count));
	}

	public J9RelocationPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9RelocationPointer addOffset(long offset) {
		return J9RelocationPointer.cast(address + offset);
	}

	public J9RelocationPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9RelocationPointer sub(long count) {
		return J9RelocationPointer.cast(address - (J9Relocation.SIZEOF * count));
	}

	public J9RelocationPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9RelocationPointer subOffset(long offset) {
		return J9RelocationPointer.cast(address - offset);
	}

	public J9RelocationPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9RelocationPointer untag(long mask) {
		return J9RelocationPointer.cast(address & ~mask);
	}

	public J9RelocationPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9Relocation.SIZEOF;
	}

	// Implementation methods

	// U8* loadBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loadBaseOffset_", declaredType="U8*")
	public U8Pointer loadBase() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9Relocation._loadBaseOffset_));
	}

	// U8* loadBase
	public PointerPointer loadBaseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9Relocation._loadBaseOffset_));
	}

	// U8* loadTop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loadTopOffset_", declaredType="U8*")
	public U8Pointer loadTop() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9Relocation._loadTopOffset_));
	}

	// U8* loadTop
	public PointerPointer loadTopEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9Relocation._loadTopOffset_));
	}

	// IDATA relocation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_relocationOffset_", declaredType="IDATA")
	public IDATA relocation() throws CorruptDataException {
		return getIDATAAtOffset(J9Relocation._relocationOffset_);
	}

	// IDATA relocation
	public IDATAPointer relocationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9Relocation._relocationOffset_));
	}

	// UDATA relocationInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_relocationInfoOffset_", declaredType="UDATA")
	public UDATA relocationInfo() throws CorruptDataException {
		return getUDATAAtOffset(J9Relocation._relocationInfoOffset_);
	}

	// UDATA relocationInfo
	public UDATAPointer relocationInfoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9Relocation._relocationInfoOffset_));
	}

	// UDATA relocationType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_relocationTypeOffset_", declaredType="UDATA")
	public UDATA relocationType() throws CorruptDataException {
		return getUDATAAtOffset(J9Relocation._relocationTypeOffset_);
	}

	// UDATA relocationType
	public UDATAPointer relocationTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9Relocation._relocationTypeOffset_));
	}

}
