/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9RelocationStructPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9RelocationStructPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9RelocationStruct.class)
public class J9RelocationStructPointer extends StructurePointer {

	// NULL
	public static final J9RelocationStructPointer NULL = new J9RelocationStructPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9RelocationStructPointer(long address) {
		super(address);
	}

	public static J9RelocationStructPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9RelocationStructPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9RelocationStructPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9RelocationStructPointer(address);
	}

	public J9RelocationStructPointer add(long count) {
		return J9RelocationStructPointer.cast(address + (J9RelocationStruct.SIZEOF * count));
	}

	public J9RelocationStructPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9RelocationStructPointer addOffset(long offset) {
		return J9RelocationStructPointer.cast(address + offset);
	}

	public J9RelocationStructPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9RelocationStructPointer sub(long count) {
		return J9RelocationStructPointer.cast(address - (J9RelocationStruct.SIZEOF * count));
	}

	public J9RelocationStructPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9RelocationStructPointer subOffset(long offset) {
		return J9RelocationStructPointer.cast(address - offset);
	}

	public J9RelocationStructPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9RelocationStructPointer untag(long mask) {
		return J9RelocationStructPointer.cast(address & ~mask);
	}

	public J9RelocationStructPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9RelocationStruct.SIZEOF;
	}

	// Implementation methods

	// j9object_t bcaClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bcaClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer bcaClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._bcaClassOffset_));
	}

	// j9object_t bcaClass
	public PointerPointer bcaClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._bcaClassOffset_));
	}

	// j9object_t bctClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bctClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer bctClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._bctClassOffset_));
	}

	// j9object_t bctClass
	public PointerPointer bctClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._bctClassOffset_));
	}

	// j9object_t bctCompactClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bctCompactClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer bctCompactClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._bctCompactClassOffset_));
	}

	// j9object_t bctCompactClass
	public PointerPointer bctCompactClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._bctCompactClassOffset_));
	}

	// j9object_t cmClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer cmClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._cmClassOffset_));
	}

	// j9object_t cmClass
	public PointerPointer cmClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._cmClassOffset_));
	}

	// j9object_t cpmClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpmClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer cpmClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._cpmClassOffset_));
	}

	// j9object_t cpmClass
	public PointerPointer cpmClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._cpmClassOffset_));
	}

	// j9object_t dbStringClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dbStringClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer dbStringClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._dbStringClassOffset_));
	}

	// j9object_t dbStringClass
	public PointerPointer dbStringClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._dbStringClassOffset_));
	}

	// IDATA fix
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fixOffset_", declaredType="IDATA")
	public IDATA fix() throws CorruptDataException {
		return getIDATAAtOffset(J9RelocationStruct._fixOffset_);
	}

	// IDATA fix
	public IDATAPointer fixEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9RelocationStruct._fixOffset_));
	}

	// IDATA flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="IDATA")
	public IDATA flags() throws CorruptDataException {
		return getIDATAAtOffset(J9RelocationStruct._flagsOffset_);
	}

	// IDATA flags
	public IDATAPointer flagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9RelocationStruct._flagsOffset_));
	}

	// j9object_t floatClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_floatClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer floatClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._floatClassOffset_));
	}

	// j9object_t floatClass
	public PointerPointer floatClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._floatClassOffset_));
	}

	// j9object_t maClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer maClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._maClassOffset_));
	}

	// j9object_t maClass
	public PointerPointer maClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._maClassOffset_));
	}

	// j9object_t mcClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mcClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer mcClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._mcClassOffset_));
	}

	// j9object_t mcClass
	public PointerPointer mcClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._mcClassOffset_));
	}

	// UDATA mixedObjectCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mixedObjectCountOffset_", declaredType="UDATA")
	public UDATA mixedObjectCount() throws CorruptDataException {
		return getUDATAAtOffset(J9RelocationStruct._mixedObjectCountOffset_);
	}

	// UDATA mixedObjectCount
	public UDATAPointer mixedObjectCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9RelocationStruct._mixedObjectCountOffset_));
	}

	// j9object_t pfClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer pfClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._pfClassOffset_));
	}

	// j9object_t pfClass
	public PointerPointer pfClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._pfClassOffset_));
	}

	// J9RelocationList* relocationList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_relocationListOffset_", declaredType="J9RelocationList*")
	public J9RelocationListPointer relocationList() throws CorruptDataException {
		return J9RelocationListPointer.cast(getPointerAtOffset(J9RelocationStruct._relocationListOffset_));
	}

	// J9RelocationList* relocationList
	public PointerPointer relocationListEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._relocationListOffset_));
	}

	// j9object_t stringClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stringClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer stringClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._stringClassOffset_));
	}

	// j9object_t stringClass
	public PointerPointer stringClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._stringClassOffset_));
	}

	// j9object_t symbolClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_symbolClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer symbolClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._symbolClassOffset_));
	}

	// j9object_t symbolClass
	public PointerPointer symbolClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._symbolClassOffset_));
	}

	// j9object_t threadClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadClassOffset_", declaredType="j9object_t")
	public J9ObjectPointer threadClass() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9RelocationStruct._threadClassOffset_));
	}

	// j9object_t threadClass
	public PointerPointer threadClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._threadClassOffset_));
	}

	// J9VMContext* vmContext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmContextOffset_", declaredType="J9VMContext*")
	public J9VMContextPointer vmContext() throws CorruptDataException {
		return J9VMContextPointer.cast(getPointerAtOffset(J9RelocationStruct._vmContextOffset_));
	}

	// J9VMContext* vmContext
	public PointerPointer vmContextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9RelocationStruct._vmContextOffset_));
	}

}
