/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9VMGCSublistPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9VMGCSublistPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9VMGCSublist.class)
public class J9VMGCSublistPointer extends StructurePointer {

	// NULL
	public static final J9VMGCSublistPointer NULL = new J9VMGCSublistPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9VMGCSublistPointer(long address) {
		super(address);
	}

	public static J9VMGCSublistPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9VMGCSublistPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9VMGCSublistPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9VMGCSublistPointer(address);
	}

	public J9VMGCSublistPointer add(long count) {
		return J9VMGCSublistPointer.cast(address + (J9VMGCSublist.SIZEOF * count));
	}

	public J9VMGCSublistPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9VMGCSublistPointer addOffset(long offset) {
		return J9VMGCSublistPointer.cast(address + offset);
	}

	public J9VMGCSublistPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9VMGCSublistPointer sub(long count) {
		return J9VMGCSublistPointer.cast(address - (J9VMGCSublist.SIZEOF * count));
	}

	public J9VMGCSublistPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9VMGCSublistPointer subOffset(long offset) {
		return J9VMGCSublistPointer.cast(address - offset);
	}

	public J9VMGCSublistPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9VMGCSublistPointer untag(long mask) {
		return J9VMGCSublistPointer.cast(address & ~mask);
	}

	public J9VMGCSublistPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9VMGCSublist.SIZEOF;
	}

	// Implementation methods

	// UDATA* listBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_listBaseOffset_", declaredType="UDATA*")
	public UDATAPointer listBase() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMGCSublist._listBaseOffset_));
	}

	// UDATA* listBase
	public PointerPointer listBaseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMGCSublist._listBaseOffset_));
	}

	// UDATA* listCurrent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_listCurrentOffset_", declaredType="UDATA*")
	public UDATAPointer listCurrent() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMGCSublist._listCurrentOffset_));
	}

	// UDATA* listCurrent
	public PointerPointer listCurrentEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMGCSublist._listCurrentOffset_));
	}

	// UDATA* listTop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_listTopOffset_", declaredType="UDATA*")
	public UDATAPointer listTop() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMGCSublist._listTopOffset_));
	}

	// UDATA* listTop
	public PointerPointer listTopEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMGCSublist._listTopOffset_));
	}

	// UDATA newStoreFlag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_newStoreFlagOffset_", declaredType="UDATA")
	public UDATA newStoreFlag() throws CorruptDataException {
		return getUDATAAtOffset(J9VMGCSublist._newStoreFlagOffset_);
	}

	// UDATA newStoreFlag
	public UDATAPointer newStoreFlagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMGCSublist._newStoreFlagOffset_));
	}

	// J9VMGCSublist* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="J9VMGCSublist*")
	public J9VMGCSublistPointer next() throws CorruptDataException {
		return J9VMGCSublistPointer.cast(getPointerAtOffset(J9VMGCSublist._nextOffset_));
	}

	// J9VMGCSublist* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMGCSublist._nextOffset_));
	}

	// UDATA* savedListCurrent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_savedListCurrentOffset_", declaredType="UDATA*")
	public UDATAPointer savedListCurrent() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMGCSublist._savedListCurrentOffset_));
	}

	// UDATA* savedListCurrent
	public PointerPointer savedListCurrentEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMGCSublist._savedListCurrentOffset_));
	}

	// UDATA spinlock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spinlockOffset_", declaredType="UDATA")
	public UDATA spinlock() throws CorruptDataException {
		return getUDATAAtOffset(J9VMGCSublist._spinlockOffset_);
	}

	// UDATA spinlock
	public UDATAPointer spinlockEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMGCSublist._spinlockOffset_));
	}

}
