/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_core_charmap_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_core_charmap_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_core_charmap_t.class)
public class _LC_core_charmap_tPointer extends StructurePointer {

	// NULL
	public static final _LC_core_charmap_tPointer NULL = new _LC_core_charmap_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_core_charmap_tPointer(long address) {
		super(address);
	}

	public static _LC_core_charmap_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_core_charmap_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_core_charmap_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_core_charmap_tPointer(address);
	}

	public _LC_core_charmap_tPointer add(long count) {
		return _LC_core_charmap_tPointer.cast(address + (_LC_core_charmap_t.SIZEOF * count));
	}

	public _LC_core_charmap_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_core_charmap_tPointer addOffset(long offset) {
		return _LC_core_charmap_tPointer.cast(address + offset);
	}

	public _LC_core_charmap_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_core_charmap_tPointer sub(long count) {
		return _LC_core_charmap_tPointer.cast(address - (_LC_core_charmap_t.SIZEOF * count));
	}

	public _LC_core_charmap_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_core_charmap_tPointer subOffset(long offset) {
		return _LC_core_charmap_tPointer.cast(address - offset);
	}

	public _LC_core_charmap_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_core_charmap_tPointer untag(long mask) {
		return _LC_core_charmap_tPointer.cast(address & ~mask);
	}

	public _LC_core_charmap_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_core_charmap_t.SIZEOF;
	}

	// Implementation methods

	// I32 __csid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___csidOffset_", declaredType="I32")
	public IDATA __csid() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___csidOffset_));
	}

	// I32 __csid
	public IDATAPointer __csidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___csidOffset_));
	}

	// void* __data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___dataOffset_", declaredType="void*")
	public VoidPointer __data() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_LC_core_charmap_t.___dataOffset_));
	}

	// void* __data
	public PointerPointer __dataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___dataOffset_));
	}

	// _LC_object_t __hdr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___hdrOffset_", declaredType="_LC_object_t")
	public _LC_object_tPointer __hdr() throws CorruptDataException {
		return _LC_object_tPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___hdrOffset_));
	}

	// _LC_object_t __hdr
	public PointerPointer __hdrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___hdrOffset_));
	}

	// I32 __init
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___initOffset_", declaredType="I32")
	public IDATA __init() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___initOffset_));
	}

	// I32 __init
	public IDATAPointer __initEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___initOffset_));
	}

	// I32 __mblen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___mblenOffset_", declaredType="I32")
	public IDATA __mblen() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___mblenOffset_));
	}

	// I32 __mblen
	public IDATAPointer __mblenEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___mblenOffset_));
	}

	// I32 __mbstopcs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___mbstopcsOffset_", declaredType="I32")
	public IDATA __mbstopcs() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___mbstopcsOffset_));
	}

	// I32 __mbstopcs
	public IDATAPointer __mbstopcsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___mbstopcsOffset_));
	}

	// I32 __mbstowcs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___mbstowcsOffset_", declaredType="I32")
	public IDATA __mbstowcs() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___mbstowcsOffset_));
	}

	// I32 __mbstowcs
	public IDATAPointer __mbstowcsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___mbstowcsOffset_));
	}

	// I32 __mbtopc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___mbtopcOffset_", declaredType="I32")
	public IDATA __mbtopc() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___mbtopcOffset_));
	}

	// I32 __mbtopc
	public IDATAPointer __mbtopcEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___mbtopcOffset_));
	}

	// I32 __mbtowc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___mbtowcOffset_", declaredType="I32")
	public IDATA __mbtowc() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___mbtowcOffset_));
	}

	// I32 __mbtowc
	public IDATAPointer __mbtowcEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___mbtowcOffset_));
	}

	// I32 __nl_langinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___nl_langinfoOffset_", declaredType="I32")
	public IDATA __nl_langinfo() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___nl_langinfoOffset_));
	}

	// I32 __nl_langinfo
	public IDATAPointer __nl_langinfoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___nl_langinfoOffset_));
	}

	// I32 __pcstombs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pcstombsOffset_", declaredType="I32")
	public IDATA __pcstombs() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___pcstombsOffset_));
	}

	// I32 __pcstombs
	public IDATAPointer __pcstombsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___pcstombsOffset_));
	}

	// I32 __pctomb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pctombOffset_", declaredType="I32")
	public IDATA __pctomb() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___pctombOffset_));
	}

	// I32 __pctomb
	public IDATAPointer __pctombEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___pctombOffset_));
	}

	// I32 __wcsid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___wcsidOffset_", declaredType="I32")
	public IDATA __wcsid() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___wcsidOffset_));
	}

	// I32 __wcsid
	public IDATAPointer __wcsidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___wcsidOffset_));
	}

	// I32 __wcstombs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___wcstombsOffset_", declaredType="I32")
	public IDATA __wcstombs() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___wcstombsOffset_));
	}

	// I32 __wcstombs
	public IDATAPointer __wcstombsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___wcstombsOffset_));
	}

	// I32 __wcswidth
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___wcswidthOffset_", declaredType="I32")
	public IDATA __wcswidth() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___wcswidthOffset_));
	}

	// I32 __wcswidth
	public IDATAPointer __wcswidthEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___wcswidthOffset_));
	}

	// I32 __wctomb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___wctombOffset_", declaredType="I32")
	public IDATA __wctomb() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___wctombOffset_));
	}

	// I32 __wctomb
	public IDATAPointer __wctombEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___wctombOffset_));
	}

	// I32 __wcwidth
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___wcwidthOffset_", declaredType="I32")
	public IDATA __wcwidth() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_charmap_t.___wcwidthOffset_));
	}

	// I32 __wcwidth
	public IDATAPointer __wcwidthEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_charmap_t.___wcwidthOffset_));
	}

}
