/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_object_handlePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_object_handlePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_object_handle.class)
public class _LC_object_handlePointer extends StructurePointer {

	// NULL
	public static final _LC_object_handlePointer NULL = new _LC_object_handlePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_object_handlePointer(long address) {
		super(address);
	}

	public static _LC_object_handlePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_object_handlePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_object_handlePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_object_handlePointer(address);
	}

	public _LC_object_handlePointer add(long count) {
		return _LC_object_handlePointer.cast(address + (_LC_object_handle.SIZEOF * count));
	}

	public _LC_object_handlePointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_object_handlePointer addOffset(long offset) {
		return _LC_object_handlePointer.cast(address + offset);
	}

	public _LC_object_handlePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_object_handlePointer sub(long count) {
		return _LC_object_handlePointer.cast(address - (_LC_object_handle.SIZEOF * count));
	}

	public _LC_object_handlePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_object_handlePointer subOffset(long offset) {
		return _LC_object_handlePointer.cast(address - offset);
	}

	public _LC_object_handlePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_object_handlePointer untag(long mask) {
		return _LC_object_handlePointer.cast(address & ~mask);
	}

	public _LC_object_handlePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_object_handle.SIZEOF;
	}

	// Implementation methods

	// _LC_locale_objhdl* loc_hdl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loc_hdlOffset_", declaredType="_LC_locale_objhdl*")
	public _LC_locale_objhdlPointer loc_hdl() throws CorruptDataException {
		return _LC_locale_objhdlPointer.cast(getPointerAtOffset(_LC_object_handle._loc_hdlOffset_));
	}

	// _LC_locale_objhdl* loc_hdl
	public PointerPointer loc_hdlEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._loc_hdlOffset_));
	}

	// void** meth
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methOffset_", declaredType="void**")
	public PointerPointer meth() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(_LC_object_handle._methOffset_));
	}

	// void** meth
	public PointerPointer methEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._methOffset_));
	}

	// _LC_charmap_objhdl_t obj.lc_charmap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_charmapOffset_", declaredType="_LC_charmap_objhdl_t")
	public _LC_charmap_objhdlPointer obj$lc_charmap() throws CorruptDataException {
		return _LC_charmap_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_charmapOffset_));
	}

	// _LC_charmap_objhdl_t obj.lc_charmap
	public PointerPointer obj$lc_charmapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_charmapOffset_));
	}

	// _LC_collate_objhdl_t obj.lc_collate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_collateOffset_", declaredType="_LC_collate_objhdl_t")
	public _LC_collate_objhdlPointer obj$lc_collate() throws CorruptDataException {
		return _LC_collate_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_collateOffset_));
	}

	// _LC_collate_objhdl_t obj.lc_collate
	public PointerPointer obj$lc_collateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_collateOffset_));
	}

	// _LC_ctype_objhdl_t obj.lc_ctype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_ctypeOffset_", declaredType="_LC_ctype_objhdl_t")
	public _LC_ctype_objhdlPointer obj$lc_ctype() throws CorruptDataException {
		return _LC_ctype_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_ctypeOffset_));
	}

	// _LC_ctype_objhdl_t obj.lc_ctype
	public PointerPointer obj$lc_ctypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_ctypeOffset_));
	}

	// _LC_locale_objhdl_t obj.lc_locale
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_localeOffset_", declaredType="_LC_locale_objhdl_t")
	public _LC_locale_objhdlPointer obj$lc_locale() throws CorruptDataException {
		return _LC_locale_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_localeOffset_));
	}

	// _LC_locale_objhdl_t obj.lc_locale
	public PointerPointer obj$lc_localeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_localeOffset_));
	}

	// _LC_monetary_objhdl_t obj.lc_monetary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_monetaryOffset_", declaredType="_LC_monetary_objhdl_t")
	public _LC_monetary_objhdlPointer obj$lc_monetary() throws CorruptDataException {
		return _LC_monetary_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_monetaryOffset_));
	}

	// _LC_monetary_objhdl_t obj.lc_monetary
	public PointerPointer obj$lc_monetaryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_monetaryOffset_));
	}

	// _LC_numeric_objhdl_t obj.lc_numeric
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_numericOffset_", declaredType="_LC_numeric_objhdl_t")
	public _LC_numeric_objhdlPointer obj$lc_numeric() throws CorruptDataException {
		return _LC_numeric_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_numericOffset_));
	}

	// _LC_numeric_objhdl_t obj.lc_numeric
	public PointerPointer obj$lc_numericEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_numericOffset_));
	}

	// _LC_object_t obj.lc_object
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_objectOffset_", declaredType="_LC_object_t")
	public _LC_object_tPointer obj$lc_object() throws CorruptDataException {
		return _LC_object_tPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_objectOffset_));
	}

	// _LC_object_t obj.lc_object
	public PointerPointer obj$lc_objectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_objectOffset_));
	}

	// _LC_resp_objhdl_t obj.lc_resp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_respOffset_", declaredType="_LC_resp_objhdl_t")
	public _LC_resp_objhdlPointer obj$lc_resp() throws CorruptDataException {
		return _LC_resp_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_respOffset_));
	}

	// _LC_resp_objhdl_t obj.lc_resp
	public PointerPointer obj$lc_respEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_respOffset_));
	}

	// _LC_time_objhdl_t obj.lc_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_obj$lc_timeOffset_", declaredType="_LC_time_objhdl_t")
	public _LC_time_objhdlPointer obj$lc_time() throws CorruptDataException {
		return _LC_time_objhdlPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_timeOffset_));
	}

	// _LC_time_objhdl_t obj.lc_time
	public PointerPointer obj$lc_timeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_object_handle._obj$lc_timeOffset_));
	}

}
