/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __pthrdsinfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __pthrdsinfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__pthrdsinfo.class)
public class __pthrdsinfoPointer extends StructurePointer {

	// NULL
	public static final __pthrdsinfoPointer NULL = new __pthrdsinfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __pthrdsinfoPointer(long address) {
		super(address);
	}

	public static __pthrdsinfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __pthrdsinfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __pthrdsinfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __pthrdsinfoPointer(address);
	}

	public __pthrdsinfoPointer add(long count) {
		return __pthrdsinfoPointer.cast(address + (__pthrdsinfo.SIZEOF * count));
	}

	public __pthrdsinfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __pthrdsinfoPointer addOffset(long offset) {
		return __pthrdsinfoPointer.cast(address + offset);
	}

	public __pthrdsinfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __pthrdsinfoPointer sub(long count) {
		return __pthrdsinfoPointer.cast(address - (__pthrdsinfo.SIZEOF * count));
	}

	public __pthrdsinfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __pthrdsinfoPointer subOffset(long offset) {
		return __pthrdsinfoPointer.cast(address - offset);
	}

	public __pthrdsinfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __pthrdsinfoPointer untag(long mask) {
		return __pthrdsinfoPointer.cast(address & ~mask);
	}

	public __pthrdsinfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __pthrdsinfo.SIZEOF;
	}

	// Implementation methods

	// void* __pi_arg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_argOffset_", declaredType="void*")
	public VoidPointer __pi_arg() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(__pthrdsinfo.___pi_argOffset_));
	}

	// void* __pi_arg
	public PointerPointer __pi_argEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_argOffset_));
	}

	// __pthrdscontext __pi_context
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_contextOffset_", declaredType="__pthrdscontext")
	public __pthrdscontextPointer __pi_context() throws CorruptDataException {
		return __pthrdscontextPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_contextOffset_));
	}

	// __pthrdscontext __pi_context
	public PointerPointer __pi_contextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_contextOffset_));
	}

	// void* __pi_exit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_exitOffset_", declaredType="void*")
	public VoidPointer __pi_exit() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(__pthrdsinfo.___pi_exitOffset_));
	}

	// void* __pi_exit
	public PointerPointer __pi_exitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_exitOffset_));
	}

	// U32 __pi_frame_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_frame_countOffset_", declaredType="U32")
	public UDATA __pi_frame_count() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdsinfo.___pi_frame_countOffset_));
	}

	// U32 __pi_frame_count
	public UDATAPointer __pi_frame_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_frame_countOffset_));
	}

	// void* __pi_func
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_funcOffset_", declaredType="void*")
	public VoidPointer __pi_func() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(__pthrdsinfo.___pi_funcOffset_));
	}

	// void* __pi_func
	public PointerPointer __pi_funcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_funcOffset_));
	}

	// U64 __pi_handle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_handleOffset_", declaredType="U64")
	public UDATA __pi_handle() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdsinfo.___pi_handleOffset_));
	}

	// U64 __pi_handle
	public UDATAPointer __pi_handleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_handleOffset_));
	}

	// ulong[] __pi_pad
	public UDATAPointer __pi_padEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_padOffset_));
	}

	// pthread_t __pi_ptid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_ptidOffset_", declaredType="pthread_t")
	public UDATA __pi_ptid() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdsinfo.___pi_ptidOffset_));
	}

	// pthread_t __pi_ptid
	public UDATAPointer __pi_ptidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_ptidOffset_));
	}

	// U32 __pi_siglevel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_siglevelOffset_", declaredType="U32")
	public UDATA __pi_siglevel() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdsinfo.___pi_siglevelOffset_));
	}

	// U32 __pi_siglevel
	public UDATAPointer __pi_siglevelEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_siglevelOffset_));
	}

	// U8* __pi_stackaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_stackaddrOffset_", declaredType="U8*")
	public U8Pointer __pi_stackaddr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(__pthrdsinfo.___pi_stackaddrOffset_));
	}

	// U8* __pi_stackaddr
	public PointerPointer __pi_stackaddrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_stackaddrOffset_));
	}

	// U8* __pi_stackend
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_stackendOffset_", declaredType="U8*")
	public U8Pointer __pi_stackend() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(__pthrdsinfo.___pi_stackendOffset_));
	}

	// U8* __pi_stackend
	public PointerPointer __pi_stackendEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_stackendOffset_));
	}

	// size_t __pi_stacksize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_stacksizeOffset_", declaredType="size_t")
	public UDATA __pi_stacksize() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdsinfo.___pi_stacksizeOffset_));
	}

	// size_t __pi_stacksize
	public UDATAPointer __pi_stacksizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_stacksizeOffset_));
	}

	// I32 __pi_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_stateOffset_", declaredType="I32")
	public IDATA __pi_state() throws CorruptDataException {
		return new I32(getIntAtOffset(__pthrdsinfo.___pi_stateOffset_));
	}

	// I32 __pi_state
	public IDATAPointer __pi_stateEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_stateOffset_));
	}

	// I32 __pi_suspendstate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_suspendstateOffset_", declaredType="I32")
	public IDATA __pi_suspendstate() throws CorruptDataException {
		return new I32(getIntAtOffset(__pthrdsinfo.___pi_suspendstateOffset_));
	}

	// I32 __pi_suspendstate
	public IDATAPointer __pi_suspendstateEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_suspendstateOffset_));
	}

	// tid_t __pi_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_tidOffset_", declaredType="tid_t")
	public IDATA __pi_tid() throws CorruptDataException {
		return new I64(getLongAtOffset(__pthrdsinfo.___pi_tidOffset_));
	}

	// tid_t __pi_tid
	public IDATAPointer __pi_tidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_tidOffset_));
	}

	// U64 __pi_ustk
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pi_ustkOffset_", declaredType="U64")
	public UDATA __pi_ustk() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdsinfo.___pi_ustkOffset_));
	}

	// U64 __pi_ustk
	public UDATAPointer __pi_ustkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdsinfo.___pi_ustkOffset_));
	}

}
