/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: aix_fd_structPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the aix_fd_structPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=aix_fd_struct.class)
public class aix_fd_structPointer extends StructurePointer {

	// NULL
	public static final aix_fd_structPointer NULL = new aix_fd_structPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected aix_fd_structPointer(long address) {
		super(address);
	}

	public static aix_fd_structPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static aix_fd_structPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static aix_fd_structPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new aix_fd_structPointer(address);
	}

	public aix_fd_structPointer add(long count) {
		return aix_fd_structPointer.cast(address + (aix_fd_struct.SIZEOF * count));
	}

	public aix_fd_structPointer add(Scalar count) {
		return add(count.longValue());
	}

	public aix_fd_structPointer addOffset(long offset) {
		return aix_fd_structPointer.cast(address + offset);
	}

	public aix_fd_structPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public aix_fd_structPointer sub(long count) {
		return aix_fd_structPointer.cast(address - (aix_fd_struct.SIZEOF * count));
	}

	public aix_fd_structPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public aix_fd_structPointer subOffset(long offset) {
		return aix_fd_structPointer.cast(address - offset);
	}

	public aix_fd_structPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public aix_fd_structPointer untag(long mask) {
		return aix_fd_structPointer.cast(address & ~mask);
	}

	public aix_fd_structPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return aix_fd_struct.SIZEOF;
	}

	// Implementation methods

	// void* code_pointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_code_pointerOffset_", declaredType="void*")
	public VoidPointer code_pointer() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(aix_fd_struct._code_pointerOffset_));
	}

	// void* code_pointer
	public PointerPointer code_pointerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(aix_fd_struct._code_pointerOffset_));
	}

	// void* toc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tocOffset_", declaredType="void*")
	public VoidPointer toc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(aix_fd_struct._tocOffset_));
	}

	// void* toc
	public PointerPointer tocEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(aix_fd_struct._tocOffset_));
	}

}
