/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: char_classification_tablePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the char_classification_tablePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=char_classification_table.class)
public class char_classification_tablePointer extends StructurePointer {

	// NULL
	public static final char_classification_tablePointer NULL = new char_classification_tablePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected char_classification_tablePointer(long address) {
		super(address);
	}

	public static char_classification_tablePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static char_classification_tablePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static char_classification_tablePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new char_classification_tablePointer(address);
	}

	public char_classification_tablePointer add(long count) {
		return char_classification_tablePointer.cast(address + (char_classification_table.SIZEOF * count));
	}

	public char_classification_tablePointer add(Scalar count) {
		return add(count.longValue());
	}

	public char_classification_tablePointer addOffset(long offset) {
		return char_classification_tablePointer.cast(address + offset);
	}

	public char_classification_tablePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public char_classification_tablePointer sub(long count) {
		return char_classification_tablePointer.cast(address - (char_classification_table.SIZEOF * count));
	}

	public char_classification_tablePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public char_classification_tablePointer subOffset(long offset) {
		return char_classification_tablePointer.cast(address - offset);
	}

	public char_classification_tablePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public char_classification_tablePointer untag(long mask) {
		return char_classification_tablePointer.cast(address & ~mask);
	}

	public char_classification_tablePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return char_classification_table.SIZEOF;
	}

	// Implementation methods

	// wchar_t* lc_caseconv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_caseconvOffset_", declaredType="wchar_t*")
	public UDATAPointer lc_caseconv() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(char_classification_table._lc_caseconvOffset_));
	}

	// wchar_t* lc_caseconv
	public PointerPointer lc_caseconvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(char_classification_table._lc_caseconvOffset_));
	}

	// I16 lc_code_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_code_typeOffset_", declaredType="I16")
	public I16 lc_code_type() throws CorruptDataException {
		return new I16(getShortAtOffset(char_classification_table._lc_code_typeOffset_));
	}

	// I16 lc_code_type
	public I16Pointer lc_code_typeEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(char_classification_table._lc_code_typeOffset_));
	}

	// U16* lc_ctype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_ctypeOffset_", declaredType="U16*")
	public U16Pointer lc_ctype() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(char_classification_table._lc_ctypeOffset_));
	}

	// U16* lc_ctype
	public PointerPointer lc_ctypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(char_classification_table._lc_ctypeOffset_));
	}

	// I16 lc_dsp_width
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_dsp_widthOffset_", declaredType="I16")
	public I16 lc_dsp_width() throws CorruptDataException {
		return new I16(getShortAtOffset(char_classification_table._lc_dsp_widthOffset_));
	}

	// I16 lc_dsp_width
	public I16Pointer lc_dsp_widthEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(char_classification_table._lc_dsp_widthOffset_));
	}

	// I16 lc_length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_lengthOffset_", declaredType="I16")
	public I16 lc_length() throws CorruptDataException {
		return new I16(getShortAtOffset(char_classification_table._lc_lengthOffset_));
	}

	// I16 lc_length
	public I16Pointer lc_lengthEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(char_classification_table._lc_lengthOffset_));
	}

	// U8* lc_locale_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_locale_nameOffset_", declaredType="U8*")
	public U8Pointer lc_locale_name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(char_classification_table._lc_locale_nameOffset_));
	}

	// U8* lc_locale_name
	public PointerPointer lc_locale_nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(char_classification_table._lc_locale_nameOffset_));
	}

	// I16 lc_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_versionOffset_", declaredType="I16")
	public I16 lc_version() throws CorruptDataException {
		return new I16(getShortAtOffset(char_classification_table._lc_versionOffset_));
	}

	// I16 lc_version
	public I16Pointer lc_versionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(char_classification_table._lc_versionOffset_));
	}

	// I32 len_caseconv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_len_caseconvOffset_", declaredType="I32")
	public IDATA len_caseconv() throws CorruptDataException {
		return new I32(getIntAtOffset(char_classification_table._len_caseconvOffset_));
	}

	// I32 len_caseconv
	public IDATAPointer len_caseconvEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(char_classification_table._len_caseconvOffset_));
	}

	// I32 len_ctype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_len_ctypeOffset_", declaredType="I32")
	public IDATA len_ctype() throws CorruptDataException {
		return new I32(getIntAtOffset(char_classification_table._len_ctypeOffset_));
	}

	// I32 len_ctype
	public IDATAPointer len_ctypeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(char_classification_table._len_ctypeOffset_));
	}

	// I16 mb_cur_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mb_cur_maxOffset_", declaredType="I16")
	public I16 mb_cur_max() throws CorruptDataException {
		return new I16(getShortAtOffset(char_classification_table._mb_cur_maxOffset_));
	}

	// I16 mb_cur_max
	public I16Pointer mb_cur_maxEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(char_classification_table._mb_cur_maxOffset_));
	}

	// I16 mb_cur_min
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mb_cur_minOffset_", declaredType="I16")
	public I16 mb_cur_min() throws CorruptDataException {
		return new I16(getShortAtOffset(char_classification_table._mb_cur_minOffset_));
	}

	// I16 mb_cur_min
	public I16Pointer mb_cur_minEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(char_classification_table._mb_cur_minOffset_));
	}

}
