/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: coldescPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the coldescPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=coldesc.class)
public class coldescPointer extends StructurePointer {

	// NULL
	public static final coldescPointer NULL = new coldescPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected coldescPointer(long address) {
		super(address);
	}

	public static coldescPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static coldescPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static coldescPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new coldescPointer(address);
	}

	public coldescPointer add(long count) {
		return coldescPointer.cast(address + (coldesc.SIZEOF * count));
	}

	public coldescPointer add(Scalar count) {
		return add(count.longValue());
	}

	public coldescPointer addOffset(long offset) {
		return coldescPointer.cast(address + offset);
	}

	public coldescPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public coldescPointer sub(long count) {
		return coldescPointer.cast(address - (coldesc.SIZEOF * count));
	}

	public coldescPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public coldescPointer subOffset(long offset) {
		return coldescPointer.cast(address - offset);
	}

	public coldescPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public coldescPointer untag(long mask) {
		return coldescPointer.cast(address & ~mask);
	}

	public coldescPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return coldesc.SIZEOF;
	}

	// Implementation methods

	// I16 cd_cuniq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cd_cuniqOffset_", declaredType="I16")
	public I16 cd_cuniq() throws CorruptDataException {
		return new I16(getShortAtOffset(coldesc._cd_cuniqOffset_));
	}

	// I16 cd_cuniq
	public I16Pointer cd_cuniqEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(coldesc._cd_cuniqOffset_));
	}

	// I16 cd_cval
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cd_cvalOffset_", declaredType="I16")
	public I16 cd_cval() throws CorruptDataException {
		return new I16(getShortAtOffset(coldesc._cd_cvalOffset_));
	}

	// I16 cd_cval
	public I16Pointer cd_cvalEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(coldesc._cd_cvalOffset_));
	}

	// I16 cd_repoff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cd_repoffOffset_", declaredType="I16")
	public I16 cd_repoff() throws CorruptDataException {
		return new I16(getShortAtOffset(coldesc._cd_repoffOffset_));
	}

	// I16 cd_repoff
	public I16Pointer cd_repoffEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(coldesc._cd_repoffOffset_));
	}

	// I16 cd_stroff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cd_stroffOffset_", declaredType="I16")
	public I16 cd_stroff() throws CorruptDataException {
		return new I16(getShortAtOffset(coldesc._cd_stroffOffset_));
	}

	// I16 cd_stroff
	public I16Pointer cd_stroffEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(coldesc._cd_stroffOffset_));
	}

}
