/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: iplcb_map_reg_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the iplcb_map_reg_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=iplcb_map_reg_t.class)
public class iplcb_map_reg_tPointer extends StructurePointer {

	// NULL
	public static final iplcb_map_reg_tPointer NULL = new iplcb_map_reg_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected iplcb_map_reg_tPointer(long address) {
		super(address);
	}

	public static iplcb_map_reg_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static iplcb_map_reg_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static iplcb_map_reg_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new iplcb_map_reg_tPointer(address);
	}

	public iplcb_map_reg_tPointer add(long count) {
		return iplcb_map_reg_tPointer.cast(address + (iplcb_map_reg_t.SIZEOF * count));
	}

	public iplcb_map_reg_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public iplcb_map_reg_tPointer addOffset(long offset) {
		return iplcb_map_reg_tPointer.cast(address + offset);
	}

	public iplcb_map_reg_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public iplcb_map_reg_tPointer sub(long count) {
		return iplcb_map_reg_tPointer.cast(address - (iplcb_map_reg_t.SIZEOF * count));
	}

	public iplcb_map_reg_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public iplcb_map_reg_tPointer subOffset(long offset) {
		return iplcb_map_reg_tPointer.cast(address - offset);
	}

	public iplcb_map_reg_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public iplcb_map_reg_tPointer untag(long mask) {
		return iplcb_map_reg_tPointer.cast(address & ~mask);
	}

	public iplcb_map_reg_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return iplcb_map_reg_t.SIZEOF;
	}

	// Implementation methods

	// U64 mr_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mr_addrOffset_", declaredType="U64")
	public UDATA mr_addr() throws CorruptDataException {
		return new U64(getLongAtOffset(iplcb_map_reg_t._mr_addrOffset_));
	}

	// U64 mr_addr
	public UDATAPointer mr_addrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(iplcb_map_reg_t._mr_addrOffset_));
	}

	// U8 mr_att
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mr_attOffset_", declaredType="U8")
	public U8 mr_att() throws CorruptDataException {
		return new U8(getByteAtOffset(iplcb_map_reg_t._mr_attOffset_));
	}

	// U8 mr_att
	public U8Pointer mr_attEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(iplcb_map_reg_t._mr_attOffset_));
	}

	// U16 mr_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mr_flagsOffset_", declaredType="U16")
	public U16 mr_flags() throws CorruptDataException {
		return new U16(getShortAtOffset(iplcb_map_reg_t._mr_flagsOffset_));
	}

	// U16 mr_flags
	public U16Pointer mr_flagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(iplcb_map_reg_t._mr_flagsOffset_));
	}

	// U8 mr_label
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mr_labelOffset_", declaredType="U8")
	public U8 mr_label() throws CorruptDataException {
		return new U8(getByteAtOffset(iplcb_map_reg_t._mr_labelOffset_));
	}

	// U8 mr_label
	public U8Pointer mr_labelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(iplcb_map_reg_t._mr_labelOffset_));
	}

	// U16 mr_nodeid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mr_nodeidOffset_", declaredType="U16")
	public U16 mr_nodeid() throws CorruptDataException {
		return new U16(getShortAtOffset(iplcb_map_reg_t._mr_nodeidOffset_));
	}

	// U16 mr_nodeid
	public U16Pointer mr_nodeidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(iplcb_map_reg_t._mr_nodeidOffset_));
	}

	// U64 mr_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mr_sizeOffset_", declaredType="U64")
	public UDATA mr_size() throws CorruptDataException {
		return new U64(getLongAtOffset(iplcb_map_reg_t._mr_sizeOffset_));
	}

	// U64 mr_size
	public UDATAPointer mr_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(iplcb_map_reg_t._mr_sizeOffset_));
	}

	// U8[] reserved
	public U8Pointer reservedEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(iplcb_map_reg_t._reservedOffset_));
	}

}
