/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: localeinfo_tablePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the localeinfo_tablePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=localeinfo_table.class)
public class localeinfo_tablePointer extends StructurePointer {

	// NULL
	public static final localeinfo_tablePointer NULL = new localeinfo_tablePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected localeinfo_tablePointer(long address) {
		super(address);
	}

	public static localeinfo_tablePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static localeinfo_tablePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static localeinfo_tablePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new localeinfo_tablePointer(address);
	}

	public localeinfo_tablePointer add(long count) {
		return localeinfo_tablePointer.cast(address + (localeinfo_table.SIZEOF * count));
	}

	public localeinfo_tablePointer add(Scalar count) {
		return add(count.longValue());
	}

	public localeinfo_tablePointer addOffset(long offset) {
		return localeinfo_tablePointer.cast(address + offset);
	}

	public localeinfo_tablePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public localeinfo_tablePointer sub(long count) {
		return localeinfo_tablePointer.cast(address - (localeinfo_table.SIZEOF * count));
	}

	public localeinfo_tablePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public localeinfo_tablePointer subOffset(long offset) {
		return localeinfo_tablePointer.cast(address - offset);
	}

	public localeinfo_tablePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public localeinfo_tablePointer untag(long mask) {
		return localeinfo_tablePointer.cast(address & ~mask);
	}

	public localeinfo_tablePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return localeinfo_table.SIZEOF;
	}

	// Implementation methods

	// ctype_t* lc_chrtbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_chrtblOffset_", declaredType="ctype_t*")
	public char_classification_tablePointer lc_chrtbl() throws CorruptDataException {
		return char_classification_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_chrtblOffset_));
	}

	// ctype_t* lc_chrtbl
	public PointerPointer lc_chrtblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_chrtblOffset_));
	}

	// I16 lc_code_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_code_typeOffset_", declaredType="I16")
	public I16 lc_code_type() throws CorruptDataException {
		return new I16(getShortAtOffset(localeinfo_table._lc_code_typeOffset_));
	}

	// I16 lc_code_type
	public I16Pointer lc_code_typeEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(localeinfo_table._lc_code_typeOffset_));
	}

	// col_t* lc_coltbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_coltblOffset_", declaredType="col_t*")
	public collation_tablePointer lc_coltbl() throws CorruptDataException {
		return collation_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_coltblOffset_));
	}

	// col_t* lc_coltbl
	public PointerPointer lc_coltblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_coltblOffset_));
	}

	// I16 lc_length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_lengthOffset_", declaredType="I16")
	public I16 lc_length() throws CorruptDataException {
		return new I16(getShortAtOffset(localeinfo_table._lc_lengthOffset_));
	}

	// I16 lc_length
	public I16Pointer lc_lengthEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(localeinfo_table._lc_lengthOffset_));
	}

	// U8 lc_mag0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_mag0Offset_", declaredType="U8")
	public U8 lc_mag0() throws CorruptDataException {
		return new U8(getByteAtOffset(localeinfo_table._lc_mag0Offset_));
	}

	// U8 lc_mag0
	public U8Pointer lc_mag0EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(localeinfo_table._lc_mag0Offset_));
	}

	// U8 lc_mag1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_mag1Offset_", declaredType="U8")
	public U8 lc_mag1() throws CorruptDataException {
		return new U8(getByteAtOffset(localeinfo_table._lc_mag1Offset_));
	}

	// U8 lc_mag1
	public U8Pointer lc_mag1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(localeinfo_table._lc_mag1Offset_));
	}

	// map_t* lc_maptbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_maptblOffset_", declaredType="map_t*")
	public wchar_mapping_tablePointer lc_maptbl() throws CorruptDataException {
		return wchar_mapping_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_maptblOffset_));
	}

	// map_t* lc_maptbl
	public PointerPointer lc_maptblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_maptblOffset_));
	}

	// mon_t* lc_montbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_montblOffset_", declaredType="mon_t*")
	public lc_monetary_tablePointer lc_montbl() throws CorruptDataException {
		return lc_monetary_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_montblOffset_));
	}

	// mon_t* lc_montbl
	public PointerPointer lc_montblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_montblOffset_));
	}

	// msg_t* lc_msgtbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_msgtblOffset_", declaredType="msg_t*")
	public lc_messages_tablePointer lc_msgtbl() throws CorruptDataException {
		return lc_messages_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_msgtblOffset_));
	}

	// msg_t* lc_msgtbl
	public PointerPointer lc_msgtblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_msgtblOffset_));
	}

	// num_t* lc_numtbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_numtblOffset_", declaredType="num_t*")
	public numeric_tablePointer lc_numtbl() throws CorruptDataException {
		return numeric_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_numtblOffset_));
	}

	// num_t* lc_numtbl
	public PointerPointer lc_numtblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_numtblOffset_));
	}

	// tim_t* lc_timtbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_timtblOffset_", declaredType="tim_t*")
	public lc_time_tablePointer lc_timtbl() throws CorruptDataException {
		return lc_time_tablePointer.cast(getPointerAtOffset(localeinfo_table._lc_timtblOffset_));
	}

	// tim_t* lc_timtbl
	public PointerPointer lc_timtblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(localeinfo_table._lc_timtblOffset_));
	}

	// I16 lc_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_versionOffset_", declaredType="I16")
	public I16 lc_version() throws CorruptDataException {
		return new I16(getShortAtOffset(localeinfo_table._lc_versionOffset_));
	}

	// I16 lc_version
	public I16Pointer lc_versionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(localeinfo_table._lc_versionOffset_));
	}

}
