/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: perfstat_partition_total_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the perfstat_partition_total_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=perfstat_partition_total_t.class)
public class perfstat_partition_total_tPointer extends StructurePointer {

	// NULL
	public static final perfstat_partition_total_tPointer NULL = new perfstat_partition_total_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected perfstat_partition_total_tPointer(long address) {
		super(address);
	}

	public static perfstat_partition_total_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static perfstat_partition_total_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static perfstat_partition_total_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new perfstat_partition_total_tPointer(address);
	}

	public perfstat_partition_total_tPointer add(long count) {
		return perfstat_partition_total_tPointer.cast(address + (perfstat_partition_total_t.SIZEOF * count));
	}

	public perfstat_partition_total_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public perfstat_partition_total_tPointer addOffset(long offset) {
		return perfstat_partition_total_tPointer.cast(address + offset);
	}

	public perfstat_partition_total_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public perfstat_partition_total_tPointer sub(long count) {
		return perfstat_partition_total_tPointer.cast(address - (perfstat_partition_total_t.SIZEOF * count));
	}

	public perfstat_partition_total_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public perfstat_partition_total_tPointer subOffset(long offset) {
		return perfstat_partition_total_tPointer.cast(address - offset);
	}

	public perfstat_partition_total_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public perfstat_partition_total_tPointer untag(long mask) {
		return perfstat_partition_total_tPointer.cast(address & ~mask);
	}

	public perfstat_partition_total_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return perfstat_partition_total_t.SIZEOF;
	}

	// Implementation methods

	// u_longlong_t IOHighWaterMark
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IOHighWaterMarkOffset_", declaredType="u_longlong_t")
	public UDATA IOHighWaterMark() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._IOHighWaterMarkOffset_));
	}

	// u_longlong_t IOHighWaterMark
	public UDATAPointer IOHighWaterMarkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._IOHighWaterMarkOffset_));
	}

	// u_longlong_t IOMemEntFree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IOMemEntFreeOffset_", declaredType="u_longlong_t")
	public UDATA IOMemEntFree() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._IOMemEntFreeOffset_));
	}

	// u_longlong_t IOMemEntFree
	public UDATAPointer IOMemEntFreeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._IOMemEntFreeOffset_));
	}

	// u_longlong_t IOMemEntInUse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IOMemEntInUseOffset_", declaredType="u_longlong_t")
	public UDATA IOMemEntInUse() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._IOMemEntInUseOffset_));
	}

	// u_longlong_t IOMemEntInUse
	public UDATAPointer IOMemEntInUseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._IOMemEntInUseOffset_));
	}

	// u_longlong_t MemPoolSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MemPoolSizeOffset_", declaredType="u_longlong_t")
	public UDATA MemPoolSize() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._MemPoolSizeOffset_));
	}

	// u_longlong_t MemPoolSize
	public UDATAPointer MemPoolSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._MemPoolSizeOffset_));
	}

	// u_longlong_t ame_deficit_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ame_deficit_sizeOffset_", declaredType="u_longlong_t")
	public UDATA ame_deficit_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._ame_deficit_sizeOffset_));
	}

	// u_longlong_t ame_deficit_size
	public UDATAPointer ame_deficit_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._ame_deficit_sizeOffset_));
	}

	// ushort ame_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ame_versionOffset_", declaredType="ushort")
	public U16 ame_version() throws CorruptDataException {
		return new U16(getShortAtOffset(perfstat_partition_total_t._ame_versionOffset_));
	}

	// ushort ame_version
	public U16Pointer ame_versionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(perfstat_partition_total_t._ame_versionOffset_));
	}

	// I32 ams_pool_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ams_pool_idOffset_", declaredType="I32")
	public IDATA ams_pool_id() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._ams_pool_idOffset_));
	}

	// I32 ams_pool_id
	public IDATAPointer ams_pool_idEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._ams_pool_idOffset_));
	}

	// u_longlong_t busy_donated_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_donated_purrOffset_", declaredType="u_longlong_t")
	public UDATA busy_donated_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._busy_donated_purrOffset_));
	}

	// u_longlong_t busy_donated_purr
	public UDATAPointer busy_donated_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._busy_donated_purrOffset_));
	}

	// u_longlong_t busy_donated_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_donated_spurrOffset_", declaredType="u_longlong_t")
	public UDATA busy_donated_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._busy_donated_spurrOffset_));
	}

	// u_longlong_t busy_donated_spurr
	public UDATAPointer busy_donated_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._busy_donated_spurrOffset_));
	}

	// u_longlong_t busy_stolen_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_stolen_purrOffset_", declaredType="u_longlong_t")
	public UDATA busy_stolen_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._busy_stolen_purrOffset_));
	}

	// u_longlong_t busy_stolen_purr
	public UDATAPointer busy_stolen_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._busy_stolen_purrOffset_));
	}

	// u_longlong_t busy_stolen_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_stolen_spurrOffset_", declaredType="u_longlong_t")
	public UDATA busy_stolen_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._busy_stolen_spurrOffset_));
	}

	// u_longlong_t busy_stolen_spurr
	public UDATAPointer busy_stolen_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._busy_stolen_spurrOffset_));
	}

	// u_longlong_t cmcs_total_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmcs_total_timeOffset_", declaredType="u_longlong_t")
	public UDATA cmcs_total_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._cmcs_total_timeOffset_));
	}

	// u_longlong_t cmcs_total_time
	public UDATAPointer cmcs_total_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._cmcs_total_timeOffset_));
	}

	// u_longlong_t current_memexp_factr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_current_memexp_factrOffset_", declaredType="u_longlong_t")
	public UDATA current_memexp_factr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._current_memexp_factrOffset_));
	}

	// u_longlong_t current_memexp_factr
	public UDATAPointer current_memexp_factrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._current_memexp_factrOffset_));
	}

	// u_longlong_t entitled_pool_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entitled_pool_capacityOffset_", declaredType="u_longlong_t")
	public UDATA entitled_pool_capacity() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._entitled_pool_capacityOffset_));
	}

	// u_longlong_t entitled_pool_capacity
	public UDATAPointer entitled_pool_capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._entitled_pool_capacityOffset_));
	}

	// I32 entitled_proc_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entitled_proc_capacityOffset_", declaredType="I32")
	public IDATA entitled_proc_capacity() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._entitled_proc_capacityOffset_));
	}

	// I32 entitled_proc_capacity
	public IDATAPointer entitled_proc_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._entitled_proc_capacityOffset_));
	}

	// u_longlong_t expanded_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_expanded_memoryOffset_", declaredType="u_longlong_t")
	public UDATA expanded_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._expanded_memoryOffset_));
	}

	// u_longlong_t expanded_memory
	public UDATAPointer expanded_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._expanded_memoryOffset_));
	}

	// I32 group_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_group_idOffset_", declaredType="I32")
	public IDATA group_id() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._group_idOffset_));
	}

	// I32 group_id
	public IDATAPointer group_idEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._group_idOffset_));
	}

	// U8[] hardwareid
	public U8Pointer hardwareidEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(perfstat_partition_total_t._hardwareidOffset_));
	}

	// u_longlong_t hpi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hpiOffset_", declaredType="u_longlong_t")
	public UDATA hpi() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._hpiOffset_));
	}

	// u_longlong_t hpi
	public UDATAPointer hpiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._hpiOffset_));
	}

	// u_longlong_t hpit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hpitOffset_", declaredType="u_longlong_t")
	public UDATA hpit() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._hpitOffset_));
	}

	// u_longlong_t hpit
	public UDATAPointer hpitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._hpitOffset_));
	}

	// u_longlong_t hypv_pagesize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hypv_pagesizeOffset_", declaredType="u_longlong_t")
	public UDATA hypv_pagesize() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._hypv_pagesizeOffset_));
	}

	// u_longlong_t hypv_pagesize
	public UDATAPointer hypv_pagesizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._hypv_pagesizeOffset_));
	}

	// u_longlong_t idle_donated_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_donated_purrOffset_", declaredType="u_longlong_t")
	public UDATA idle_donated_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._idle_donated_purrOffset_));
	}

	// u_longlong_t idle_donated_purr
	public UDATAPointer idle_donated_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._idle_donated_purrOffset_));
	}

	// u_longlong_t idle_donated_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_donated_spurrOffset_", declaredType="u_longlong_t")
	public UDATA idle_donated_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._idle_donated_spurrOffset_));
	}

	// u_longlong_t idle_donated_spurr
	public UDATAPointer idle_donated_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._idle_donated_spurrOffset_));
	}

	// u_longlong_t idle_stolen_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_stolen_purrOffset_", declaredType="u_longlong_t")
	public UDATA idle_stolen_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._idle_stolen_purrOffset_));
	}

	// u_longlong_t idle_stolen_purr
	public UDATAPointer idle_stolen_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._idle_stolen_purrOffset_));
	}

	// u_longlong_t idle_stolen_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_stolen_spurrOffset_", declaredType="u_longlong_t")
	public UDATA idle_stolen_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._idle_stolen_spurrOffset_));
	}

	// u_longlong_t idle_stolen_spurr
	public UDATAPointer idle_stolen_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._idle_stolen_spurrOffset_));
	}

	// u_longlong_t invol_virt_cswitch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_invol_virt_cswitchOffset_", declaredType="u_longlong_t")
	public UDATA invol_virt_cswitch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._invol_virt_cswitchOffset_));
	}

	// u_longlong_t invol_virt_cswitch
	public UDATAPointer invol_virt_cswitchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._invol_virt_cswitchOffset_));
	}

	// u_longlong_t iome
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iomeOffset_", declaredType="u_longlong_t")
	public UDATA iome() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._iomeOffset_));
	}

	// u_longlong_t iome
	public UDATAPointer iomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._iomeOffset_));
	}

	// I32 lpar_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpar_idOffset_", declaredType="I32")
	public IDATA lpar_id() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._lpar_idOffset_));
	}

	// I32 lpar_id
	public IDATAPointer lpar_idEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._lpar_idOffset_));
	}

	// u_longlong_t max_cpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_cpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA max_cpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._max_cpool_sizeOffset_));
	}

	// u_longlong_t max_cpool_size
	public UDATAPointer max_cpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._max_cpool_sizeOffset_));
	}

	// I32 max_cpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_cpusOffset_", declaredType="I32")
	public IDATA max_cpus() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._max_cpusOffset_));
	}

	// I32 max_cpus
	public IDATAPointer max_cpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._max_cpusOffset_));
	}

	// u_longlong_t max_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_memoryOffset_", declaredType="u_longlong_t")
	public UDATA max_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._max_memoryOffset_));
	}

	// u_longlong_t max_memory
	public UDATAPointer max_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._max_memoryOffset_));
	}

	// I32 max_phys_cpus_sys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_phys_cpus_sysOffset_", declaredType="I32")
	public IDATA max_phys_cpus_sys() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._max_phys_cpus_sysOffset_));
	}

	// I32 max_phys_cpus_sys
	public IDATAPointer max_phys_cpus_sysEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._max_phys_cpus_sysOffset_));
	}

	// u_longlong_t max_pool_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_pool_capacityOffset_", declaredType="u_longlong_t")
	public UDATA max_pool_capacity() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._max_pool_capacityOffset_));
	}

	// u_longlong_t max_pool_capacity
	public UDATAPointer max_pool_capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._max_pool_capacityOffset_));
	}

	// I32 max_proc_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_proc_capacityOffset_", declaredType="I32")
	public IDATA max_proc_capacity() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._max_proc_capacityOffset_));
	}

	// I32 max_proc_capacity
	public IDATAPointer max_proc_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._max_proc_capacityOffset_));
	}

	// I32 min_cpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_min_cpusOffset_", declaredType="I32")
	public IDATA min_cpus() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._min_cpusOffset_));
	}

	// I32 min_cpus
	public IDATAPointer min_cpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._min_cpusOffset_));
	}

	// u_longlong_t min_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_min_memoryOffset_", declaredType="u_longlong_t")
	public UDATA min_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._min_memoryOffset_));
	}

	// u_longlong_t min_memory
	public UDATAPointer min_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._min_memoryOffset_));
	}

	// I32 min_proc_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_min_proc_capacityOffset_", declaredType="I32")
	public IDATA min_proc_capacity() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._min_proc_capacityOffset_));
	}

	// I32 min_proc_capacity
	public IDATAPointer min_proc_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._min_proc_capacityOffset_));
	}

	// u_longlong_t min_ucpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_min_ucpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA min_ucpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._min_ucpool_sizeOffset_));
	}

	// u_longlong_t min_ucpool_size
	public UDATAPointer min_ucpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._min_ucpool_sizeOffset_));
	}

	// U8[] name
	public U8Pointer nameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(perfstat_partition_total_t._nameOffset_));
	}

	// I32 online_cpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_cpusOffset_", declaredType="I32")
	public IDATA online_cpus() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._online_cpusOffset_));
	}

	// I32 online_cpus
	public IDATAPointer online_cpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._online_cpusOffset_));
	}

	// uint online_lcpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_lcpusOffset_", declaredType="uint")
	public UDATA online_lcpus() throws CorruptDataException {
		return new U32(getIntAtOffset(perfstat_partition_total_t._online_lcpusOffset_));
	}

	// uint online_lcpus
	public UDATAPointer online_lcpusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._online_lcpusOffset_));
	}

	// u_longlong_t online_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_memoryOffset_", declaredType="u_longlong_t")
	public UDATA online_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._online_memoryOffset_));
	}

	// u_longlong_t online_memory
	public UDATAPointer online_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._online_memoryOffset_));
	}

	// I32 online_phys_cpus_sys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_phys_cpus_sysOffset_", declaredType="I32")
	public IDATA online_phys_cpus_sys() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._online_phys_cpus_sysOffset_));
	}

	// I32 online_phys_cpus_sys
	public IDATAPointer online_phys_cpus_sysEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._online_phys_cpus_sysOffset_));
	}

	// u_longlong_t phantintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phantintrsOffset_", declaredType="u_longlong_t")
	public UDATA phantintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._phantintrsOffset_));
	}

	// u_longlong_t phantintrs
	public UDATAPointer phantintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._phantintrsOffset_));
	}

	// I32 phys_cpus_pool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phys_cpus_poolOffset_", declaredType="I32")
	public IDATA phys_cpus_pool() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._phys_cpus_poolOffset_));
	}

	// I32 phys_cpus_pool
	public IDATAPointer phys_cpus_poolEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._phys_cpus_poolOffset_));
	}

	// u_longlong_t pidle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidleOffset_", declaredType="u_longlong_t")
	public UDATA pidle() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pidleOffset_));
	}

	// u_longlong_t pidle
	public UDATAPointer pidleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pidleOffset_));
	}

	// u_longlong_t pidle_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidle_spurrOffset_", declaredType="u_longlong_t")
	public UDATA pidle_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pidle_spurrOffset_));
	}

	// u_longlong_t pidle_spurr
	public UDATAPointer pidle_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pidle_spurrOffset_));
	}

	// u_longlong_t pmem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pmemOffset_", declaredType="u_longlong_t")
	public UDATA pmem() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pmemOffset_));
	}

	// u_longlong_t pmem
	public UDATAPointer pmemEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pmemOffset_));
	}

	// u_longlong_t pool_busy_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_busy_timeOffset_", declaredType="u_longlong_t")
	public UDATA pool_busy_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pool_busy_timeOffset_));
	}

	// u_longlong_t pool_busy_time
	public UDATAPointer pool_busy_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pool_busy_timeOffset_));
	}

	// I32 pool_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_idOffset_", declaredType="I32")
	public IDATA pool_id() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._pool_idOffset_));
	}

	// I32 pool_id
	public IDATAPointer pool_idEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pool_idOffset_));
	}

	// u_longlong_t pool_idle_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_idle_timeOffset_", declaredType="u_longlong_t")
	public UDATA pool_idle_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pool_idle_timeOffset_));
	}

	// u_longlong_t pool_idle_time
	public UDATAPointer pool_idle_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pool_idle_timeOffset_));
	}

	// u_longlong_t pool_max_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_max_timeOffset_", declaredType="u_longlong_t")
	public UDATA pool_max_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pool_max_timeOffset_));
	}

	// u_longlong_t pool_max_time
	public UDATAPointer pool_max_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pool_max_timeOffset_));
	}

	// u_longlong_t pool_scaled_busy_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_scaled_busy_timeOffset_", declaredType="u_longlong_t")
	public UDATA pool_scaled_busy_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pool_scaled_busy_timeOffset_));
	}

	// u_longlong_t pool_scaled_busy_time
	public UDATAPointer pool_scaled_busy_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pool_scaled_busy_timeOffset_));
	}

	// uint power_save_mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_power_save_modeOffset_", declaredType="uint")
	public UDATA power_save_mode() throws CorruptDataException {
		return new U32(getIntAtOffset(perfstat_partition_total_t._power_save_modeOffset_));
	}

	// uint power_save_mode
	public UDATAPointer power_save_modeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._power_save_modeOffset_));
	}

	// I32 proc_capacity_increment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_proc_capacity_incrementOffset_", declaredType="I32")
	public IDATA proc_capacity_increment() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._proc_capacity_incrementOffset_));
	}

	// I32 proc_capacity_increment
	public IDATAPointer proc_capacity_incrementEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._proc_capacity_incrementOffset_));
	}

	// u_longlong_t psys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psysOffset_", declaredType="u_longlong_t")
	public UDATA psys() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._psysOffset_));
	}

	// u_longlong_t psys
	public UDATAPointer psysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._psysOffset_));
	}

	// u_longlong_t psys_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psys_spurrOffset_", declaredType="u_longlong_t")
	public UDATA psys_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._psys_spurrOffset_));
	}

	// u_longlong_t psys_spurr
	public UDATAPointer psys_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._psys_spurrOffset_));
	}

	// u_longlong_t purr_coalescing
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_purr_coalescingOffset_", declaredType="u_longlong_t")
	public UDATA purr_coalescing() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._purr_coalescingOffset_));
	}

	// u_longlong_t purr_coalescing
	public UDATAPointer purr_coalescingEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._purr_coalescingOffset_));
	}

	// u_longlong_t purr_counter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_purr_counterOffset_", declaredType="u_longlong_t")
	public UDATA purr_counter() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._purr_counterOffset_));
	}

	// u_longlong_t purr_counter
	public UDATAPointer purr_counterEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._purr_counterOffset_));
	}

	// u_longlong_t puser
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puserOffset_", declaredType="u_longlong_t")
	public UDATA puser() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._puserOffset_));
	}

	// u_longlong_t puser
	public UDATAPointer puserEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._puserOffset_));
	}

	// u_longlong_t puser_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puser_spurrOffset_", declaredType="u_longlong_t")
	public UDATA puser_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._puser_spurrOffset_));
	}

	// u_longlong_t puser_spurr
	public UDATAPointer puser_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._puser_spurrOffset_));
	}

	// u_longlong_t pwait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwaitOffset_", declaredType="u_longlong_t")
	public UDATA pwait() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pwaitOffset_));
	}

	// u_longlong_t pwait
	public UDATAPointer pwaitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pwaitOffset_));
	}

	// u_longlong_t pwait_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwait_spurrOffset_", declaredType="u_longlong_t")
	public UDATA pwait_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._pwait_spurrOffset_));
	}

	// u_longlong_t pwait_spurr
	public UDATAPointer pwait_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._pwait_spurrOffset_));
	}

	// u_longlong_t real_avail
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_availOffset_", declaredType="u_longlong_t")
	public UDATA real_avail() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._real_availOffset_));
	}

	// u_longlong_t real_avail
	public UDATAPointer real_availEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._real_availOffset_));
	}

	// u_longlong_t real_free
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_freeOffset_", declaredType="u_longlong_t")
	public UDATA real_free() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._real_freeOffset_));
	}

	// u_longlong_t real_free
	public UDATAPointer real_freeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._real_freeOffset_));
	}

	// u_longlong_t reserved_pages
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved_pagesOffset_", declaredType="u_longlong_t")
	public UDATA reserved_pages() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._reserved_pagesOffset_));
	}

	// u_longlong_t reserved_pages
	public UDATAPointer reserved_pagesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._reserved_pagesOffset_));
	}

	// u_longlong_t reserved_pagesize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved_pagesizeOffset_", declaredType="u_longlong_t")
	public UDATA reserved_pagesize() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._reserved_pagesizeOffset_));
	}

	// u_longlong_t reserved_pagesize
	public UDATAPointer reserved_pagesizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._reserved_pagesizeOffset_));
	}

	// u_longlong_t shcpu_busy_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shcpu_busy_timeOffset_", declaredType="u_longlong_t")
	public UDATA shcpu_busy_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._shcpu_busy_timeOffset_));
	}

	// u_longlong_t shcpu_busy_time
	public UDATAPointer shcpu_busy_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._shcpu_busy_timeOffset_));
	}

	// u_longlong_t shcpu_scaled_busy_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shcpu_scaled_busy_timeOffset_", declaredType="u_longlong_t")
	public UDATA shcpu_scaled_busy_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._shcpu_scaled_busy_timeOffset_));
	}

	// u_longlong_t shcpu_scaled_busy_time
	public UDATAPointer shcpu_scaled_busy_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._shcpu_scaled_busy_timeOffset_));
	}

	// u_longlong_t shcpu_tot_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shcpu_tot_timeOffset_", declaredType="u_longlong_t")
	public UDATA shcpu_tot_time() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._shcpu_tot_timeOffset_));
	}

	// u_longlong_t shcpu_tot_time
	public UDATAPointer shcpu_tot_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._shcpu_tot_timeOffset_));
	}

	// u_longlong_t shcpus_in_sys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shcpus_in_sysOffset_", declaredType="u_longlong_t")
	public UDATA shcpus_in_sys() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._shcpus_in_sysOffset_));
	}

	// u_longlong_t shcpus_in_sys
	public UDATAPointer shcpus_in_sysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._shcpus_in_sysOffset_));
	}

	// uint smt_thrds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_smt_thrdsOffset_", declaredType="uint")
	public UDATA smt_thrds() throws CorruptDataException {
		return new U32(getIntAtOffset(perfstat_partition_total_t._smt_thrdsOffset_));
	}

	// uint smt_thrds
	public UDATAPointer smt_thrdsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._smt_thrdsOffset_));
	}

	// u_longlong_t spurr_coalescing
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spurr_coalescingOffset_", declaredType="u_longlong_t")
	public UDATA spurr_coalescing() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._spurr_coalescingOffset_));
	}

	// u_longlong_t spurr_coalescing
	public UDATAPointer spurr_coalescingEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._spurr_coalescingOffset_));
	}

	// u_longlong_t spurr_counter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spurr_counterOffset_", declaredType="u_longlong_t")
	public UDATA spurr_counter() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._spurr_counterOffset_));
	}

	// u_longlong_t spurr_counter
	public UDATAPointer spurr_counterEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._spurr_counterOffset_));
	}

	// I32 spurrflag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spurrflagOffset_", declaredType="I32")
	public IDATA spurrflag() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._spurrflagOffset_));
	}

	// I32 spurrflag
	public IDATAPointer spurrflagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._spurrflagOffset_));
	}

	// u_longlong_t target_cpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_target_cpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA target_cpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._target_cpool_sizeOffset_));
	}

	// u_longlong_t target_cpool_size
	public UDATAPointer target_cpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._target_cpool_sizeOffset_));
	}

	// u_longlong_t target_memexp_factr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_target_memexp_factrOffset_", declaredType="u_longlong_t")
	public UDATA target_memexp_factr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._target_memexp_factrOffset_));
	}

	// u_longlong_t target_memexp_factr
	public UDATAPointer target_memexp_factrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._target_memexp_factrOffset_));
	}

	// u_longlong_t timebase_last
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timebase_lastOffset_", declaredType="u_longlong_t")
	public UDATA timebase_last() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._timebase_lastOffset_));
	}

	// u_longlong_t timebase_last
	public UDATAPointer timebase_lastEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._timebase_lastOffset_));
	}

	// u_longlong_t true_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_true_memoryOffset_", declaredType="u_longlong_t")
	public UDATA true_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._true_memoryOffset_));
	}

	// u_longlong_t true_memory
	public UDATAPointer true_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._true_memoryOffset_));
	}

	// perfstat_partition_type_t type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="perfstat_partition_type_t")
	public perfstat_partition_type_tPointer type() throws CorruptDataException {
		return perfstat_partition_type_tPointer.cast(nonNullFieldEA(perfstat_partition_total_t._typeOffset_));
	}

	// perfstat_partition_type_t type
	public PointerPointer typeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(perfstat_partition_total_t._typeOffset_));
	}

	// I32 unalloc_proc_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unalloc_proc_capacityOffset_", declaredType="I32")
	public IDATA unalloc_proc_capacity() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._unalloc_proc_capacityOffset_));
	}

	// I32 unalloc_proc_capacity
	public IDATAPointer unalloc_proc_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._unalloc_proc_capacityOffset_));
	}

	// I32 unalloc_var_proc_capacity_weight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unalloc_var_proc_capacity_weightOffset_", declaredType="I32")
	public IDATA unalloc_var_proc_capacity_weight() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._unalloc_var_proc_capacity_weightOffset_));
	}

	// I32 unalloc_var_proc_capacity_weight
	public IDATAPointer unalloc_var_proc_capacity_weightEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._unalloc_var_proc_capacity_weightOffset_));
	}

	// I32 var_mem_weight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_var_mem_weightOffset_", declaredType="I32")
	public IDATA var_mem_weight() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._var_mem_weightOffset_));
	}

	// I32 var_mem_weight
	public IDATAPointer var_mem_weightEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._var_mem_weightOffset_));
	}

	// I32 var_proc_capacity_weight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_var_proc_capacity_weightOffset_", declaredType="I32")
	public IDATA var_proc_capacity_weight() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_partition_total_t._var_proc_capacity_weightOffset_));
	}

	// I32 var_proc_capacity_weight
	public IDATAPointer var_proc_capacity_weightEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._var_proc_capacity_weightOffset_));
	}

	// u_longlong_t version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="u_longlong_t")
	public UDATA version() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._versionOffset_));
	}

	// u_longlong_t version
	public UDATAPointer versionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._versionOffset_));
	}

	// u_longlong_t vol_virt_cswitch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vol_virt_cswitchOffset_", declaredType="u_longlong_t")
	public UDATA vol_virt_cswitch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_partition_total_t._vol_virt_cswitchOffset_));
	}

	// u_longlong_t vol_virt_cswitch
	public UDATAPointer vol_virt_cswitchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_partition_total_t._vol_virt_cswitchOffset_));
	}

}
