/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: prochrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the prochrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=prochr.class)
public class prochrPointer extends StructurePointer {

	// NULL
	public static final prochrPointer NULL = new prochrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected prochrPointer(long address) {
		super(address);
	}

	public static prochrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static prochrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static prochrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new prochrPointer(address);
	}

	public prochrPointer add(long count) {
		return prochrPointer.cast(address + (prochr.SIZEOF * count));
	}

	public prochrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public prochrPointer addOffset(long offset) {
		return prochrPointer.cast(address + offset);
	}

	public prochrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public prochrPointer sub(long count) {
		return prochrPointer.cast(address - (prochr.SIZEOF * count));
	}

	public prochrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public prochrPointer subOffset(long offset) {
		return prochrPointer.cast(address - offset);
	}

	public prochrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public prochrPointer untag(long mask) {
		return prochrPointer.cast(address & ~mask);
	}

	public prochrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return prochr.SIZEOF;
	}

	// Implementation methods

	// I32 pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_padOffset_", declaredType="I32")
	public IDATA pad() throws CorruptDataException {
		return new I32(getIntAtOffset(prochr._padOffset_));
	}

	// I32 pad
	public IDATAPointer padEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(prochr._padOffset_));
	}

	// void* prochr_handler
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prochr_handlerOffset_", declaredType="void*")
	public VoidPointer prochr_handler() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(prochr._prochr_handlerOffset_));
	}

	// void* prochr_handler
	public PointerPointer prochr_handlerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(prochr._prochr_handlerOffset_));
	}

	// uint prochr_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prochr_maskOffset_", declaredType="uint")
	public UDATA prochr_mask() throws CorruptDataException {
		return new U32(getIntAtOffset(prochr._prochr_maskOffset_));
	}

	// uint prochr_mask
	public UDATAPointer prochr_maskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(prochr._prochr_maskOffset_));
	}

	// prochr* prochr_next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prochr_nextOffset_", declaredType="prochr*")
	public prochrPointer prochr_next() throws CorruptDataException {
		return prochrPointer.cast(getPointerAtOffset(prochr._prochr_nextOffset_));
	}

	// prochr* prochr_next
	public PointerPointer prochr_nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(prochr._prochr_nextOffset_));
	}

}
