/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: pvthreadPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the pvthreadPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=pvthread.class)
public class pvthreadPointer extends StructurePointer {

	// NULL
	public static final pvthreadPointer NULL = new pvthreadPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected pvthreadPointer(long address) {
		super(address);
	}

	public static pvthreadPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static pvthreadPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static pvthreadPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new pvthreadPointer(address);
	}

	public pvthreadPointer add(long count) {
		return pvthreadPointer.cast(address + (pvthread.SIZEOF * count));
	}

	public pvthreadPointer add(Scalar count) {
		return add(count.longValue());
	}

	public pvthreadPointer addOffset(long offset) {
		return pvthreadPointer.cast(address + offset);
	}

	public pvthreadPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public pvthreadPointer sub(long count) {
		return pvthreadPointer.cast(address - (pvthread.SIZEOF * count));
	}

	public pvthreadPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public pvthreadPointer subOffset(long offset) {
		return pvthreadPointer.cast(address - offset);
	}

	public pvthreadPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public pvthreadPointer untag(long mask) {
		return pvthreadPointer.cast(address & ~mask);
	}

	public pvthreadPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return pvthread.SIZEOF;
	}

	// Implementation methods

	// cpu_t tv_affinity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_affinityOffset_", declaredType="cpu_t")
	public I16 tv_affinity() throws CorruptDataException {
		return new I16(getShortAtOffset(pvthread._tv_affinityOffset_));
	}

	// cpu_t tv_affinity
	public I16Pointer tv_affinityEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(pvthread._tv_affinityOffset_));
	}

	// void* tv_chkfile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_chkfileOffset_", declaredType="void*")
	public VoidPointer tv_chkfile() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvthread._tv_chkfileOffset_));
	}

	// void* tv_chkfile
	public PointerPointer tv_chkfileEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_chkfileOffset_));
	}

	// class_id_t tv_class
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_classOffset_", declaredType="class_id_t")
	public UDATA tv_class() throws CorruptDataException {
		return new U32(getIntAtOffset(pvthread._tv_classOffset_));
	}

	// class_id_t tv_class
	public UDATAPointer tv_classEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_classOffset_));
	}

	// thread_eye_catch_t tv_eyec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_eyecOffset_", declaredType="thread_eye_catch_t")
	public UDATA tv_eyec() throws CorruptDataException {
		return new U64(getLongAtOffset(pvthread._tv_eyecOffset_));
	}

	// thread_eye_catch_t tv_eyec
	public UDATAPointer tv_eyecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_eyecOffset_));
	}

	// uint tv_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_flagsOffset_", declaredType="uint")
	public UDATA tv_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(pvthread._tv_flagsOffset_));
	}

	// uint tv_flags
	public UDATAPointer tv_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_flagsOffset_));
	}

	// uint tv_flags2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_flags2Offset_", declaredType="uint")
	public UDATA tv_flags2() throws CorruptDataException {
		return new U32(getIntAtOffset(pvthread._tv_flags2Offset_));
	}

	// uint tv_flags2
	public UDATAPointer tv_flags2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_flags2Offset_));
	}

	// Simple_lock tv_hmcr_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_hmcr_lockOffset_", declaredType="Simple_lock")
	public _simple_lockPointer tv_hmcr_lock() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvthread._tv_hmcr_lockOffset_));
	}

	// Simple_lock tv_hmcr_lock
	public PointerPointer tv_hmcr_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_hmcr_lockOffset_));
	}

	// I16 tv_intercept_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_intercept_countOffset_", declaredType="I16")
	public I16 tv_intercept_count() throws CorruptDataException {
		return new I16(getShortAtOffset(pvthread._tv_intercept_countOffset_));
	}

	// I16 tv_intercept_count
	public I16Pointer tv_intercept_countEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(pvthread._tv_intercept_countOffset_));
	}

	// I32[] tv_itags
	public IDATAPointer tv_itagsEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(pvthread._tv_itagsOffset_));
	}

	// void* tv_itags_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_itags_ptrOffset_", declaredType="void*")
	public VoidPointer tv_itags_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvthread._tv_itags_ptrOffset_));
	}

	// void* tv_itags_ptr
	public PointerPointer tv_itags_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_itags_ptrOffset_));
	}

	// Simple_lock tv_lock_d
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_lock_dOffset_", declaredType="Simple_lock")
	public _simple_lockPointer tv_lock_d() throws CorruptDataException {
		return _simple_lockPointer.cast(nonNullFieldEA(pvthread._tv_lock_dOffset_));
	}

	// Simple_lock tv_lock_d
	public PointerPointer tv_lock_dEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_lock_dOffset_));
	}

	// pvthread* tv_nextzombie
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_nextzombieOffset_", declaredType="pvthread*")
	public pvthreadPointer tv_nextzombie() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvthread._tv_nextzombieOffset_));
	}

	// pvthread* tv_nextzombie
	public PointerPointer tv_nextzombieEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_nextzombieOffset_));
	}

	// U8[] tv_pad
	public U8Pointer tv_padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvthread._tv_padOffset_));
	}

	// U8 tv_pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_pad1Offset_", declaredType="U8")
	public U8 tv_pad1() throws CorruptDataException {
		return new U8(getByteAtOffset(pvthread._tv_pad1Offset_));
	}

	// U8 tv_pad1
	public U8Pointer tv_pad1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvthread._tv_pad1Offset_));
	}

	// I32 tv_pad2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_pad2Offset_", declaredType="I32")
	public IDATA tv_pad2() throws CorruptDataException {
		return new I32(getIntAtOffset(pvthread._tv_pad2Offset_));
	}

	// I32 tv_pad2
	public IDATAPointer tv_pad2EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvthread._tv_pad2Offset_));
	}

	// void* tv_pmcontext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_pmcontextOffset_", declaredType="void*")
	public VoidPointer tv_pmcontext() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvthread._tv_pmcontextOffset_));
	}

	// void* tv_pmcontext
	public PointerPointer tv_pmcontextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_pmcontextOffset_));
	}

	// U64 tv_prbase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_prbaseOffset_", declaredType="U64")
	public UDATA tv_prbase() throws CorruptDataException {
		return new U64(getLongAtOffset(pvthread._tv_prbaseOffset_));
	}

	// U64 tv_prbase
	public UDATAPointer tv_prbaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_prbaseOffset_));
	}

	// ushort tv_prbufcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_prbufcountOffset_", declaredType="ushort")
	public U16 tv_prbufcount() throws CorruptDataException {
		return new U16(getShortAtOffset(pvthread._tv_prbufcountOffset_));
	}

	// ushort tv_prbufcount
	public U16Pointer tv_prbufcountEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvthread._tv_prbufcountOffset_));
	}

	// ushort tv_prflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_prflagsOffset_", declaredType="ushort")
	public U16 tv_prflags() throws CorruptDataException {
		return new U16(getShortAtOffset(pvthread._tv_prflagsOffset_));
	}

	// ushort tv_prflags
	public U16Pointer tv_prflagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pvthread._tv_prflagsOffset_));
	}

	// U8 tv_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_priOffset_", declaredType="U8")
	public U8 tv_pri() throws CorruptDataException {
		return new U8(getByteAtOffset(pvthread._tv_priOffset_));
	}

	// U8 tv_pri
	public U8Pointer tv_priEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvthread._tv_priOffset_));
	}

	// vnode* tv_procfsvn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_procfsvnOffset_", declaredType="vnode*")
	public vnodePointer tv_procfsvn() throws CorruptDataException {
		return vnodePointer.cast(getPointerAtOffset(pvthread._tv_procfsvnOffset_));
	}

	// vnode* tv_procfsvn
	public PointerPointer tv_procfsvnEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_procfsvnOffset_));
	}

	// U64* tv_prpinned
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_prpinnedOffset_", declaredType="U64*")
	public UDATAPointer tv_prpinned() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(pvthread._tv_prpinnedOffset_));
	}

	// U64* tv_prpinned
	public PointerPointer tv_prpinnedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_prpinnedOffset_));
	}

	// U8* tv_ptag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_ptagOffset_", declaredType="U8*")
	public U8Pointer tv_ptag() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(pvthread._tv_ptagOffset_));
	}

	// U8* tv_ptag
	public PointerPointer tv_ptagEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_ptagOffset_));
	}

	// uint tv_ptid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_ptidOffset_", declaredType="uint")
	public UDATA tv_ptid() throws CorruptDataException {
		return new U32(getIntAtOffset(pvthread._tv_ptidOffset_));
	}

	// uint tv_ptid
	public UDATAPointer tv_ptidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_ptidOffset_));
	}

	// pvproc* tv_pvprocp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_pvprocpOffset_", declaredType="pvproc*")
	public pvprocPointer tv_pvprocp() throws CorruptDataException {
		return pvprocPointer.cast(getPointerAtOffset(pvthread._tv_pvprocpOffset_));
	}

	// pvproc* tv_pvprocp
	public PointerPointer tv_pvprocpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_pvprocpOffset_));
	}

	// void* tv_rset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_rsetOffset_", declaredType="void*")
	public VoidPointer tv_rset() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pvthread._tv_rsetOffset_));
	}

	// void* tv_rset
	public PointerPointer tv_rsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_rsetOffset_));
	}

	// U8 tv_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_stateOffset_", declaredType="U8")
	public U8 tv_state() throws CorruptDataException {
		return new U8(getByteAtOffset(pvthread._tv_stateOffset_));
	}

	// U8 tv_state
	public U8Pointer tv_stateEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvthread._tv_stateOffset_));
	}

	// tid_t tv_synch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_synchOffset_", declaredType="tid_t")
	public IDATA tv_synch() throws CorruptDataException {
		return new I64(getLongAtOffset(pvthread._tv_synchOffset_));
	}

	// tid_t tv_synch
	public IDATAPointer tv_synchEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvthread._tv_synchOffset_));
	}

	// pvthread* tv_threadlist.nextthread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_threadlist$nextthreadOffset_", declaredType="pvthread*")
	public pvthreadPointer tv_threadlist$nextthread() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvthread._tv_threadlist$nextthreadOffset_));
	}

	// pvthread* tv_threadlist.nextthread
	public PointerPointer tv_threadlist$nextthreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_threadlist$nextthreadOffset_));
	}

	// pvthread* tv_threadlist.prevthread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_threadlist$prevthreadOffset_", declaredType="pvthread*")
	public pvthreadPointer tv_threadlist$prevthread() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(pvthread._tv_threadlist$prevthreadOffset_));
	}

	// pvthread* tv_threadlist.prevthread
	public PointerPointer tv_threadlist$prevthreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_threadlist$prevthreadOffset_));
	}

	// thread* tv_threadp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_threadpOffset_", declaredType="thread*")
	public threadPointer tv_threadp() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(pvthread._tv_threadpOffset_));
	}

	// thread* tv_threadp
	public PointerPointer tv_threadpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_threadpOffset_));
	}

	// tid_t tv_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_tidOffset_", declaredType="tid_t")
	public IDATA tv_tid() throws CorruptDataException {
		return new I64(getLongAtOffset(pvthread._tv_tidOffset_));
	}

	// tid_t tv_tid
	public IDATAPointer tv_tidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvthread._tv_tidOffset_));
	}

	// u_longlong_t tv_totalcputime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_totalcputimeOffset_", declaredType="u_longlong_t")
	public UDATA tv_totalcputime() throws CorruptDataException {
		return new U64(getLongAtOffset(pvthread._tv_totalcputimeOffset_));
	}

	// u_longlong_t tv_totalcputime
	public UDATAPointer tv_totalcputimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_totalcputimeOffset_));
	}

	// u_longlong_t tv_totalscputime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_totalscputimeOffset_", declaredType="u_longlong_t")
	public UDATA tv_totalscputime() throws CorruptDataException {
		return new U64(getLongAtOffset(pvthread._tv_totalscputimeOffset_));
	}

	// u_longlong_t tv_totalscputime
	public UDATAPointer tv_totalscputimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pvthread._tv_totalscputimeOffset_));
	}

	// tid_t tv_tsleep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_tsleepOffset_", declaredType="tid_t")
	public IDATA tv_tsleep() throws CorruptDataException {
		return new I64(getLongAtOffset(pvthread._tv_tsleepOffset_));
	}

	// tid_t tv_tsleep
	public IDATAPointer tv_tsleepEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvthread._tv_tsleepOffset_));
	}

	// tid_t tv_vtid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_vtidOffset_", declaredType="tid_t")
	public IDATA tv_vtid() throws CorruptDataException {
		return new I64(getLongAtOffset(pvthread._tv_vtidOffset_));
	}

	// tid_t tv_vtid
	public IDATAPointer tv_vtidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvthread._tv_vtidOffset_));
	}

	// U8* tv_wchan
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_wchanOffset_", declaredType="U8*")
	public U8Pointer tv_wchan() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(pvthread._tv_wchanOffset_));
	}

	// U8* tv_wchan
	public PointerPointer tv_wchanEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pvthread._tv_wchanOffset_));
	}

	// I32 tv_wlm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_wlmOffset_", declaredType="I32")
	public IDATA tv_wlm() throws CorruptDataException {
		return new I32(getIntAtOffset(pvthread._tv_wlmOffset_));
	}

	// I32 tv_wlm
	public IDATAPointer tv_wlmEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pvthread._tv_wlmOffset_));
	}

	// U8 tv_wtype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tv_wtypeOffset_", declaredType="U8")
	public U8 tv_wtype() throws CorruptDataException {
		return new U8(getByteAtOffset(pvthread._tv_wtypeOffset_));
	}

	// U8 tv_wtype
	public U8Pointer tv_wtypeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pvthread._tv_wtypeOffset_));
	}

}
