/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: rsid_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the rsid_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=rsid_t.class)
public class rsid_tPointer extends StructurePointer {

	// NULL
	public static final rsid_tPointer NULL = new rsid_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected rsid_tPointer(long address) {
		super(address);
	}

	public static rsid_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static rsid_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static rsid_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new rsid_tPointer(address);
	}

	public rsid_tPointer add(long count) {
		return rsid_tPointer.cast(address + (rsid_t.SIZEOF * count));
	}

	public rsid_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public rsid_tPointer addOffset(long offset) {
		return rsid_tPointer.cast(address + offset);
	}

	public rsid_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public rsid_tPointer sub(long count) {
		return rsid_tPointer.cast(address - (rsid_t.SIZEOF * count));
	}

	public rsid_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public rsid_tPointer subOffset(long offset) {
		return rsid_tPointer.cast(address - offset);
	}

	public rsid_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public rsid_tPointer untag(long mask) {
		return rsid_tPointer.cast(address & ~mask);
	}

	public rsid_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return rsid_t.SIZEOF;
	}

	// Implementation methods

	// I32 at_fd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_fdOffset_", declaredType="I32")
	public IDATA at_fd() throws CorruptDataException {
		return new I32(getIntAtOffset(rsid_t._at_fdOffset_));
	}

	// I32 at_fd
	public IDATAPointer at_fdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(rsid_t._at_fdOffset_));
	}

	// pid_t at_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_pidOffset_", declaredType="pid_t")
	public IDATA at_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(rsid_t._at_pidOffset_));
	}

	// pid_t at_pid
	public IDATAPointer at_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(rsid_t._at_pidOffset_));
	}

	// rsethandle_t at_rset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_rsetOffset_", declaredType="rsethandle_t")
	public VoidPointer at_rset() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(rsid_t._at_rsetOffset_));
	}

	// rsethandle_t at_rset
	public PointerPointer at_rsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(rsid_t._at_rsetOffset_));
	}

	// I32 at_shmid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_shmidOffset_", declaredType="I32")
	public IDATA at_shmid() throws CorruptDataException {
		return new I32(getIntAtOffset(rsid_t._at_shmidOffset_));
	}

	// I32 at_shmid
	public IDATAPointer at_shmidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(rsid_t._at_shmidOffset_));
	}

	// sradid_t at_sradid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_sradidOffset_", declaredType="sradid_t")
	public I16 at_sradid() throws CorruptDataException {
		return new I16(getShortAtOffset(rsid_t._at_sradidOffset_));
	}

	// sradid_t at_sradid
	public I16Pointer at_sradidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(rsid_t._at_sradidOffset_));
	}

	// subrange_t* at_subrange
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_subrangeOffset_", declaredType="subrange_t*")
	public subrangePointer at_subrange() throws CorruptDataException {
		return subrangePointer.cast(getPointerAtOffset(rsid_t._at_subrangeOffset_));
	}

	// subrange_t* at_subrange
	public PointerPointer at_subrangeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(rsid_t._at_subrangeOffset_));
	}

	// tid_t at_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_at_tidOffset_", declaredType="tid_t")
	public IDATA at_tid() throws CorruptDataException {
		return new I64(getLongAtOffset(rsid_t._at_tidOffset_));
	}

	// tid_t at_tid
	public IDATAPointer at_tidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(rsid_t._at_tidOffset_));
	}

}
