/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sec_labelsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sec_labelsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sec_labels.class)
public class sec_labelsPointer extends StructurePointer {

	// NULL
	public static final sec_labelsPointer NULL = new sec_labelsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sec_labelsPointer(long address) {
		super(address);
	}

	public static sec_labelsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sec_labelsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sec_labelsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sec_labelsPointer(address);
	}

	public sec_labelsPointer add(long count) {
		return sec_labelsPointer.cast(address + (sec_labels.SIZEOF * count));
	}

	public sec_labelsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public sec_labelsPointer addOffset(long offset) {
		return sec_labelsPointer.cast(address + offset);
	}

	public sec_labelsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sec_labelsPointer sub(long count) {
		return sec_labelsPointer.cast(address - (sec_labels.SIZEOF * count));
	}

	public sec_labelsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sec_labelsPointer subOffset(long offset) {
		return sec_labelsPointer.cast(address - offset);
	}

	public sec_labelsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sec_labelsPointer untag(long mask) {
		return sec_labelsPointer.cast(address & ~mask);
	}

	public sec_labelsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sec_labels.SIZEOF;
	}

	// Implementation methods

	// sl_t sl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_slOffset_", declaredType="sl_t")
	public _sl_tPointer sl() throws CorruptDataException {
		return _sl_tPointer.cast(nonNullFieldEA(sec_labels._slOffset_));
	}

	// sl_t sl
	public PointerPointer slEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_labels._slOffset_));
	}

	// sl_t sl_cl_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sl_cl_maxOffset_", declaredType="sl_t")
	public _sl_tPointer sl_cl_max() throws CorruptDataException {
		return _sl_tPointer.cast(nonNullFieldEA(sec_labels._sl_cl_maxOffset_));
	}

	// sl_t sl_cl_max
	public PointerPointer sl_cl_maxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_labels._sl_cl_maxOffset_));
	}

	// sl_t sl_cl_min
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sl_cl_minOffset_", declaredType="sl_t")
	public _sl_tPointer sl_cl_min() throws CorruptDataException {
		return _sl_tPointer.cast(nonNullFieldEA(sec_labels._sl_cl_minOffset_));
	}

	// sl_t sl_cl_min
	public PointerPointer sl_cl_minEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_labels._sl_cl_minOffset_));
	}

	// tl_t tl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tlOffset_", declaredType="tl_t")
	public _tl_tPointer tl() throws CorruptDataException {
		return _tl_tPointer.cast(nonNullFieldEA(sec_labels._tlOffset_));
	}

	// tl_t tl
	public PointerPointer tlEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_labels._tlOffset_));
	}

	// tl_t tl_cl_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tl_cl_maxOffset_", declaredType="tl_t")
	public _tl_tPointer tl_cl_max() throws CorruptDataException {
		return _tl_tPointer.cast(nonNullFieldEA(sec_labels._tl_cl_maxOffset_));
	}

	// tl_t tl_cl_max
	public PointerPointer tl_cl_maxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_labels._tl_cl_maxOffset_));
	}

	// tl_t tl_cl_min
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tl_cl_minOffset_", declaredType="tl_t")
	public _tl_tPointer tl_cl_min() throws CorruptDataException {
		return _tl_tPointer.cast(nonNullFieldEA(sec_labels._tl_cl_minOffset_));
	}

	// tl_t tl_cl_min
	public PointerPointer tl_cl_minEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sec_labels._tl_cl_minOffset_));
	}

}
