/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: subsec_attrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the subsec_attrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=subsec_attr.class)
public class subsec_attrPointer extends StructurePointer {

	// NULL
	public static final subsec_attrPointer NULL = new subsec_attrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected subsec_attrPointer(long address) {
		super(address);
	}

	public static subsec_attrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static subsec_attrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static subsec_attrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new subsec_attrPointer(address);
	}

	public subsec_attrPointer add(long count) {
		return subsec_attrPointer.cast(address + (subsec_attr.SIZEOF * count));
	}

	public subsec_attrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public subsec_attrPointer addOffset(long offset) {
		return subsec_attrPointer.cast(address + offset);
	}

	public subsec_attrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public subsec_attrPointer sub(long count) {
		return subsec_attrPointer.cast(address - (subsec_attr.SIZEOF * count));
	}

	public subsec_attrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public subsec_attrPointer subOffset(long offset) {
		return subsec_attrPointer.cast(address - offset);
	}

	public subsec_attrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public subsec_attrPointer untag(long mask) {
		return subsec_attrPointer.cast(address & ~mask);
	}

	public subsec_attrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return subsec_attr.SIZEOF;
	}

	// Implementation methods

	// privg_t effpriv
	public UDATAPointer effprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(subsec_attr._effprivOffset_));
	}

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(subsec_attr._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(subsec_attr._flagsOffset_));
	}

	// privg_t inhpriv
	public UDATAPointer inhprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(subsec_attr._inhprivOffset_));
	}

	// sec_labels_t labels
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_labelsOffset_", declaredType="sec_labels_t")
	public sec_labelsPointer labels() throws CorruptDataException {
		return sec_labelsPointer.cast(nonNullFieldEA(subsec_attr._labelsOffset_));
	}

	// sec_labels_t labels
	public PointerPointer labelsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(subsec_attr._labelsOffset_));
	}

	// privg_t limpriv
	public UDATAPointer limprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(subsec_attr._limprivOffset_));
	}

	// privg_t maxpriv
	public UDATAPointer maxprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(subsec_attr._maxprivOffset_));
	}

	// I16 nroles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nrolesOffset_", declaredType="I16")
	public I16 nroles() throws CorruptDataException {
		return new I16(getShortAtOffset(subsec_attr._nrolesOffset_));
	}

	// I16 nroles
	public I16Pointer nrolesEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(subsec_attr._nrolesOffset_));
	}

	// I16 ntrauths
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ntrauthsOffset_", declaredType="I16")
	public I16 ntrauths() throws CorruptDataException {
		return new I16(getShortAtOffset(subsec_attr._ntrauthsOffset_));
	}

	// I16 ntrauths
	public I16Pointer ntrauthsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(subsec_attr._ntrauthsOffset_));
	}

	// I32[] reserved
	public IDATAPointer reservedEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(subsec_attr._reservedOffset_));
	}

	// rid_t[] roles
	public UDATAPointer rolesEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(subsec_attr._rolesOffset_));
	}

	// privg_t usedpriv
	public UDATAPointer usedprivEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(subsec_attr._usedprivOffset_));
	}

}
