/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: threadPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the threadPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=thread.class)
public class threadPointer extends StructurePointer {

	// NULL
	public static final threadPointer NULL = new threadPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected threadPointer(long address) {
		super(address);
	}

	public static threadPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static threadPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static threadPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new threadPointer(address);
	}

	public threadPointer add(long count) {
		return threadPointer.cast(address + (thread.SIZEOF * count));
	}

	public threadPointer add(Scalar count) {
		return add(count.longValue());
	}

	public threadPointer addOffset(long offset) {
		return threadPointer.cast(address + offset);
	}

	public threadPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public threadPointer sub(long count) {
		return threadPointer.cast(address - (thread.SIZEOF * count));
	}

	public threadPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public threadPointer subOffset(long offset) {
		return threadPointer.cast(address - offset);
	}

	public threadPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public threadPointer untag(long mask) {
		return threadPointer.cast(address & ~mask);
	}

	public threadPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return thread.SIZEOF;
	}

	// Implementation methods

	// U64 pth_stime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pth_stimeOffset_", declaredType="U64")
	public UDATA pth_stime() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._pth_stimeOffset_));
	}

	// U64 pth_stime
	public UDATAPointer pth_stimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._pth_stimeOffset_));
	}

	// U64 pth_utime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pth_utimeOffset_", declaredType="U64")
	public UDATA pth_utime() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._pth_utimeOffset_));
	}

	// U64 pth_utime
	public UDATAPointer pth_utimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._pth_utimeOffset_));
	}

	// ushort t_adsp_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_adsp_flagsOffset_", declaredType="ushort")
	public U16 t_adsp_flags() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_adsp_flagsOffset_));
	}

	// ushort t_adsp_flags
	public U16Pointer t_adsp_flagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_adsp_flagsOffset_));
	}

	// mrq_mask_t* t_advrset_maskp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_advrset_maskpOffset_", declaredType="mrq_mask_t*")
	public mrq_mask_tPointer t_advrset_maskp() throws CorruptDataException {
		return mrq_mask_tPointer.cast(getPointerAtOffset(thread._t_advrset_maskpOffset_));
	}

	// mrq_mask_t* t_advrset_maskp
	public PointerPointer t_advrset_maskpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_advrset_maskpOffset_));
	}

	// time_t t_affinity_ts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_affinity_tsOffset_", declaredType="time_t")
	public IDATA t_affinity_ts() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_affinity_tsOffset_));
	}

	// time_t t_affinity_ts
	public IDATAPointer t_affinity_tsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_affinity_tsOffset_));
	}

	// mrq_mask_t t_allowed_cpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_allowed_cpusOffset_", declaredType="mrq_mask_t")
	public mrq_mask_tPointer t_allowed_cpus() throws CorruptDataException {
		return mrq_mask_tPointer.cast(nonNullFieldEA(thread._t_allowed_cpusOffset_));
	}

	// mrq_mask_t t_allowed_cpus
	public PointerPointer t_allowed_cpusEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_allowed_cpusOffset_));
	}

	// ulong t_atomic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_atomicOffset_", declaredType="ulong")
	public UDATA t_atomic() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_atomicOffset_));
	}

	// ulong t_atomic
	public UDATAPointer t_atomicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_atomicOffset_));
	}

	// U32 t_attachmap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_attachmapOffset_", declaredType="U32")
	public UDATA t_attachmap() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_attachmapOffset_));
	}

	// U32 t_attachmap
	public UDATAPointer t_attachmapEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_attachmapOffset_));
	}

	// U8 t_boost_level
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_boost_levelOffset_", declaredType="U8")
	public U8 t_boost_level() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_boost_levelOffset_));
	}

	// U8 t_boost_level
	public U8Pointer t_boost_levelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_boost_levelOffset_));
	}

	// U8 t_boost_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_boost_typeOffset_", declaredType="U8")
	public U8 t_boost_type() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_boost_typeOffset_));
	}

	// U8 t_boost_type
	public U8Pointer t_boost_typeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_boost_typeOffset_));
	}

	// U16 t_borrow_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_borrow_priOffset_", declaredType="U16")
	public U16 t_borrow_pri() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_borrow_priOffset_));
	}

	// U16 t_borrow_pri
	public U16Pointer t_borrow_priEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_borrow_priOffset_));
	}

	// U32 t_borrowed_util
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_borrowed_utilOffset_", declaredType="U32")
	public UDATA t_borrowed_util() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_borrowed_utilOffset_));
	}

	// U32 t_borrowed_util
	public UDATAPointer t_borrowed_utilEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_borrowed_utilOffset_));
	}

	// U8 t_ceiling
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ceilingOffset_", declaredType="U8")
	public U8 t_ceiling() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_ceilingOffset_));
	}

	// U8 t_ceiling
	public U8Pointer t_ceilingEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_ceilingOffset_));
	}

	// I32 t_chkblock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_chkblockOffset_", declaredType="I32")
	public IDATA t_chkblock() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_chkblockOffset_));
	}

	// I32 t_chkblock
	public IDATAPointer t_chkblockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_chkblockOffset_));
	}

	// ushort t_chkerror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_chkerrorOffset_", declaredType="ushort")
	public U16 t_chkerror() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_chkerrorOffset_));
	}

	// ushort t_chkerror
	public U16Pointer t_chkerrorEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_chkerrorOffset_));
	}

	// ushort t_cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cpuOffset_", declaredType="ushort")
	public U16 t_cpu() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_cpuOffset_));
	}

	// ushort t_cpu
	public U16Pointer t_cpuEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_cpuOffset_));
	}

	// ushort t_cpu2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cpu2Offset_", declaredType="ushort")
	public U16 t_cpu2() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_cpu2Offset_));
	}

	// ushort t_cpu2
	public U16Pointer t_cpu2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_cpu2Offset_));
	}

	// uint t_cpu_tb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cpu_tbOffset_", declaredType="uint")
	public UDATA t_cpu_tb() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_cpu_tbOffset_));
	}

	// uint t_cpu_tb
	public UDATAPointer t_cpu_tbEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_cpu_tbOffset_));
	}

	// cpu_t t_cpuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cpuidOffset_", declaredType="cpu_t")
	public I16 t_cpuid() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_cpuidOffset_));
	}

	// cpu_t t_cpuid
	public I16Pointer t_cpuidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_cpuidOffset_));
	}

	// U64 t_cputime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cputimeOffset_", declaredType="U64")
	public UDATA t_cputime() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_cputimeOffset_));
	}

	// U64 t_cputime
	public UDATAPointer t_cputimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_cputimeOffset_));
	}

	// cred_t* t_credp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_credpOffset_", declaredType="cred_t*")
	public ucredPointer t_credp() throws CorruptDataException {
		return ucredPointer.cast(getPointerAtOffset(thread._t_credpOffset_));
	}

	// cred_t* t_credp
	public PointerPointer t_credpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_credpOffset_));
	}

	// U8 t_cursig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cursigOffset_", declaredType="U8")
	public U8 t_cursig() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_cursigOffset_));
	}

	// U8 t_cursig
	public U8Pointer t_cursigEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_cursigOffset_));
	}

	// I64 t_cv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_cvOffset_", declaredType="I64")
	public IDATA t_cv() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_cvOffset_));
	}

	// I64 t_cv
	public IDATAPointer t_cvEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_cvOffset_));
	}

	// pfh_delwait* t_delw
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_delwOffset_", declaredType="pfh_delwait*")
	public pfh_delwaitPointer t_delw() throws CorruptDataException {
		return pfh_delwaitPointer.cast(getPointerAtOffset(thread._t_delwOffset_));
	}

	// pfh_delwait* t_delw
	public PointerPointer t_delwEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_delwOffset_));
	}

	// U32 t_dispatch_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_dispatch_countOffset_", declaredType="U32")
	public UDATA t_dispatch_count() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_dispatch_countOffset_));
	}

	// U32 t_dispatch_count
	public UDATAPointer t_dispatch_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_dispatch_countOffset_));
	}

	// U8 t_dispatch_hist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_dispatch_histOffset_", declaredType="U8")
	public U8 t_dispatch_hist() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_dispatch_histOffset_));
	}

	// U8 t_dispatch_hist
	public U8Pointer t_dispatch_histEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_dispatch_histOffset_));
	}

	// ulong t_dispct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_dispctOffset_", declaredType="ulong")
	public UDATA t_dispct() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_dispctOffset_));
	}

	// ulong t_dispct
	public UDATAPointer t_dispctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_dispctOffset_));
	}

	// thread* t_eventlist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_eventlistOffset_", declaredType="thread*")
	public threadPointer t_eventlist() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_eventlistOffset_));
	}

	// thread* t_eventlist
	public PointerPointer t_eventlistEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_eventlistOffset_));
	}

	// void* t_evm_tlv_struct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_evm_tlv_structOffset_", declaredType="void*")
	public VoidPointer t_evm_tlv_struct() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(thread._t_evm_tlv_structOffset_));
	}

	// void* t_evm_tlv_struct
	public PointerPointer t_evm_tlv_structEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_evm_tlv_structOffset_));
	}

	// thread_eye_catch_t t_eyec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_eyecOffset_", declaredType="thread_eye_catch_t")
	public UDATA t_eyec() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_eyecOffset_));
	}

	// thread_eye_catch_t t_eyec
	public UDATAPointer t_eyecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_eyecOffset_));
	}

	// ulong t_far_dispct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_far_dispctOffset_", declaredType="ulong")
	public UDATA t_far_dispct() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_far_dispctOffset_));
	}

	// ulong t_far_dispct
	public UDATAPointer t_far_dispctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_far_dispctOffset_));
	}

	// uint t_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_flagsOffset_", declaredType="uint")
	public UDATA t_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_flagsOffset_));
	}

	// uint t_flags
	public UDATAPointer t_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_flagsOffset_));
	}

	// uint t_flags2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_flags2Offset_", declaredType="uint")
	public UDATA t_flags2() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_flags2Offset_));
	}

	// uint t_flags2
	public UDATAPointer t_flags2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_flags2Offset_));
	}

	// ushort t_flags3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_flags3Offset_", declaredType="ushort")
	public U16 t_flags3() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_flags3Offset_));
	}

	// ushort t_flags3
	public U16Pointer t_flags3EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_flags3Offset_));
	}

	// ulong t_fpuct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_fpuctOffset_", declaredType="ulong")
	public UDATA t_fpuct() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_fpuctOffset_));
	}

	// ulong t_fpuct
	public UDATAPointer t_fpuctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_fpuctOffset_));
	}

	// I32 t_fsflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_fsflagsOffset_", declaredType="I32")
	public IDATA t_fsflags() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_fsflagsOffset_));
	}

	// I32 t_fsflags
	public IDATAPointer t_fsflagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_fsflagsOffset_));
	}

	// void* t_graphics
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_graphicsOffset_", declaredType="void*")
	public VoidPointer t_graphics() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(thread._t_graphicsOffset_));
	}

	// void* t_graphics
	public PointerPointer t_graphicsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_graphicsOffset_));
	}

	// run_queue* t_home_rq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_home_rqOffset_", declaredType="run_queue*")
	public run_queuePointer t_home_rq() throws CorruptDataException {
		return run_queuePointer.cast(getPointerAtOffset(thread._t_home_rqOffset_));
	}

	// run_queue* t_home_rq
	public PointerPointer t_home_rqEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_home_rqOffset_));
	}

	// sradid_t t_home_sradid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_home_sradidOffset_", declaredType="sradid_t")
	public I16 t_home_sradid() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_home_sradidOffset_));
	}

	// sradid_t t_home_sradid
	public I16Pointer t_home_sradidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_home_sradidOffset_));
	}

	// I32 t_homecount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_homecountOffset_", declaredType="I32")
	public IDATA t_homecount() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_homecountOffset_));
	}

	// I32 t_homecount
	public IDATAPointer t_homecountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_homecountOffset_));
	}

	// U64 t_interval_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_interval_startOffset_", declaredType="U64")
	public UDATA t_interval_start() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_interval_startOffset_));
	}

	// U64 t_interval_start
	public UDATAPointer t_interval_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_interval_startOffset_));
	}

	// iopri_t t_io_priority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_io_priorityOffset_", declaredType="iopri_t")
	public I16 t_io_priority() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_io_priorityOffset_));
	}

	// iopri_t t_io_priority
	public I16Pointer t_io_priorityEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_io_priorityOffset_));
	}

	// U64 t_ipc_data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ipc_dataOffset_", declaredType="U64")
	public UDATA t_ipc_data() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_ipc_dataOffset_));
	}

	// U64 t_ipc_data
	public UDATAPointer t_ipc_dataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_ipc_dataOffset_));
	}

	// void* t_iprb_snpshtd_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_iprb_snpshtd_ptrOffset_", declaredType="void*")
	public VoidPointer t_iprb_snpshtd_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(thread._t_iprb_snpshtd_ptrOffset_));
	}

	// void* t_iprb_snpshtd_ptr
	public PointerPointer t_iprb_snpshtd_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_iprb_snpshtd_ptrOffset_));
	}

	// __sigcontext* t_kscp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_kscpOffset_", declaredType="__sigcontext*")
	public __sigcontextPointer t_kscp() throws CorruptDataException {
		return __sigcontextPointer.cast(getPointerAtOffset(thread._t_kscpOffset_));
	}

	// __sigcontext* t_kscp
	public PointerPointer t_kscpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_kscpOffset_));
	}

	// vmhandle_t t_kthreadseg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_kthreadsegOffset_", declaredType="vmhandle_t")
	public UDATA t_kthreadseg() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_kthreadsegOffset_));
	}

	// vmhandle_t t_kthreadseg
	public UDATAPointer t_kthreadsegEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_kthreadsegOffset_));
	}

	// u_longlong_t t_last_wakeup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_last_wakeupOffset_", declaredType="u_longlong_t")
	public UDATA t_last_wakeup() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_last_wakeupOffset_));
	}

	// u_longlong_t t_last_wakeup
	public UDATAPointer t_last_wakeupEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_last_wakeupOffset_));
	}

	// ulong t_latency_dispct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_latency_dispctOffset_", declaredType="ulong")
	public UDATA t_latency_dispct() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_latency_dispctOffset_));
	}

	// ulong t_latency_dispct
	public UDATAPointer t_latency_dispctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_latency_dispctOffset_));
	}

	// ulong t_latency_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_latency_totalOffset_", declaredType="ulong")
	public UDATA t_latency_total() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_latency_totalOffset_));
	}

	// ulong t_latency_total
	public UDATAPointer t_latency_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_latency_totalOffset_));
	}

	// cpu_t t_ldispcpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ldispcpuOffset_", declaredType="cpu_t")
	public I16 t_ldispcpu() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_ldispcpuOffset_));
	}

	// cpu_t t_ldispcpu
	public I16Pointer t_ldispcpuEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_ldispcpuOffset_));
	}

	// thread* t_lnext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_lnextOffset_", declaredType="thread*")
	public threadPointer t_lnext() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_lnextOffset_));
	}

	// thread* t_lnext
	public PointerPointer t_lnextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_lnextOffset_));
	}

	// ushort t_lockcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_lockcountOffset_", declaredType="ushort")
	public U16 t_lockcount() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_lockcountOffset_));
	}

	// ushort t_lockcount
	public U16Pointer t_lockcountEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_lockcountOffset_));
	}

	// thread* t_lockowner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_lockownerOffset_", declaredType="thread*")
	public threadPointer t_lockowner() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_lockownerOffset_));
	}

	// thread* t_lockowner
	public PointerPointer t_lockownerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_lockownerOffset_));
	}

	// U8 t_lockpri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_lockpriOffset_", declaredType="U8")
	public U8 t_lockpri() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_lockpriOffset_));
	}

	// U8 t_lockpri
	public U8Pointer t_lockpriEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_lockpriOffset_));
	}

	// thread* t_lprior
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_lpriorOffset_", declaredType="thread*")
	public threadPointer t_lprior() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_lpriorOffset_));
	}

	// thread* t_lprior
	public PointerPointer t_lpriorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_lpriorOffset_));
	}

	// u_longlong_t t_maj_pf_data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_maj_pf_dataOffset_", declaredType="u_longlong_t")
	public UDATA t_maj_pf_data() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_maj_pf_dataOffset_));
	}

	// u_longlong_t t_maj_pf_data
	public UDATAPointer t_maj_pf_dataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_maj_pf_dataOffset_));
	}

	// u_longlong_t t_maj_pf_kernel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_maj_pf_kernelOffset_", declaredType="u_longlong_t")
	public UDATA t_maj_pf_kernel() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_maj_pf_kernelOffset_));
	}

	// u_longlong_t t_maj_pf_kernel
	public UDATAPointer t_maj_pf_kernelEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_maj_pf_kernelOffset_));
	}

	// u_longlong_t t_maj_pf_text
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_maj_pf_textOffset_", declaredType="u_longlong_t")
	public UDATA t_maj_pf_text() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_maj_pf_textOffset_));
	}

	// u_longlong_t t_maj_pf_text
	public UDATAPointer t_maj_pf_textEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_maj_pf_textOffset_));
	}

	// ulong t_majflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_majfltOffset_", declaredType="ulong")
	public UDATA t_majflt() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_majfltOffset_));
	}

	// ulong t_majflt
	public UDATAPointer t_majfltEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_majfltOffset_));
	}

	// u_longlong_t t_min_pf_data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_min_pf_dataOffset_", declaredType="u_longlong_t")
	public UDATA t_min_pf_data() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_min_pf_dataOffset_));
	}

	// u_longlong_t t_min_pf_data
	public UDATAPointer t_min_pf_dataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_min_pf_dataOffset_));
	}

	// u_longlong_t t_min_pf_kernel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_min_pf_kernelOffset_", declaredType="u_longlong_t")
	public UDATA t_min_pf_kernel() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_min_pf_kernelOffset_));
	}

	// u_longlong_t t_min_pf_kernel
	public UDATAPointer t_min_pf_kernelEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_min_pf_kernelOffset_));
	}

	// u_longlong_t t_min_pf_text
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_min_pf_textOffset_", declaredType="u_longlong_t")
	public UDATA t_min_pf_text() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_min_pf_textOffset_));
	}

	// u_longlong_t t_min_pf_text
	public UDATAPointer t_min_pf_textEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_min_pf_textOffset_));
	}

	// ulong t_minflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_minfltOffset_", declaredType="ulong")
	public UDATA t_minflt() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_minfltOffset_));
	}

	// ulong t_minflt
	public UDATAPointer t_minfltEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_minfltOffset_));
	}

	// kwpar_mrc* t_mrc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_mrcOffset_", declaredType="kwpar_mrc*")
	public kwpar_mrcPointer t_mrc() throws CorruptDataException {
		return kwpar_mrcPointer.cast(getPointerAtOffset(thread._t_mrcOffset_));
	}

	// kwpar_mrc* t_mrc
	public PointerPointer t_mrcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_mrcOffset_));
	}

	// ulong t_near_dispct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_near_dispctOffset_", declaredType="ulong")
	public UDATA t_near_dispct() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_near_dispctOffset_));
	}

	// ulong t_near_dispct
	public UDATAPointer t_near_dispctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_near_dispctOffset_));
	}

	// run_queue* t_near_rq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_near_rqOffset_", declaredType="run_queue*")
	public run_queuePointer t_near_rq() throws CorruptDataException {
		return run_queuePointer.cast(getPointerAtOffset(thread._t_near_rqOffset_));
	}

	// run_queue* t_near_rq
	public PointerPointer t_near_rqEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_near_rqOffset_));
	}

	// thread* t_next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_nextOffset_", declaredType="thread*")
	public threadPointer t_next() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_nextOffset_));
	}

	// thread* t_next
	public PointerPointer t_nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_nextOffset_));
	}

	// U8 t_nice
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_niceOffset_", declaredType="U8")
	public U8 t_nice() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_niceOffset_));
	}

	// U8 t_nice
	public U8Pointer t_niceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_niceOffset_));
	}

	// U8 t_norun_secs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_norun_secsOffset_", declaredType="U8")
	public U8 t_norun_secs() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_norun_secsOffset_));
	}

	// U8 t_norun_secs
	public U8Pointer t_norun_secsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_norun_secsOffset_));
	}

	// U8[] t_pad1
	public U8Pointer t_pad1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_pad1Offset_));
	}

	// ulong t_pevent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_peventOffset_", declaredType="ulong")
	public UDATA t_pevent() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_peventOffset_));
	}

	// ulong t_pevent
	public UDATAPointer t_peventEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_peventOffset_));
	}

	// u_longlong_t t_pf_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_pf_startOffset_", declaredType="u_longlong_t")
	public UDATA t_pf_start() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_pf_startOffset_));
	}

	// u_longlong_t t_pf_start
	public UDATAPointer t_pf_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_pf_startOffset_));
	}

	// I32 t_polevel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_polevelOffset_", declaredType="I32")
	public IDATA t_polevel() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_polevelOffset_));
	}

	// I32 t_polevel
	public IDATAPointer t_polevelEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_polevelOffset_));
	}

	// U8 t_policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_policyOffset_", declaredType="U8")
	public U8 t_policy() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_policyOffset_));
	}

	// U8 t_policy
	public U8Pointer t_policyEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_policyOffset_));
	}

	// cpu_t t_prefunnel_cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_prefunnel_cpuOffset_", declaredType="cpu_t")
	public I16 t_prefunnel_cpu() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_prefunnel_cpuOffset_));
	}

	// cpu_t t_prefunnel_cpu
	public I16Pointer t_prefunnel_cpuEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_prefunnel_cpuOffset_));
	}

	// U8 t_pri_band
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_pri_bandOffset_", declaredType="U8")
	public U8 t_pri_band() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_pri_bandOffset_));
	}

	// U8 t_pri_band
	public U8Pointer t_pri_bandEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_pri_bandOffset_));
	}

	// thread* t_prior
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_priorOffset_", declaredType="thread*")
	public threadPointer t_prior() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_priorOffset_));
	}

	// thread* t_prior
	public PointerPointer t_priorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_priorOffset_));
	}

	// proc* t_procp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_procpOffset_", declaredType="proc*")
	public procPointer t_procp() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(thread._t_procpOffset_));
	}

	// proc* t_procp
	public PointerPointer t_procpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_procpOffset_));
	}

	// pvthread* t_pvthreadp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_pvthreadpOffset_", declaredType="pvthread*")
	public pvthreadPointer t_pvthreadp() throws CorruptDataException {
		return pvthreadPointer.cast(getPointerAtOffset(thread._t_pvthreadpOffset_));
	}

	// pvthread* t_pvthreadp
	public PointerPointer t_pvthreadpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_pvthreadpOffset_));
	}

	// I16 t_reaffin_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_reaffin_countOffset_", declaredType="I16")
	public I16 t_reaffin_count() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_reaffin_countOffset_));
	}

	// I16 t_reaffin_count
	public I16Pointer t_reaffin_countEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_reaffin_countOffset_));
	}

	// U64 t_rehome_tb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_rehome_tbOffset_", declaredType="U64")
	public UDATA t_rehome_tb() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_rehome_tbOffset_));
	}

	// U64 t_rehome_tb
	public UDATAPointer t_rehome_tbEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_rehome_tbOffset_));
	}

	// I32 t_result
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_resultOffset_", declaredType="I32")
	public IDATA t_result() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_resultOffset_));
	}

	// I32 t_result
	public IDATAPointer t_resultEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_resultOffset_));
	}

	// void* t_rs_attinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_rs_attinfoOffset_", declaredType="void*")
	public VoidPointer t_rs_attinfo() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(thread._t_rs_attinfoOffset_));
	}

	// void* t_rs_attinfo
	public PointerPointer t_rs_attinfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_rs_attinfoOffset_));
	}

	// uint t_rt_ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_rt_ticksOffset_", declaredType="uint")
	public UDATA t_rt_ticks() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_rt_ticksOffset_));
	}

	// uint t_rt_ticks
	public UDATAPointer t_rt_ticksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_rt_ticksOffset_));
	}

	// longlong_t t_ru_idrss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ru_idrssOffset_", declaredType="longlong_t")
	public IDATA t_ru_idrss() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_ru_idrssOffset_));
	}

	// longlong_t t_ru_idrss
	public IDATAPointer t_ru_idrssEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_ru_idrssOffset_));
	}

	// longlong_t t_ru_ixrss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ru_ixrssOffset_", declaredType="longlong_t")
	public IDATA t_ru_ixrss() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_ru_ixrssOffset_));
	}

	// longlong_t t_ru_ixrss
	public IDATAPointer t_ru_ixrssEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_ru_ixrssOffset_));
	}

	// longlong_t t_ru_maxrss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ru_maxrssOffset_", declaredType="longlong_t")
	public IDATA t_ru_maxrss() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_ru_maxrssOffset_));
	}

	// longlong_t t_ru_maxrss
	public IDATAPointer t_ru_maxrssEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_ru_maxrssOffset_));
	}

	// run_queue* t_run_queue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_run_queueOffset_", declaredType="run_queue*")
	public run_queuePointer t_run_queue() throws CorruptDataException {
		return run_queuePointer.cast(getPointerAtOffset(thread._t_run_queueOffset_));
	}

	// run_queue* t_run_queue
	public PointerPointer t_run_queueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_run_queueOffset_));
	}

	// u_longlong_t t_runnable_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_runnable_startOffset_", declaredType="u_longlong_t")
	public UDATA t_runnable_start() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_runnable_startOffset_));
	}

	// u_longlong_t t_runnable_start
	public UDATAPointer t_runnable_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_runnable_startOffset_));
	}

	// u_longlong_t t_runnable_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_runnable_totalOffset_", declaredType="u_longlong_t")
	public UDATA t_runnable_total() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_runnable_totalOffset_));
	}

	// u_longlong_t t_runnable_total
	public UDATAPointer t_runnable_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_runnable_totalOffset_));
	}

	// u_longlong_t t_running_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_running_startOffset_", declaredType="u_longlong_t")
	public UDATA t_running_start() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_running_startOffset_));
	}

	// u_longlong_t t_running_start
	public UDATAPointer t_running_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_running_startOffset_));
	}

	// u_longlong_t t_running_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_running_totalOffset_", declaredType="u_longlong_t")
	public UDATA t_running_total() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_running_totalOffset_));
	}

	// u_longlong_t t_running_total
	public UDATAPointer t_running_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_running_totalOffset_));
	}

	// U8 t_sav_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_sav_priOffset_", declaredType="U8")
	public U8 t_sav_pri() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_sav_priOffset_));
	}

	// U8 t_sav_pri
	public U8Pointer t_sav_priEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_sav_priOffset_));
	}

	// U8 t_savsigno
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_savsignoOffset_", declaredType="U8")
	public U8 t_savsigno() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_savsignoOffset_));
	}

	// U8 t_savsigno
	public U8Pointer t_savsignoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_savsignoOffset_));
	}

	// U8 t_sc_active
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_sc_activeOffset_", declaredType="U8")
	public U8 t_sc_active() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_sc_activeOffset_));
	}

	// U8 t_sc_active
	public U8Pointer t_sc_activeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_sc_activeOffset_));
	}

	// __sigcontext* t_scp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_scpOffset_", declaredType="__sigcontext*")
	public __sigcontextPointer t_scp() throws CorruptDataException {
		return __sigcontextPointer.cast(getPointerAtOffset(thread._t_scpOffset_));
	}

	// __sigcontext* t_scp
	public PointerPointer t_scpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_scpOffset_));
	}

	// cpu_t t_scpuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_scpuidOffset_", declaredType="cpu_t")
	public I16 t_scpuid() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_scpuidOffset_));
	}

	// cpu_t t_scpuid
	public I16Pointer t_scpuidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_scpuidOffset_));
	}

	// U64 t_scputime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_scputimeOffset_", declaredType="U64")
	public UDATA t_scputime() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_scputimeOffset_));
	}

	// U64 t_scputime
	public UDATAPointer t_scputimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_scputimeOffset_));
	}

	// sigset_t t_sig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_sigOffset_", declaredType="sigset_t")
	public sigset_tPointer t_sig() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(thread._t_sigOffset_));
	}

	// sigset_t t_sig
	public PointerPointer t_sigEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_sigOffset_));
	}

	// sigset_t t_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_sigmaskOffset_", declaredType="sigset_t")
	public sigset_tPointer t_sigmask() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(thread._t_sigmaskOffset_));
	}

	// sigset_t t_sigmask
	public PointerPointer t_sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_sigmaskOffset_));
	}

	// U8 t_sigproc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_sigprocOffset_", declaredType="U8")
	public U8 t_sigproc() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_sigprocOffset_));
	}

	// U8 t_sigproc
	public U8Pointer t_sigprocEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_sigprocOffset_));
	}

	// thread* t_slist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_slistOffset_", declaredType="thread*")
	public threadPointer t_slist() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_slistOffset_));
	}

	// thread* t_slist
	public PointerPointer t_slistEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_slistOffset_));
	}

	// thread* t_slist_prev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_slist_prevOffset_", declaredType="thread*")
	public threadPointer t_slist_prev() throws CorruptDataException {
		return threadPointer.cast(getPointerAtOffset(thread._t_slist_prevOffset_));
	}

	// thread* t_slist_prev
	public PointerPointer t_slist_prevEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_slist_prevOffset_));
	}

	// smt_thread_priority_t t_smt_priority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_smt_priorityOffset_", declaredType="smt_thread_priority_t")
	public I16 t_smt_priority() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_smt_priorityOffset_));
	}

	// smt_thread_priority_t t_smt_priority
	public I16Pointer t_smt_priorityEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_smt_priorityOffset_));
	}

	// u_longlong_t t_spurr_time_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_spurr_time_startOffset_", declaredType="u_longlong_t")
	public UDATA t_spurr_time_start() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_spurr_time_startOffset_));
	}

	// u_longlong_t t_spurr_time_start
	public UDATAPointer t_spurr_time_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_spurr_time_startOffset_));
	}

	// U8* t_stackp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_stackpOffset_", declaredType="U8*")
	public U8Pointer t_stackp() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(thread._t_stackpOffset_));
	}

	// U8* t_stackp
	public PointerPointer t_stackpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_stackpOffset_));
	}

	// timestruc_t t_starttime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_starttimeOffset_", declaredType="timestruc_t")
	public timestruc_tPointer t_starttime() throws CorruptDataException {
		return timestruc_tPointer.cast(nonNullFieldEA(thread._t_starttimeOffset_));
	}

	// timestruc_t t_starttime
	public PointerPointer t_starttimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_starttimeOffset_));
	}

	// I16 t_suspend
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_suspendOffset_", declaredType="I16")
	public I16 t_suspend() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_suspendOffset_));
	}

	// I16 t_suspend
	public I16Pointer t_suspendEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_suspendOffset_));
	}

	// U8* t_swchan
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_swchanOffset_", declaredType="U8*")
	public U8Pointer t_swchan() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(thread._t_swchanOffset_));
	}

	// U8* t_swchan
	public PointerPointer t_swchanEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_swchanOffset_));
	}

	// sigset_t t_synch_sig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_synch_sigOffset_", declaredType="sigset_t")
	public sigset_tPointer t_synch_sig() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(thread._t_synch_sigOffset_));
	}

	// sigset_t t_synch_sig
	public PointerPointer t_synch_sigEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_synch_sigOffset_));
	}

	// __ptr64 t_threadcontrolp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_threadcontrolpOffset_", declaredType="__ptr64")
	public VoidPointer t_threadcontrolp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(thread._t_threadcontrolpOffset_));
	}

	// __ptr64 t_threadcontrolp
	public PointerPointer t_threadcontrolpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_threadcontrolpOffset_));
	}

	// ushort t_ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ticksOffset_", declaredType="ushort")
	public U16 t_ticks() throws CorruptDataException {
		return new U16(getShortAtOffset(thread._t_ticksOffset_));
	}

	// ushort t_ticks
	public U16Pointer t_ticksEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(thread._t_ticksOffset_));
	}

	// tid_t t_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_tidOffset_", declaredType="tid_t")
	public IDATA t_tid() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_tidOffset_));
	}

	// tid_t t_tid
	public IDATAPointer t_tidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_tidOffset_));
	}

	// uchar t_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_timeOffset_", declaredType="uchar")
	public U8 t_time() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_timeOffset_));
	}

	// uchar t_time
	public U8Pointer t_timeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_timeOffset_));
	}

	// u_longlong_t t_time_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_time_startOffset_", declaredType="u_longlong_t")
	public UDATA t_time_start() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_time_startOffset_));
	}

	// u_longlong_t t_time_start
	public UDATAPointer t_time_startEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_time_startOffset_));
	}

	// uint t_trcgenct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_trcgenctOffset_", declaredType="uint")
	public UDATA t_trcgenct() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_trcgenctOffset_));
	}

	// uint t_trcgenct
	public UDATAPointer t_trcgenctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_trcgenctOffset_));
	}

	// thread$t_uaddress t_uaddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_uaddressOffset_", declaredType="thread$t_uaddress")
	public thread$t_uaddressPointer t_uaddress() throws CorruptDataException {
		return thread$t_uaddressPointer.cast(nonNullFieldEA(thread._t_uaddressOffset_));
	}

	// thread$t_uaddress t_uaddress
	public PointerPointer t_uaddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_uaddressOffset_));
	}

	// I64 t_uchan
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_uchanOffset_", declaredType="I64")
	public IDATA t_uchan() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_uchanOffset_));
	}

	// I64 t_uchan
	public IDATAPointer t_uchanEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_uchanOffset_));
	}

	// I64 t_ulock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ulockOffset_", declaredType="I64")
	public IDATA t_ulock() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_ulockOffset_));
	}

	// I64 t_ulock
	public IDATAPointer t_ulockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_ulockOffset_));
	}

	// void* t_ulock_listp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_ulock_listpOffset_", declaredType="void*")
	public VoidPointer t_ulock_listp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(thread._t_ulock_listpOffset_));
	}

	// void* t_ulock_listp
	public PointerPointer t_ulock_listpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_ulock_listpOffset_));
	}

	// I64 t_userdata
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_userdataOffset_", declaredType="I64")
	public IDATA t_userdata() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_userdataOffset_));
	}

	// I64 t_userdata
	public IDATAPointer t_userdataEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_userdataOffset_));
	}

	// vmid_t t_usid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_usidOffset_", declaredType="vmid_t")
	public IDATA t_usid() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_usidOffset_));
	}

	// vmid_t t_usid
	public IDATAPointer t_usidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_usidOffset_));
	}

	// tid_t t_vtid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_vtidOffset_", declaredType="tid_t")
	public IDATA t_vtid() throws CorruptDataException {
		return new I64(getLongAtOffset(thread._t_vtidOffset_));
	}

	// tid_t t_vtid
	public IDATAPointer t_vtidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_vtidOffset_));
	}

	// u_longlong_t t_waitTm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_waitTmOffset_", declaredType="u_longlong_t")
	public UDATA t_waitTm() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_waitTmOffset_));
	}

	// u_longlong_t t_waitTm
	public UDATAPointer t_waitTmEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_waitTmOffset_));
	}

	// U8 t_wakepri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wakepriOffset_", declaredType="U8")
	public U8 t_wakepri() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_wakepriOffset_));
	}

	// U8 t_wakepri
	public U8Pointer t_wakepriEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_wakepriOffset_));
	}

	// U8* t_wchan1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wchan1Offset_", declaredType="U8*")
	public U8Pointer t_wchan1() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(thread._t_wchan1Offset_));
	}

	// U8* t_wchan1
	public PointerPointer t_wchan1EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_wchan1Offset_));
	}

	// uint t_wchan1offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wchan1offsetOffset_", declaredType="uint")
	public UDATA t_wchan1offset() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_wchan1offsetOffset_));
	}

	// uint t_wchan1offset
	public UDATAPointer t_wchan1offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_wchan1offsetOffset_));
	}

	// vmhandle_t t_wchan1sid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wchan1sidOffset_", declaredType="vmhandle_t")
	public UDATA t_wchan1sid() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_wchan1sidOffset_));
	}

	// vmhandle_t t_wchan1sid
	public UDATAPointer t_wchan1sidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_wchan1sidOffset_));
	}

	// U8* t_wchan2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wchan2Offset_", declaredType="U8*")
	public U8Pointer t_wchan2() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(thread._t_wchan2Offset_));
	}

	// U8* t_wchan2
	public PointerPointer t_wchan2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread._t_wchan2Offset_));
	}

	// ulong t_wevent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_weventOffset_", declaredType="ulong")
	public UDATA t_wevent() throws CorruptDataException {
		return new U64(getLongAtOffset(thread._t_weventOffset_));
	}

	// ulong t_wevent
	public UDATAPointer t_weventEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_weventOffset_));
	}

	// I16 t_whatstop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_whatstopOffset_", declaredType="I16")
	public I16 t_whatstop() throws CorruptDataException {
		return new I16(getShortAtOffset(thread._t_whatstopOffset_));
	}

	// I16 t_whatstop
	public I16Pointer t_whatstopEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thread._t_whatstopOffset_));
	}

	// U8 t_whystop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_whystopOffset_", declaredType="U8")
	public U8 t_whystop() throws CorruptDataException {
		return new U8(getByteAtOffset(thread._t_whystopOffset_));
	}

	// U8 t_whystop
	public U8Pointer t_whystopEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thread._t_whystopOffset_));
	}

	// pid_t t_wlm_charge
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wlm_chargeOffset_", declaredType="pid_t")
	public IDATA t_wlm_charge() throws CorruptDataException {
		return new I32(getIntAtOffset(thread._t_wlm_chargeOffset_));
	}

	// pid_t t_wlm_charge
	public IDATAPointer t_wlm_chargeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thread._t_wlm_chargeOffset_));
	}

	// uint t_wlmevtcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_t_wlmevtcntOffset_", declaredType="uint")
	public UDATA t_wlmevtcnt() throws CorruptDataException {
		return new U32(getIntAtOffset(thread._t_wlmevtcntOffset_));
	}

	// uint t_wlmevtcnt
	public UDATAPointer t_wlmevtcntEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread._t_wlmevtcntOffset_));
	}

}
