/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tstatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tstatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tstate.class)
public class tstatePointer extends StructurePointer {

	// NULL
	public static final tstatePointer NULL = new tstatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tstatePointer(long address) {
		super(address);
	}

	public static tstatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tstatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tstatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tstatePointer(address);
	}

	public tstatePointer add(long count) {
		return tstatePointer.cast(address + (tstate.SIZEOF * count));
	}

	public tstatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public tstatePointer addOffset(long offset) {
		return tstatePointer.cast(address + offset);
	}

	public tstatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tstatePointer sub(long count) {
		return tstatePointer.cast(address - (tstate.SIZEOF * count));
	}

	public tstatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tstatePointer subOffset(long offset) {
		return tstatePointer.cast(address - offset);
	}

	public tstatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tstatePointer untag(long mask) {
		return tstatePointer.cast(address & ~mask);
	}

	public tstatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tstate.SIZEOF;
	}

	// Implementation methods

	// void* credp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_credpOffset_", declaredType="void*")
	public VoidPointer credp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tstate._credpOffset_));
	}

	// void* credp
	public PointerPointer credpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._credpOffset_));
	}

	// void** errnop_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errnop_addrOffset_", declaredType="void**")
	public PointerPointer errnop_addr() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tstate._errnop_addrOffset_));
	}

	// void** errnop_addr
	public PointerPointer errnop_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._errnop_addrOffset_));
	}

	// I32 flagmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagmaskOffset_", declaredType="I32")
	public IDATA flagmask() throws CorruptDataException {
		return new I32(getIntAtOffset(tstate._flagmaskOffset_));
	}

	// I32 flagmask
	public IDATAPointer flagmaskEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tstate._flagmaskOffset_));
	}

	// I32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="I32")
	public IDATA flags() throws CorruptDataException {
		return new I32(getIntAtOffset(tstate._flagsOffset_));
	}

	// I32 flags
	public IDATAPointer flagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tstate._flagsOffset_));
	}

	// uint fpinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpinfoOffset_", declaredType="uint")
	public UDATA fpinfo() throws CorruptDataException {
		return new U32(getIntAtOffset(tstate._fpinfoOffset_));
	}

	// uint fpinfo
	public UDATAPointer fpinfoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tstate._fpinfoOffset_));
	}

	// uint fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrxOffset_", declaredType="uint")
	public UDATA fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(tstate._fpscrxOffset_));
	}

	// uint fpscrx
	public UDATAPointer fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tstate._fpscrxOffset_));
	}

	// __context64 mst
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mstOffset_", declaredType="__context64")
	public __context64Pointer mst() throws CorruptDataException {
		return __context64Pointer.cast(nonNullFieldEA(tstate._mstOffset_));
	}

	// __context64 mst
	public PointerPointer mstEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._mstOffset_));
	}

	// I32 policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_policyOffset_", declaredType="I32")
	public IDATA policy() throws CorruptDataException {
		return new I32(getIntAtOffset(tstate._policyOffset_));
	}

	// I32 policy
	public IDATAPointer policyEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tstate._policyOffset_));
	}

	// void* prbase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prbaseOffset_", declaredType="void*")
	public VoidPointer prbase() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tstate._prbaseOffset_));
	}

	// void* prbase
	public PointerPointer prbaseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._prbaseOffset_));
	}

	// I32 priority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_priorityOffset_", declaredType="I32")
	public IDATA priority() throws CorruptDataException {
		return new I32(getIntAtOffset(tstate._priorityOffset_));
	}

	// I32 priority
	public IDATAPointer priorityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tstate._priorityOffset_));
	}

	// sigset_t psig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psigOffset_", declaredType="sigset_t")
	public sigset_tPointer psig() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(tstate._psigOffset_));
	}

	// sigset_t psig
	public PointerPointer psigEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._psigOffset_));
	}

	// uint ptid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ptidOffset_", declaredType="uint")
	public UDATA ptid() throws CorruptDataException {
		return new U32(getIntAtOffset(tstate._ptidOffset_));
	}

	// uint ptid
	public UDATAPointer ptidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tstate._ptidOffset_));
	}

	// rusage rusg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rusgOffset_", declaredType="rusage")
	public rusagePointer rusg() throws CorruptDataException {
		return rusagePointer.cast(nonNullFieldEA(tstate._rusgOffset_));
	}

	// rusage rusg
	public PointerPointer rusgEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._rusgOffset_));
	}

	// stack_t sigaltstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigaltstackOffset_", declaredType="stack_t")
	public stack_tPointer sigaltstack() throws CorruptDataException {
		return stack_tPointer.cast(nonNullFieldEA(tstate._sigaltstackOffset_));
	}

	// stack_t sigaltstack
	public PointerPointer sigaltstackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._sigaltstackOffset_));
	}

	// sigset_t sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigmaskOffset_", declaredType="sigset_t")
	public sigset_tPointer sigmask() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(tstate._sigmaskOffset_));
	}

	// sigset_t sigmask
	public PointerPointer sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._sigmaskOffset_));
	}

	// uint tct_clock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tct_clockOffset_", declaredType="uint")
	public UDATA tct_clock() throws CorruptDataException {
		return new U32(getIntAtOffset(tstate._tct_clockOffset_));
	}

	// uint tct_clock
	public UDATAPointer tct_clockEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tstate._tct_clockOffset_));
	}

	// __ptr64 thread_control_p
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thread_control_pOffset_", declaredType="__ptr64")
	public VoidPointer thread_control_p() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tstate._thread_control_pOffset_));
	}

	// __ptr64 thread_control_p
	public PointerPointer thread_control_pEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tstate._thread_control_pOffset_));
	}

	// u_longlong_t ukeyset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ukeysetOffset_", declaredType="u_longlong_t")
	public UDATA ukeyset() throws CorruptDataException {
		return new U64(getLongAtOffset(tstate._ukeysetOffset_));
	}

	// u_longlong_t ukeyset
	public UDATAPointer ukeysetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tstate._ukeysetOffset_));
	}

	// I64 userdata
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_userdataOffset_", declaredType="I64")
	public IDATA userdata() throws CorruptDataException {
		return new I64(getLongAtOffset(tstate._userdataOffset_));
	}

	// I64 userdata
	public IDATAPointer userdataEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tstate._userdataOffset_));
	}

}
