/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ucred_43Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ucred_43Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ucred_43.class)
public class ucred_43Pointer extends StructurePointer {

	// NULL
	public static final ucred_43Pointer NULL = new ucred_43Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ucred_43Pointer(long address) {
		super(address);
	}

	public static ucred_43Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ucred_43Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ucred_43Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ucred_43Pointer(address);
	}

	public ucred_43Pointer add(long count) {
		return ucred_43Pointer.cast(address + (ucred_43.SIZEOF * count));
	}

	public ucred_43Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public ucred_43Pointer addOffset(long offset) {
		return ucred_43Pointer.cast(address + offset);
	}

	public ucred_43Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ucred_43Pointer sub(long count) {
		return ucred_43Pointer.cast(address - (ucred_43.SIZEOF * count));
	}

	public ucred_43Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ucred_43Pointer subOffset(long offset) {
		return ucred_43Pointer.cast(address - offset);
	}

	public ucred_43Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ucred_43Pointer untag(long mask) {
		return ucred_43Pointer.cast(address & ~mask);
	}

	public ucred_43Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ucred_43.SIZEOF;
	}

	// Implementation methods

	// uid_t ocr_acctid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_acctidOffset_", declaredType="uid_t")
	public UDATA ocr_acctid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_acctidOffset_));
	}

	// uid_t ocr_acctid
	public UDATAPointer ocr_acctidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_acctidOffset_));
	}

	// priv_t ocr_bpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_bprivOffset_", declaredType="priv_t")
	public privPointer ocr_bpriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_43._ocr_bprivOffset_));
	}

	// priv_t ocr_bpriv
	public PointerPointer ocr_bprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_43._ocr_bprivOffset_));
	}

	// priv_t ocr_epriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_eprivOffset_", declaredType="priv_t")
	public privPointer ocr_epriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_43._ocr_eprivOffset_));
	}

	// priv_t ocr_epriv
	public PointerPointer ocr_eprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_43._ocr_eprivOffset_));
	}

	// gid_t ocr_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_gidOffset_", declaredType="gid_t")
	public UDATA ocr_gid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_gidOffset_));
	}

	// gid_t ocr_gid
	public UDATAPointer ocr_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_gidOffset_));
	}

	// gid_t[] ocr_groups
	public UDATAPointer ocr_groupsEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ucred_43._ocr_groupsOffset_));
	}

	// priv_t ocr_ipriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_iprivOffset_", declaredType="priv_t")
	public privPointer ocr_ipriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_43._ocr_iprivOffset_));
	}

	// priv_t ocr_ipriv
	public PointerPointer ocr_iprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_43._ocr_iprivOffset_));
	}

	// uid_t ocr_luid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_luidOffset_", declaredType="uid_t")
	public UDATA ocr_luid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_luidOffset_));
	}

	// uid_t ocr_luid
	public UDATAPointer ocr_luidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_luidOffset_));
	}

	// priv_t ocr_mpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_mprivOffset_", declaredType="priv_t")
	public privPointer ocr_mpriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred_43._ocr_mprivOffset_));
	}

	// priv_t ocr_mpriv
	public PointerPointer ocr_mprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred_43._ocr_mprivOffset_));
	}

	// I16 ocr_ngrps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_ngrpsOffset_", declaredType="I16")
	public I16 ocr_ngrps() throws CorruptDataException {
		return new I16(getShortAtOffset(ucred_43._ocr_ngrpsOffset_));
	}

	// I16 ocr_ngrps
	public I16Pointer ocr_ngrpsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(ucred_43._ocr_ngrpsOffset_));
	}

	// I32 ocr_pag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_pagOffset_", declaredType="I32")
	public IDATA ocr_pag() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred_43._ocr_pagOffset_));
	}

	// I32 ocr_pag
	public IDATAPointer ocr_pagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_pagOffset_));
	}

	// I32 ocr_ref
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_refOffset_", declaredType="I32")
	public IDATA ocr_ref() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred_43._ocr_refOffset_));
	}

	// I32 ocr_ref
	public IDATAPointer ocr_refEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_refOffset_));
	}

	// gid_t ocr_rgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_rgidOffset_", declaredType="gid_t")
	public UDATA ocr_rgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_rgidOffset_));
	}

	// gid_t ocr_rgid
	public UDATAPointer ocr_rgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_rgidOffset_));
	}

	// uid_t ocr_ruid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_ruidOffset_", declaredType="uid_t")
	public UDATA ocr_ruid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_ruidOffset_));
	}

	// uid_t ocr_ruid
	public UDATAPointer ocr_ruidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_ruidOffset_));
	}

	// gid_t ocr_sgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_sgidOffset_", declaredType="gid_t")
	public UDATA ocr_sgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_sgidOffset_));
	}

	// gid_t ocr_sgid
	public UDATAPointer ocr_sgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_sgidOffset_));
	}

	// uid_t ocr_suid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_suidOffset_", declaredType="uid_t")
	public UDATA ocr_suid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_suidOffset_));
	}

	// uid_t ocr_suid
	public UDATAPointer ocr_suidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_suidOffset_));
	}

	// uid_t ocr_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ocr_uidOffset_", declaredType="uid_t")
	public UDATA ocr_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred_43._ocr_uidOffset_));
	}

	// uid_t ocr_uid
	public UDATAPointer ocr_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred_43._ocr_uidOffset_));
	}

}
