/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: vPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the vPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=v.class)
public class vPointer extends StructurePointer {

	// NULL
	public static final vPointer NULL = new vPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected vPointer(long address) {
		super(address);
	}

	public static vPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static vPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static vPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new vPointer(address);
	}

	public vPointer add(long count) {
		return vPointer.cast(address + (v.SIZEOF * count));
	}

	public vPointer add(Scalar count) {
		return add(count.longValue());
	}

	public vPointer addOffset(long offset) {
		return vPointer.cast(address + offset);
	}

	public vPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public vPointer sub(long count) {
		return vPointer.cast(address - (v.SIZEOF * count));
	}

	public vPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public vPointer subOffset(long offset) {
		return vPointer.cast(address - offset);
	}

	public vPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public vPointer untag(long mask) {
		return vPointer.cast(address & ~mask);
	}

	public vPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return v.SIZEOF;
	}

	// Implementation methods

	// I32 turbo_acct.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_turbo_acct$fillOffset_", declaredType="I32")
	public IDATA turbo_acct$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._turbo_acct$fillOffset_));
	}

	// I32 turbo_acct.fill
	public IDATAPointer turbo_acct$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._turbo_acct$fillOffset_));
	}

	// I32 turbo_acct.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_turbo_acct$valueOffset_", declaredType="I32")
	public IDATA turbo_acct$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._turbo_acct$valueOffset_));
	}

	// I32 turbo_acct.value
	public IDATAPointer turbo_acct$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._turbo_acct$valueOffset_));
	}

	// I64 v_acl_config.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_acl_config$valueOffset_", declaredType="I64")
	public IDATA v_acl_config$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_acl_config$valueOffset_));
	}

	// I64 v_acl_config.value
	public IDATAPointer v_acl_config$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_acl_config$valueOffset_));
	}

	// I32 v_autost.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_autost$fillOffset_", declaredType="I32")
	public IDATA v_autost$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_autost$fillOffset_));
	}

	// I32 v_autost.fill
	public IDATAPointer v_autost$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_autost$fillOffset_));
	}

	// I32 v_autost.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_autost$valueOffset_", declaredType="I32")
	public IDATA v_autost$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_autost$valueOffset_));
	}

	// I32 v_autost.value
	public IDATAPointer v_autost$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_autost$valueOffset_));
	}

	// I64 v_bufhw.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_bufhw$valueOffset_", declaredType="I64")
	public IDATA v_bufhw$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_bufhw$valueOffset_));
	}

	// I64 v_bufhw.value
	public IDATAPointer v_bufhw$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_bufhw$valueOffset_));
	}

	// I32 v_chown_restrict.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_chown_restrict$valueOffset_", declaredType="I32")
	public IDATA v_chown_restrict$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_chown_restrict$valueOffset_));
	}

	// I32 v_chown_restrict.value
	public IDATAPointer v_chown_restrict$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_chown_restrict$valueOffset_));
	}

	// I64 v_clist.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_clist$valueOffset_", declaredType="I64")
	public IDATA v_clist$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_clist$valueOffset_));
	}

	// I64 v_clist.value
	public IDATAPointer v_clist$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_clist$valueOffset_));
	}

	// I32 v_cluster_aware.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_cluster_aware$valueOffset_", declaredType="I32")
	public IDATA v_cluster_aware$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_cluster_aware$valueOffset_));
	}

	// I32 v_cluster_aware.value
	public IDATAPointer v_cluster_aware$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_cluster_aware$valueOffset_));
	}

	// I32 v_coreformat.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_coreformat$fillOffset_", declaredType="I32")
	public IDATA v_coreformat$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_coreformat$fillOffset_));
	}

	// I32 v_coreformat.fill
	public IDATAPointer v_coreformat$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_coreformat$fillOffset_));
	}

	// I32 v_coreformat.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_coreformat$valueOffset_", declaredType="I32")
	public IDATA v_coreformat$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_coreformat$valueOffset_));
	}

	// I32 v_coreformat.value
	public IDATAPointer v_coreformat$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_coreformat$valueOffset_));
	}

	// I32 v_cpuguard.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_cpuguard$fillOffset_", declaredType="I32")
	public IDATA v_cpuguard$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_cpuguard$fillOffset_));
	}

	// I32 v_cpuguard.fill
	public IDATAPointer v_cpuguard$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_cpuguard$fillOffset_));
	}

	// I32 v_cpuguard.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_cpuguard$valueOffset_", declaredType="I32")
	public IDATA v_cpuguard$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_cpuguard$valueOffset_));
	}

	// I32 v_cpuguard.value
	public IDATAPointer v_cpuguard$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_cpuguard$valueOffset_));
	}

	// I64 v_enhanced_rbac.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_enhanced_rbac$valueOffset_", declaredType="I64")
	public IDATA v_enhanced_rbac$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_enhanced_rbac$valueOffset_));
	}

	// I64 v_enhanced_rbac.value
	public IDATAPointer v_enhanced_rbac$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_enhanced_rbac$valueOffset_));
	}

	// I64 v_file.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_file$valueOffset_", declaredType="I64")
	public IDATA v_file$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_file$valueOffset_));
	}

	// I64 v_file.value
	public IDATAPointer v_file$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_file$valueOffset_));
	}

	// I64 v_file_max.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_file_max$valueOffset_", declaredType="I64")
	public IDATA v_file_max$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_file_max$valueOffset_));
	}

	// I64 v_file_max.value
	public IDATAPointer v_file_max$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_file_max$valueOffset_));
	}

	// I32 v_fullcore.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_fullcore$fillOffset_", declaredType="I32")
	public IDATA v_fullcore$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_fullcore$fillOffset_));
	}

	// I32 v_fullcore.fill
	public IDATAPointer v_fullcore$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_fullcore$fillOffset_));
	}

	// I32 v_fullcore.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_fullcore$valueOffset_", declaredType="I32")
	public IDATA v_fullcore$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_fullcore$valueOffset_));
	}

	// I32 v_fullcore.value
	public IDATAPointer v_fullcore$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_fullcore$valueOffset_));
	}

	// I32 v_hardstack.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_hardstack$fillOffset_", declaredType="I32")
	public IDATA v_hardstack$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_hardstack$fillOffset_));
	}

	// I32 v_hardstack.fill
	public IDATAPointer v_hardstack$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_hardstack$fillOffset_));
	}

	// I32 v_hardstack.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_hardstack$valueOffset_", declaredType="I32")
	public IDATA v_hardstack$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_hardstack$valueOffset_));
	}

	// I32 v_hardstack.value
	public IDATAPointer v_hardstack$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_hardstack$valueOffset_));
	}

	// I32 v_initlvl.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_initlvl$fillOffset_", declaredType="I32")
	public IDATA v_initlvl$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_initlvl$fillOffset_));
	}

	// I32 v_initlvl.fill
	public IDATAPointer v_initlvl$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_initlvl$fillOffset_));
	}

	// U8[] v_initlvl.value
	public U8Pointer v_initlvl$valueEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(v._v_initlvl$valueOffset_));
	}

	// I32 v_iostrun.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_iostrun$fillOffset_", declaredType="I32")
	public IDATA v_iostrun$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_iostrun$fillOffset_));
	}

	// I32 v_iostrun.fill
	public IDATAPointer v_iostrun$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_iostrun$fillOffset_));
	}

	// I32 v_iostrun.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_iostrun$valueOffset_", declaredType="I32")
	public IDATA v_iostrun$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_iostrun$valueOffset_));
	}

	// I32 v_iostrun.value
	public IDATAPointer v_iostrun$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_iostrun$valueOffset_));
	}

	// I32 v_leastpriv.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_leastpriv$fillOffset_", declaredType="I32")
	public IDATA v_leastpriv$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_leastpriv$fillOffset_));
	}

	// I32 v_leastpriv.fill
	public IDATAPointer v_leastpriv$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_leastpriv$fillOffset_));
	}

	// I32 v_leastpriv.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_leastpriv$valueOffset_", declaredType="I32")
	public IDATA v_leastpriv$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_leastpriv$valueOffset_));
	}

	// I32 v_leastpriv.value
	public IDATAPointer v_leastpriv$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_leastpriv$valueOffset_));
	}

	// I64 v_lock.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_lock$valueOffset_", declaredType="I64")
	public IDATA v_lock$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_lock$valueOffset_));
	}

	// I64 v_lock.value
	public IDATAPointer v_lock$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_lock$valueOffset_));
	}

	// I64 v_lock_max.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_lock_max$valueOffset_", declaredType="I64")
	public IDATA v_lock_max$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_lock_max$valueOffset_));
	}

	// I64 v_lock_max.value
	public IDATAPointer v_lock_max$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_lock_max$valueOffset_));
	}

	// I32 v_max_logname.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_max_logname$fillOffset_", declaredType="I32")
	public IDATA v_max_logname$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_max_logname$fillOffset_));
	}

	// I32 v_max_logname.fill
	public IDATAPointer v_max_logname$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_max_logname$fillOffset_));
	}

	// I32 v_max_logname.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_max_logname$valueOffset_", declaredType="I32")
	public IDATA v_max_logname$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_max_logname$valueOffset_));
	}

	// I32 v_max_logname.value
	public IDATAPointer v_max_logname$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_max_logname$valueOffset_));
	}

	// I64 v_maxpout.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_maxpout$valueOffset_", declaredType="I64")
	public IDATA v_maxpout$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_maxpout$valueOffset_));
	}

	// I64 v_maxpout.value
	public IDATAPointer v_maxpout$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_maxpout$valueOffset_));
	}

	// I64 v_maxup.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_maxup$valueOffset_", declaredType="I64")
	public IDATA v_maxup$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_maxup$valueOffset_));
	}

	// I64 v_maxup.value
	public IDATAPointer v_maxup$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_maxup$valueOffset_));
	}

	// I64 v_mbufhw.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_mbufhw$valueOffset_", declaredType="I64")
	public IDATA v_mbufhw$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_mbufhw$valueOffset_));
	}

	// I64 v_mbufhw.value
	public IDATAPointer v_mbufhw$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_mbufhw$valueOffset_));
	}

	// I32 v_memscrub.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_memscrub$fillOffset_", declaredType="I32")
	public IDATA v_memscrub$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_memscrub$fillOffset_));
	}

	// I32 v_memscrub.fill
	public IDATAPointer v_memscrub$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_memscrub$fillOffset_));
	}

	// I32 v_memscrub.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_memscrub$valueOffset_", declaredType="I32")
	public IDATA v_memscrub$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_memscrub$valueOffset_));
	}

	// I32 v_memscrub.value
	public IDATAPointer v_memscrub$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_memscrub$valueOffset_));
	}

	// I64 v_minpout.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_minpout$valueOffset_", declaredType="I64")
	public IDATA v_minpout$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_minpout$valueOffset_));
	}

	// I64 v_minpout.value
	public IDATAPointer v_minpout$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_minpout$valueOffset_));
	}

	// I32 v_ncargs.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncargs$fillOffset_", declaredType="I32")
	public IDATA v_ncargs$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ncargs$fillOffset_));
	}

	// I32 v_ncargs.fill
	public IDATAPointer v_ncargs$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ncargs$fillOffset_));
	}

	// I32 v_ncargs.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncargs$valueOffset_", declaredType="I32")
	public IDATA v_ncargs$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ncargs$valueOffset_));
	}

	// I32 v_ncargs.value
	public IDATAPointer v_ncargs$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ncargs$valueOffset_));
	}

	// I32 v_ncpus.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncpus$fillOffset_", declaredType="I32")
	public IDATA v_ncpus$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ncpus$fillOffset_));
	}

	// I32 v_ncpus.fill
	public IDATAPointer v_ncpus$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ncpus$fillOffset_));
	}

	// I32 v_ncpus.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncpus$valueOffset_", declaredType="I32")
	public IDATA v_ncpus$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ncpus$valueOffset_));
	}

	// I32 v_ncpus.value
	public IDATAPointer v_ncpus$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ncpus$valueOffset_));
	}

	// I32 v_ncpus_cfg.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncpus_cfg$fillOffset_", declaredType="I32")
	public IDATA v_ncpus_cfg$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ncpus_cfg$fillOffset_));
	}

	// I32 v_ncpus_cfg.fill
	public IDATAPointer v_ncpus_cfg$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ncpus_cfg$fillOffset_));
	}

	// I32 v_ncpus_cfg.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncpus_cfg$valueOffset_", declaredType="I32")
	public IDATA v_ncpus_cfg$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ncpus_cfg$valueOffset_));
	}

	// I32 v_ncpus_cfg.value
	public IDATAPointer v_ncpus_cfg$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ncpus_cfg$valueOffset_));
	}

	// I32 v_ngroups_allowed.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ngroups_allowed$fillOffset_", declaredType="I32")
	public IDATA v_ngroups_allowed$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ngroups_allowed$fillOffset_));
	}

	// I32 v_ngroups_allowed.fill
	public IDATAPointer v_ngroups_allowed$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ngroups_allowed$fillOffset_));
	}

	// I32 v_ngroups_allowed.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ngroups_allowed$valueOffset_", declaredType="I32")
	public IDATA v_ngroups_allowed$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_ngroups_allowed$valueOffset_));
	}

	// I32 v_ngroups_allowed.value
	public IDATAPointer v_ngroups_allowed$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_ngroups_allowed$valueOffset_));
	}

	// I32 v_num_xmfrecs.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_num_xmfrecs$fillOffset_", declaredType="I32")
	public IDATA v_num_xmfrecs$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_num_xmfrecs$fillOffset_));
	}

	// I32 v_num_xmfrecs.fill
	public IDATAPointer v_num_xmfrecs$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_num_xmfrecs$fillOffset_));
	}

	// I32 v_num_xmfrecs.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_num_xmfrecs$valueOffset_", declaredType="I32")
	public IDATA v_num_xmfrecs$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_num_xmfrecs$valueOffset_));
	}

	// I32 v_num_xmfrecs.value
	public IDATAPointer v_num_xmfrecs$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_num_xmfrecs$valueOffset_));
	}

	// I32 v_pmu_access.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_pmu_access$fillOffset_", declaredType="I32")
	public IDATA v_pmu_access$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_pmu_access$fillOffset_));
	}

	// I32 v_pmu_access.fill
	public IDATAPointer v_pmu_access$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_pmu_access$fillOffset_));
	}

	// I32 v_pmu_access.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_pmu_access$valueOffset_", declaredType="I32")
	public IDATA v_pmu_access$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_pmu_access$valueOffset_));
	}

	// I32 v_pmu_access.value
	public IDATAPointer v_pmu_access$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_pmu_access$valueOffset_));
	}

	// I32 v_pre520tune.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_pre520tune$fillOffset_", declaredType="I32")
	public IDATA v_pre520tune$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_pre520tune$fillOffset_));
	}

	// I32 v_pre520tune.fill
	public IDATAPointer v_pre520tune$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_pre520tune$fillOffset_));
	}

	// I32 v_pre520tune.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_pre520tune$valueOffset_", declaredType="I32")
	public IDATA v_pre520tune$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_pre520tune$valueOffset_));
	}

	// I32 v_pre520tune.value
	public IDATAPointer v_pre520tune$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_pre520tune$valueOffset_));
	}

	// I64 v_proc.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_proc$valueOffset_", declaredType="I64")
	public IDATA v_proc$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_proc$valueOffset_));
	}

	// I64 v_proc.value
	public IDATAPointer v_proc$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_proc$valueOffset_));
	}

	// I64 v_sed_config.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_sed_config$valueOffset_", declaredType="I64")
	public IDATA v_sed_config$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_sed_config$valueOffset_));
	}

	// I64 v_sed_config.value
	public IDATAPointer v_sed_config$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_sed_config$valueOffset_));
	}

	// I64 v_thread.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_thread$valueOffset_", declaredType="I64")
	public IDATA v_thread$value() throws CorruptDataException {
		return new I64(getLongAtOffset(v._v_thread$valueOffset_));
	}

	// I64 v_thread.value
	public IDATAPointer v_thread$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_thread$valueOffset_));
	}

	// I32 v_xmdbg_segs.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_xmdbg_segs$fillOffset_", declaredType="I32")
	public IDATA v_xmdbg_segs$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_xmdbg_segs$fillOffset_));
	}

	// I32 v_xmdbg_segs.fill
	public IDATAPointer v_xmdbg_segs$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_xmdbg_segs$fillOffset_));
	}

	// I32 v_xmdbg_segs.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_xmdbg_segs$valueOffset_", declaredType="I32")
	public IDATA v_xmdbg_segs$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_xmdbg_segs$valueOffset_));
	}

	// I32 v_xmdbg_segs.value
	public IDATAPointer v_xmdbg_segs$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_xmdbg_segs$valueOffset_));
	}

	// I32 v_xmgc.fill
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_xmgc$fillOffset_", declaredType="I32")
	public IDATA v_xmgc$fill() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_xmgc$fillOffset_));
	}

	// I32 v_xmgc.fill
	public IDATAPointer v_xmgc$fillEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_xmgc$fillOffset_));
	}

	// I32 v_xmgc.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_xmgc$valueOffset_", declaredType="I32")
	public IDATA v_xmgc$value() throws CorruptDataException {
		return new I32(getIntAtOffset(v._v_xmgc$valueOffset_));
	}

	// I32 v_xmgc.value
	public IDATAPointer v_xmgc$valueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(v._v_xmgc$valueOffset_));
	}

	// __cptr64 vb_proc.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vb_proc$valueOffset_", declaredType="__cptr64")
	public U8Pointer vb_proc$value() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(v._vb_proc$valueOffset_));
	}

	// __cptr64 vb_proc.value
	public PointerPointer vb_proc$valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(v._vb_proc$valueOffset_));
	}

	// __cptr64 vb_thread.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vb_thread$valueOffset_", declaredType="__cptr64")
	public U8Pointer vb_thread$value() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(v._vb_thread$valueOffset_));
	}

	// __cptr64 vb_thread.value
	public PointerPointer vb_thread$valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(v._vb_thread$valueOffset_));
	}

	// __cptr64 ve_file.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_file$valueOffset_", declaredType="__cptr64")
	public U8Pointer ve_file$value() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(v._ve_file$valueOffset_));
	}

	// __cptr64 ve_file.value
	public PointerPointer ve_file$valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(v._ve_file$valueOffset_));
	}

	// __cptr64 ve_lock.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_lock$valueOffset_", declaredType="__cptr64")
	public U8Pointer ve_lock$value() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(v._ve_lock$valueOffset_));
	}

	// __cptr64 ve_lock.value
	public PointerPointer ve_lock$valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(v._ve_lock$valueOffset_));
	}

	// __cptr64 ve_proc.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_proc$valueOffset_", declaredType="__cptr64")
	public U8Pointer ve_proc$value() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(v._ve_proc$valueOffset_));
	}

	// __cptr64 ve_proc.value
	public PointerPointer ve_proc$valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(v._ve_proc$valueOffset_));
	}

	// __cptr64 ve_thread.value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_thread$valueOffset_", declaredType="__cptr64")
	public U8Pointer ve_thread$value() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(v._ve_thread$valueOffset_));
	}

	// __cptr64 ve_thread.value
	public PointerPointer ve_thread$valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(v._ve_thread$valueOffset_));
	}

}
