/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _system_conf
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _system_conf {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _L2_cache_ascOffset_;
	public static final int _L2_cache_sizeOffset_;
	public static final int _XfracOffset_;
	public static final int _XintOffset_;
	public static final int _ame_statusOffset_;
	public static final int _architectureOffset_;
	public static final int _cach_congOffset_;
	public static final int _cache_attribOffset_;
	public static final int _capacity_incrementOffset_;
	public static final int _dcache_ascOffset_;
	public static final int _dcache_blockOffset_;
	public static final int _dcache_lineOffset_;
	public static final int _dcache_sizeOffset_;
	public static final int _dfp_versionOffset_;
	public static final int _dispatch_wheelOffset_;
	public static final int _donotuseOffset_;
	public static final int _dtlb_ascOffset_;
	public static final int _dtlb_sizeOffset_;
	public static final int _eco_statusOffset_;
	public static final int _entitled_capacityOffset_;
	public static final int _errchecklevelOffset_;
	public static final int _gencountOffset_;
	public static final int _icache_ascOffset_;
	public static final int _icache_blockOffset_;
	public static final int _icache_lineOffset_;
	public static final int _icache_sizeOffset_;
	public static final int _implementationOffset_;
	public static final int _itlb_ascOffset_;
	public static final int _itlb_sizeOffset_;
	public static final int _kernelOffset_;
	public static final int _max_ncpusOffset_;
	public static final int _maxrealaddrOffset_;
	public static final int _model_archOffset_;
	public static final int _model_implOffset_;
	public static final int _ncpusOffset_;
	public static final int _num_xcpusOffset_;
	public static final int _original_entitled_capacityOffset_;
	public static final int _original_ncpusOffset_;
	public static final int _padOffset_;
	public static final int _phys_implementationOffset_;
	public static final int _phys_versionOffset_;
	public static final int _physmemOffset_;
	public static final int _priv_lck_cntOffset_;
	public static final int _prob_lck_cntOffset_;
	public static final int _resv_sizeOffset_;
	public static final int _rtc_typeOffset_;
	public static final int _slb_attrOffset_;
	public static final int _slb_sizeOffset_;
	public static final int _smt_statusOffset_;
	public static final int _smt_threadsOffset_;
	public static final int _splpar_statusOffset_;
	public static final int _sys_lmbsizeOffset_;
	public static final int _tlb_attribOffset_;
	public static final int _variable_capacity_weightOffset_;
	public static final int _versionOffset_;
	public static final int _virt_aliasOffset_;
	public static final int _vmx_versionOffset_;
	public static final int _vrm_statusOffset_;
	public static final int _widthOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_L2_cache_ascOffset_ = 0;
		_L2_cache_sizeOffset_ = 0;
		_XfracOffset_ = 0;
		_XintOffset_ = 0;
		_ame_statusOffset_ = 0;
		_architectureOffset_ = 0;
		_cach_congOffset_ = 0;
		_cache_attribOffset_ = 0;
		_capacity_incrementOffset_ = 0;
		_dcache_ascOffset_ = 0;
		_dcache_blockOffset_ = 0;
		_dcache_lineOffset_ = 0;
		_dcache_sizeOffset_ = 0;
		_dfp_versionOffset_ = 0;
		_dispatch_wheelOffset_ = 0;
		_donotuseOffset_ = 0;
		_dtlb_ascOffset_ = 0;
		_dtlb_sizeOffset_ = 0;
		_eco_statusOffset_ = 0;
		_entitled_capacityOffset_ = 0;
		_errchecklevelOffset_ = 0;
		_gencountOffset_ = 0;
		_icache_ascOffset_ = 0;
		_icache_blockOffset_ = 0;
		_icache_lineOffset_ = 0;
		_icache_sizeOffset_ = 0;
		_implementationOffset_ = 0;
		_itlb_ascOffset_ = 0;
		_itlb_sizeOffset_ = 0;
		_kernelOffset_ = 0;
		_max_ncpusOffset_ = 0;
		_maxrealaddrOffset_ = 0;
		_model_archOffset_ = 0;
		_model_implOffset_ = 0;
		_ncpusOffset_ = 0;
		_num_xcpusOffset_ = 0;
		_original_entitled_capacityOffset_ = 0;
		_original_ncpusOffset_ = 0;
		_padOffset_ = 0;
		_phys_implementationOffset_ = 0;
		_phys_versionOffset_ = 0;
		_physmemOffset_ = 0;
		_priv_lck_cntOffset_ = 0;
		_prob_lck_cntOffset_ = 0;
		_resv_sizeOffset_ = 0;
		_rtc_typeOffset_ = 0;
		_slb_attrOffset_ = 0;
		_slb_sizeOffset_ = 0;
		_smt_statusOffset_ = 0;
		_smt_threadsOffset_ = 0;
		_splpar_statusOffset_ = 0;
		_sys_lmbsizeOffset_ = 0;
		_tlb_attribOffset_ = 0;
		_variable_capacity_weightOffset_ = 0;
		_versionOffset_ = 0;
		_virt_aliasOffset_ = 0;
		_vmx_versionOffset_ = 0;
		_vrm_statusOffset_ = 0;
		_widthOffset_ = 0;
	}

}
