/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: lc_time_table
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class lc_time_table {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _abdayOffset_;
	public static final int _abmonOffset_;
	public static final int _am_pmOffset_;
	public static final int _d_fmtOffset_;
	public static final int _d_t_fmtOffset_;
	public static final int _dayOffset_;
	public static final int _lc_lengthOffset_;
	public static final int _lc_locale_nameOffset_;
	public static final int _lc_versionOffset_;
	public static final int _miscOffset_;
	public static final int _monOffset_;
	public static final int _nlldateOffset_;
	public static final int _t_fmtOffset_;
	public static final int _tstrsOffset_;
	public static final int _tunitsOffset_;
	public static final int _yearOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_abdayOffset_ = 0;
		_abmonOffset_ = 0;
		_am_pmOffset_ = 0;
		_d_fmtOffset_ = 0;
		_d_t_fmtOffset_ = 0;
		_dayOffset_ = 0;
		_lc_lengthOffset_ = 0;
		_lc_locale_nameOffset_ = 0;
		_lc_versionOffset_ = 0;
		_miscOffset_ = 0;
		_monOffset_ = 0;
		_nlldateOffset_ = 0;
		_t_fmtOffset_ = 0;
		_tstrsOffset_ = 0;
		_tunitsOffset_ = 0;
		_yearOffset_ = 0;
	}

}
