/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: perfstat_cpu_total_t
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class perfstat_cpu_total_t {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _breadOffset_;
	public static final int _busy_donated_purrOffset_;
	public static final int _busy_donated_spurrOffset_;
	public static final int _busy_stolen_purrOffset_;
	public static final int _busy_stolen_spurrOffset_;
	public static final int _bwriteOffset_;
	public static final int _decrintrsOffset_;
	public static final int _descriptionOffset_;
	public static final int _devintrsOffset_;
	public static final int _dirblkOffset_;
	public static final int _hpiOffset_;
	public static final int _hpitOffset_;
	public static final int _idleOffset_;
	public static final int _idle_donated_purrOffset_;
	public static final int _idle_donated_spurrOffset_;
	public static final int _idle_stolen_purrOffset_;
	public static final int _idle_stolen_spurrOffset_;
	public static final int _igetOffset_;
	public static final int _iowaitOffset_;
	public static final int _kexitOffset_;
	public static final int _koverfOffset_;
	public static final int _kschedOffset_;
	public static final int _lboltOffset_;
	public static final int _loadavgOffset_;
	public static final int _lreadOffset_;
	public static final int _lwriteOffset_;
	public static final int _mdmintOffset_;
	public static final int _mpcrintrsOffset_;
	public static final int _mpcsintrsOffset_;
	public static final int _msgOffset_;
	public static final int _nameiOffset_;
	public static final int _ncpusOffset_;
	public static final int _ncpus_cfgOffset_;
	public static final int _ncpus_highOffset_;
	public static final int _phantintrsOffset_;
	public static final int _phreadOffset_;
	public static final int _phwriteOffset_;
	public static final int _physioOffset_;
	public static final int _pidleOffset_;
	public static final int _pidle_spurrOffset_;
	public static final int _processorHZOffset_;
	public static final int _pswitchOffset_;
	public static final int _psysOffset_;
	public static final int _psys_spurrOffset_;
	public static final int _purr_coalescingOffset_;
	public static final int _puserOffset_;
	public static final int _puser_spurrOffset_;
	public static final int _pwaitOffset_;
	public static final int _pwait_spurrOffset_;
	public static final int _rbreadOffset_;
	public static final int _rbwrtOffset_;
	public static final int _rcreadOffset_;
	public static final int _rcvintOffset_;
	public static final int _rcwrtOffset_;
	public static final int _readchOffset_;
	public static final int _runoccOffset_;
	public static final int _runqueOffset_;
	public static final int _semaOffset_;
	public static final int _softintrsOffset_;
	public static final int _spurr_coalescingOffset_;
	public static final int _spurrflagOffset_;
	public static final int _swpoccOffset_;
	public static final int _swpqueOffset_;
	public static final int _sysOffset_;
	public static final int _syscallOffset_;
	public static final int _sysexecOffset_;
	public static final int _sysforkOffset_;
	public static final int _sysreadOffset_;
	public static final int _syswriteOffset_;
	public static final int _tb_lastOffset_;
	public static final int _trapsOffset_;
	public static final int _tty_caninchOffset_;
	public static final int _tty_rawinchOffset_;
	public static final int _tty_rawoutchOffset_;
	public static final int _twaitOffset_;
	public static final int _userOffset_;
	public static final int _versionOffset_;
	public static final int _wait_fieldOffset_;
	public static final int _writechOffset_;
	public static final int _xmtintOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_breadOffset_ = 0;
		_busy_donated_purrOffset_ = 0;
		_busy_donated_spurrOffset_ = 0;
		_busy_stolen_purrOffset_ = 0;
		_busy_stolen_spurrOffset_ = 0;
		_bwriteOffset_ = 0;
		_decrintrsOffset_ = 0;
		_descriptionOffset_ = 0;
		_devintrsOffset_ = 0;
		_dirblkOffset_ = 0;
		_hpiOffset_ = 0;
		_hpitOffset_ = 0;
		_idleOffset_ = 0;
		_idle_donated_purrOffset_ = 0;
		_idle_donated_spurrOffset_ = 0;
		_idle_stolen_purrOffset_ = 0;
		_idle_stolen_spurrOffset_ = 0;
		_igetOffset_ = 0;
		_iowaitOffset_ = 0;
		_kexitOffset_ = 0;
		_koverfOffset_ = 0;
		_kschedOffset_ = 0;
		_lboltOffset_ = 0;
		_loadavgOffset_ = 0;
		_lreadOffset_ = 0;
		_lwriteOffset_ = 0;
		_mdmintOffset_ = 0;
		_mpcrintrsOffset_ = 0;
		_mpcsintrsOffset_ = 0;
		_msgOffset_ = 0;
		_nameiOffset_ = 0;
		_ncpusOffset_ = 0;
		_ncpus_cfgOffset_ = 0;
		_ncpus_highOffset_ = 0;
		_phantintrsOffset_ = 0;
		_phreadOffset_ = 0;
		_phwriteOffset_ = 0;
		_physioOffset_ = 0;
		_pidleOffset_ = 0;
		_pidle_spurrOffset_ = 0;
		_processorHZOffset_ = 0;
		_pswitchOffset_ = 0;
		_psysOffset_ = 0;
		_psys_spurrOffset_ = 0;
		_purr_coalescingOffset_ = 0;
		_puserOffset_ = 0;
		_puser_spurrOffset_ = 0;
		_pwaitOffset_ = 0;
		_pwait_spurrOffset_ = 0;
		_rbreadOffset_ = 0;
		_rbwrtOffset_ = 0;
		_rcreadOffset_ = 0;
		_rcvintOffset_ = 0;
		_rcwrtOffset_ = 0;
		_readchOffset_ = 0;
		_runoccOffset_ = 0;
		_runqueOffset_ = 0;
		_semaOffset_ = 0;
		_softintrsOffset_ = 0;
		_spurr_coalescingOffset_ = 0;
		_spurrflagOffset_ = 0;
		_swpoccOffset_ = 0;
		_swpqueOffset_ = 0;
		_sysOffset_ = 0;
		_syscallOffset_ = 0;
		_sysexecOffset_ = 0;
		_sysforkOffset_ = 0;
		_sysreadOffset_ = 0;
		_syswriteOffset_ = 0;
		_tb_lastOffset_ = 0;
		_trapsOffset_ = 0;
		_tty_caninchOffset_ = 0;
		_tty_rawinchOffset_ = 0;
		_tty_rawoutchOffset_ = 0;
		_twaitOffset_ = 0;
		_userOffset_ = 0;
		_versionOffset_ = 0;
		_wait_fieldOffset_ = 0;
		_writechOffset_ = 0;
		_xmtintOffset_ = 0;
	}

}
