/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: psinfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class psinfo {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _pr__padOffset_;
	public static final int _pr__pad1Offset_;
	public static final int _pr__pad2Offset_;
	public static final int _pr_addrOffset_;
	public static final int _pr_argcOffset_;
	public static final int _pr_argvOffset_;
	public static final int _pr_cidOffset_;
	public static final int _pr_egidOffset_;
	public static final int _pr_envpOffset_;
	public static final int _pr_euidOffset_;
	public static final int _pr_flagOffset_;
	public static final int _pr_flag2Offset_;
	public static final int _pr_fnameOffset_;
	public static final int _pr_gidOffset_;
	public static final int _pr_lwpOffset_;
	public static final int _pr_nlwpOffset_;
	public static final int _pr_pgidOffset_;
	public static final int _pr_pidOffset_;
	public static final int _pr_ppidOffset_;
	public static final int _pr_psargsOffset_;
	public static final int _pr_rssizeOffset_;
	public static final int _pr_sidOffset_;
	public static final int _pr_sizeOffset_;
	public static final int _pr_startOffset_;
	public static final int _pr_timeOffset_;
	public static final int _pr_ttydevOffset_;
	public static final int _pr_uidOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_pr__padOffset_ = 0;
		_pr__pad1Offset_ = 0;
		_pr__pad2Offset_ = 0;
		_pr_addrOffset_ = 0;
		_pr_argcOffset_ = 0;
		_pr_argvOffset_ = 0;
		_pr_cidOffset_ = 0;
		_pr_egidOffset_ = 0;
		_pr_envpOffset_ = 0;
		_pr_euidOffset_ = 0;
		_pr_flagOffset_ = 0;
		_pr_flag2Offset_ = 0;
		_pr_fnameOffset_ = 0;
		_pr_gidOffset_ = 0;
		_pr_lwpOffset_ = 0;
		_pr_nlwpOffset_ = 0;
		_pr_pgidOffset_ = 0;
		_pr_pidOffset_ = 0;
		_pr_ppidOffset_ = 0;
		_pr_psargsOffset_ = 0;
		_pr_rssizeOffset_ = 0;
		_pr_sidOffset_ = 0;
		_pr_sizeOffset_ = 0;
		_pr_startOffset_ = 0;
		_pr_timeOffset_ = 0;
		_pr_ttydevOffset_ = 0;
		_pr_uidOffset_ = 0;
	}

}
