/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: pvproc
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class pvproc {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _pv_acctflagsOffset_;
	public static final int _pv_af1$pv_aff_stat_intOffset_;
	public static final int _pv_af1$pv_aff_stat_longOffset_;
	public static final int _pv_aff_stat_extOffset_;
	public static final int _pv_app_devOffset_;
	public static final int _pv_app_genOffset_;
	public static final int _pv_app_inoOffset_;
	public static final int _pv_archOffset_;
	public static final int _pv_as_mapOffset_;
	public static final int _pv_aso_stateOffset_;
	public static final int _pv_asyncioOffset_;
	public static final int _pv_atomicOffset_;
	public static final int _pv_auditmaskOffset_;
	public static final int _pv_bopflagsOffset_;
	public static final int _pv_bopmcntOffset_;
	public static final int _pv_cached_credpOffset_;
	public static final int _pv_childOffset_;
	public static final int _pv_chksynchOffset_;
	public static final int _pv_chktvOffset_;
	public static final int _pv_classOffset_;
	public static final int _pv_creOffset_;
	public static final int _pv_cre_flagsOffset_;
	public static final int _pv_cridOffset_;
	public static final int _pv_crid_tokenOffset_;
	public static final int _pv_cridnextOffset_;
	public static final int _pv_dblistOffset_;
	public static final int _pv_dbnextOffset_;
	public static final int _pv_ewlmprocOffset_;
	public static final int _pv_eyecOffset_;
	public static final int _pv_flagOffset_;
	public static final int _pv_flag2Offset_;
	public static final int _pv_flag3Offset_;
	public static final int _pv_flag3eOffset_;
	public static final int _pv_flag3pOffset_;
	public static final int _pv_ganchorOffset_;
	public static final int _pv_gcipcOffset_;
	public static final int _pv_handlersOffset_;
	public static final int _pv_handlers_lockOffset_;
	public static final int _pv_ipcOffset_;
	public static final int _pv_kcidOffset_;
	public static final int _pv_last_childOffset_;
	public static final int _pv_lockOffset_;
	public static final int _pv_lock_dOffset_;
	public static final int _pv_mcrpOffset_;
	public static final int _pv_mempoolsOffset_;
	public static final int _pv_ncpagesOffset_;
	public static final int _pv_nframesOffset_;
	public static final int _pv_nodegenOffset_;
	public static final int _pv_npsblksOffset_;
	public static final int _pv_nvpagesOffset_;
	public static final int _pv_p11_ctxOffset_;
	public static final int _pv_pad0Offset_;
	public static final int _pv_pad1Offset_;
	public static final int _pv_pad2Offset_;
	public static final int _pv_parent_lockOffset_;
	public static final int _pv_pgrpOffset_;
	public static final int _pv_pgrpbOffset_;
	public static final int _pv_pgrplOffset_;
	public static final int _pv_pidOffset_;
	public static final int _pv_pndaOffset_;
	public static final int _pv_policyOffset_;
	public static final int _pv_ppidOffset_;
	public static final int _pv_priOffset_;
	public static final int _pv_procfsvnOffset_;
	public static final int _pv_procpOffset_;
	public static final int _pv_projidOffset_;
	public static final int _pv_rsetOffset_;
	public static final int _pv_ruOffset_;
	public static final int _pv_sched_backOffset_;
	public static final int _pv_sched_nextOffset_;
	public static final int _pv_secflagOffset_;
	public static final int _pv_session_lockOffset_;
	public static final int _pv_si_statusOffset_;
	public static final int _pv_sib_backOffset_;
	public static final int _pv_siblingsOffset_;
	public static final int _pv_sidOffset_;
	public static final int _pv_sigs_queuedOffset_;
	public static final int _pv_spareOffset_;
	public static final int _pv_sprojidOffset_;
	public static final int _pv_statOffset_;
	public static final int _pv_static_environmentOffset_;
	public static final int _pv_subprojOffset_;
	public static final int _pv_suidOffset_;
	public static final int _pv_synchOffset_;
	public static final int _pv_termtimeOffset_;
	public static final int _pv_threadlistOffset_;
	public static final int _pv_time_lockOffset_;
	public static final int _pv_totalcputimeOffset_;
	public static final int _pv_totaldiskioOffset_;
	public static final int _pv_totalscputimeOffset_;
	public static final int _pv_ttylOffset_;
	public static final int _pv_uidOffset_;
	public static final int _pv_uidinfoOffset_;
	public static final int _pv_usched_lockOffset_;
	public static final int _pv_uschedpOffset_;
	public static final int _pv_vmm_xproc_dataOffset_;
	public static final int _pv_vpgrpOffset_;
	public static final int _pv_vpidOffset_;
	public static final int _pv_vppidOffset_;
	public static final int _pv_vsidOffset_;
	public static final int _pv_wlmOffset_;
	public static final int _pv_wlm_nvpagesOffset_;
	public static final int _pv_xproc_synchOffset_;
	public static final int _pv_xstatOffset_;
	public static final int _pv_zombiesOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_pv_acctflagsOffset_ = 0;
		_pv_af1$pv_aff_stat_intOffset_ = 0;
		_pv_af1$pv_aff_stat_longOffset_ = 0;
		_pv_aff_stat_extOffset_ = 0;
		_pv_app_devOffset_ = 0;
		_pv_app_genOffset_ = 0;
		_pv_app_inoOffset_ = 0;
		_pv_archOffset_ = 0;
		_pv_as_mapOffset_ = 0;
		_pv_aso_stateOffset_ = 0;
		_pv_asyncioOffset_ = 0;
		_pv_atomicOffset_ = 0;
		_pv_auditmaskOffset_ = 0;
		_pv_bopflagsOffset_ = 0;
		_pv_bopmcntOffset_ = 0;
		_pv_cached_credpOffset_ = 0;
		_pv_childOffset_ = 0;
		_pv_chksynchOffset_ = 0;
		_pv_chktvOffset_ = 0;
		_pv_classOffset_ = 0;
		_pv_creOffset_ = 0;
		_pv_cre_flagsOffset_ = 0;
		_pv_cridOffset_ = 0;
		_pv_crid_tokenOffset_ = 0;
		_pv_cridnextOffset_ = 0;
		_pv_dblistOffset_ = 0;
		_pv_dbnextOffset_ = 0;
		_pv_ewlmprocOffset_ = 0;
		_pv_eyecOffset_ = 0;
		_pv_flagOffset_ = 0;
		_pv_flag2Offset_ = 0;
		_pv_flag3Offset_ = 0;
		_pv_flag3eOffset_ = 0;
		_pv_flag3pOffset_ = 0;
		_pv_ganchorOffset_ = 0;
		_pv_gcipcOffset_ = 0;
		_pv_handlersOffset_ = 0;
		_pv_handlers_lockOffset_ = 0;
		_pv_ipcOffset_ = 0;
		_pv_kcidOffset_ = 0;
		_pv_last_childOffset_ = 0;
		_pv_lockOffset_ = 0;
		_pv_lock_dOffset_ = 0;
		_pv_mcrpOffset_ = 0;
		_pv_mempoolsOffset_ = 0;
		_pv_ncpagesOffset_ = 0;
		_pv_nframesOffset_ = 0;
		_pv_nodegenOffset_ = 0;
		_pv_npsblksOffset_ = 0;
		_pv_nvpagesOffset_ = 0;
		_pv_p11_ctxOffset_ = 0;
		_pv_pad0Offset_ = 0;
		_pv_pad1Offset_ = 0;
		_pv_pad2Offset_ = 0;
		_pv_parent_lockOffset_ = 0;
		_pv_pgrpOffset_ = 0;
		_pv_pgrpbOffset_ = 0;
		_pv_pgrplOffset_ = 0;
		_pv_pidOffset_ = 0;
		_pv_pndaOffset_ = 0;
		_pv_policyOffset_ = 0;
		_pv_ppidOffset_ = 0;
		_pv_priOffset_ = 0;
		_pv_procfsvnOffset_ = 0;
		_pv_procpOffset_ = 0;
		_pv_projidOffset_ = 0;
		_pv_rsetOffset_ = 0;
		_pv_ruOffset_ = 0;
		_pv_sched_backOffset_ = 0;
		_pv_sched_nextOffset_ = 0;
		_pv_secflagOffset_ = 0;
		_pv_session_lockOffset_ = 0;
		_pv_si_statusOffset_ = 0;
		_pv_sib_backOffset_ = 0;
		_pv_siblingsOffset_ = 0;
		_pv_sidOffset_ = 0;
		_pv_sigs_queuedOffset_ = 0;
		_pv_spareOffset_ = 0;
		_pv_sprojidOffset_ = 0;
		_pv_statOffset_ = 0;
		_pv_static_environmentOffset_ = 0;
		_pv_subprojOffset_ = 0;
		_pv_suidOffset_ = 0;
		_pv_synchOffset_ = 0;
		_pv_termtimeOffset_ = 0;
		_pv_threadlistOffset_ = 0;
		_pv_time_lockOffset_ = 0;
		_pv_totalcputimeOffset_ = 0;
		_pv_totaldiskioOffset_ = 0;
		_pv_totalscputimeOffset_ = 0;
		_pv_ttylOffset_ = 0;
		_pv_uidOffset_ = 0;
		_pv_uidinfoOffset_ = 0;
		_pv_usched_lockOffset_ = 0;
		_pv_uschedpOffset_ = 0;
		_pv_vmm_xproc_dataOffset_ = 0;
		_pv_vpgrpOffset_ = 0;
		_pv_vpidOffset_ = 0;
		_pv_vppidOffset_ = 0;
		_pv_vsidOffset_ = 0;
		_pv_wlmOffset_ = 0;
		_pv_wlm_nvpagesOffset_ = 0;
		_pv_xproc_synchOffset_ = 0;
		_pv_xstatOffset_ = 0;
		_pv_zombiesOffset_ = 0;
	}

}
