/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: subsec_attr
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class subsec_attr {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _effprivOffset_;
	public static final int _flagsOffset_;
	public static final int _inhprivOffset_;
	public static final int _labelsOffset_;
	public static final int _limprivOffset_;
	public static final int _maxprivOffset_;
	public static final int _nrolesOffset_;
	public static final int _ntrauthsOffset_;
	public static final int _reservedOffset_;
	public static final int _rolesOffset_;
	public static final int _usedprivOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_effprivOffset_ = 0;
		_flagsOffset_ = 0;
		_inhprivOffset_ = 0;
		_labelsOffset_ = 0;
		_limprivOffset_ = 0;
		_maxprivOffset_ = 0;
		_nrolesOffset_ = 0;
		_ntrauthsOffset_ = 0;
		_reservedOffset_ = 0;
		_rolesOffset_ = 0;
		_usedprivOffset_ = 0;
	}

}
