/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: thread
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class thread {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _pth_stimeOffset_;
	public static final int _pth_utimeOffset_;
	public static final int _t_adsp_flagsOffset_;
	public static final int _t_advrset_maskpOffset_;
	public static final int _t_affinity_tsOffset_;
	public static final int _t_allowed_cpusOffset_;
	public static final int _t_atomicOffset_;
	public static final int _t_attachmapOffset_;
	public static final int _t_boost_levelOffset_;
	public static final int _t_boost_typeOffset_;
	public static final int _t_borrow_priOffset_;
	public static final int _t_borrowed_utilOffset_;
	public static final int _t_ceilingOffset_;
	public static final int _t_chkblockOffset_;
	public static final int _t_chkerrorOffset_;
	public static final int _t_cpuOffset_;
	public static final int _t_cpu2Offset_;
	public static final int _t_cpu_tbOffset_;
	public static final int _t_cpuidOffset_;
	public static final int _t_cputimeOffset_;
	public static final int _t_credpOffset_;
	public static final int _t_cursigOffset_;
	public static final int _t_cvOffset_;
	public static final int _t_delwOffset_;
	public static final int _t_dispatch_countOffset_;
	public static final int _t_dispatch_histOffset_;
	public static final int _t_dispctOffset_;
	public static final int _t_eventlistOffset_;
	public static final int _t_evm_tlv_structOffset_;
	public static final int _t_eyecOffset_;
	public static final int _t_far_dispctOffset_;
	public static final int _t_flagsOffset_;
	public static final int _t_flags2Offset_;
	public static final int _t_flags3Offset_;
	public static final int _t_fpuctOffset_;
	public static final int _t_fsflagsOffset_;
	public static final int _t_graphicsOffset_;
	public static final int _t_home_rqOffset_;
	public static final int _t_home_sradidOffset_;
	public static final int _t_homecountOffset_;
	public static final int _t_interval_startOffset_;
	public static final int _t_io_priorityOffset_;
	public static final int _t_ipc_dataOffset_;
	public static final int _t_iprb_snpshtd_ptrOffset_;
	public static final int _t_kscpOffset_;
	public static final int _t_kthreadsegOffset_;
	public static final int _t_last_wakeupOffset_;
	public static final int _t_latency_dispctOffset_;
	public static final int _t_latency_totalOffset_;
	public static final int _t_ldispcpuOffset_;
	public static final int _t_lnextOffset_;
	public static final int _t_lockcountOffset_;
	public static final int _t_lockownerOffset_;
	public static final int _t_lockpriOffset_;
	public static final int _t_lpriorOffset_;
	public static final int _t_maj_pf_dataOffset_;
	public static final int _t_maj_pf_kernelOffset_;
	public static final int _t_maj_pf_textOffset_;
	public static final int _t_majfltOffset_;
	public static final int _t_min_pf_dataOffset_;
	public static final int _t_min_pf_kernelOffset_;
	public static final int _t_min_pf_textOffset_;
	public static final int _t_minfltOffset_;
	public static final int _t_mrcOffset_;
	public static final int _t_near_dispctOffset_;
	public static final int _t_near_rqOffset_;
	public static final int _t_nextOffset_;
	public static final int _t_niceOffset_;
	public static final int _t_norun_secsOffset_;
	public static final int _t_pad1Offset_;
	public static final int _t_peventOffset_;
	public static final int _t_pf_startOffset_;
	public static final int _t_polevelOffset_;
	public static final int _t_policyOffset_;
	public static final int _t_prefunnel_cpuOffset_;
	public static final int _t_pri_bandOffset_;
	public static final int _t_priorOffset_;
	public static final int _t_procpOffset_;
	public static final int _t_pvthreadpOffset_;
	public static final int _t_reaffin_countOffset_;
	public static final int _t_rehome_tbOffset_;
	public static final int _t_resultOffset_;
	public static final int _t_rs_attinfoOffset_;
	public static final int _t_rt_ticksOffset_;
	public static final int _t_ru_idrssOffset_;
	public static final int _t_ru_ixrssOffset_;
	public static final int _t_ru_maxrssOffset_;
	public static final int _t_run_queueOffset_;
	public static final int _t_runnable_startOffset_;
	public static final int _t_runnable_totalOffset_;
	public static final int _t_running_startOffset_;
	public static final int _t_running_totalOffset_;
	public static final int _t_sav_priOffset_;
	public static final int _t_savsignoOffset_;
	public static final int _t_sc_activeOffset_;
	public static final int _t_scpOffset_;
	public static final int _t_scpuidOffset_;
	public static final int _t_scputimeOffset_;
	public static final int _t_sigOffset_;
	public static final int _t_sigmaskOffset_;
	public static final int _t_sigprocOffset_;
	public static final int _t_slistOffset_;
	public static final int _t_slist_prevOffset_;
	public static final int _t_smt_priorityOffset_;
	public static final int _t_spurr_time_startOffset_;
	public static final int _t_stackpOffset_;
	public static final int _t_starttimeOffset_;
	public static final int _t_suspendOffset_;
	public static final int _t_swchanOffset_;
	public static final int _t_synch_sigOffset_;
	public static final int _t_threadcontrolpOffset_;
	public static final int _t_ticksOffset_;
	public static final int _t_tidOffset_;
	public static final int _t_timeOffset_;
	public static final int _t_time_startOffset_;
	public static final int _t_trcgenctOffset_;
	public static final int _t_uaddressOffset_;
	public static final int _t_uchanOffset_;
	public static final int _t_ulockOffset_;
	public static final int _t_ulock_listpOffset_;
	public static final int _t_userdataOffset_;
	public static final int _t_usidOffset_;
	public static final int _t_vtidOffset_;
	public static final int _t_waitTmOffset_;
	public static final int _t_wakepriOffset_;
	public static final int _t_wchan1Offset_;
	public static final int _t_wchan1offsetOffset_;
	public static final int _t_wchan1sidOffset_;
	public static final int _t_wchan2Offset_;
	public static final int _t_weventOffset_;
	public static final int _t_whatstopOffset_;
	public static final int _t_whystopOffset_;
	public static final int _t_wlm_chargeOffset_;
	public static final int _t_wlmevtcntOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_pth_stimeOffset_ = 0;
		_pth_utimeOffset_ = 0;
		_t_adsp_flagsOffset_ = 0;
		_t_advrset_maskpOffset_ = 0;
		_t_affinity_tsOffset_ = 0;
		_t_allowed_cpusOffset_ = 0;
		_t_atomicOffset_ = 0;
		_t_attachmapOffset_ = 0;
		_t_boost_levelOffset_ = 0;
		_t_boost_typeOffset_ = 0;
		_t_borrow_priOffset_ = 0;
		_t_borrowed_utilOffset_ = 0;
		_t_ceilingOffset_ = 0;
		_t_chkblockOffset_ = 0;
		_t_chkerrorOffset_ = 0;
		_t_cpuOffset_ = 0;
		_t_cpu2Offset_ = 0;
		_t_cpu_tbOffset_ = 0;
		_t_cpuidOffset_ = 0;
		_t_cputimeOffset_ = 0;
		_t_credpOffset_ = 0;
		_t_cursigOffset_ = 0;
		_t_cvOffset_ = 0;
		_t_delwOffset_ = 0;
		_t_dispatch_countOffset_ = 0;
		_t_dispatch_histOffset_ = 0;
		_t_dispctOffset_ = 0;
		_t_eventlistOffset_ = 0;
		_t_evm_tlv_structOffset_ = 0;
		_t_eyecOffset_ = 0;
		_t_far_dispctOffset_ = 0;
		_t_flagsOffset_ = 0;
		_t_flags2Offset_ = 0;
		_t_flags3Offset_ = 0;
		_t_fpuctOffset_ = 0;
		_t_fsflagsOffset_ = 0;
		_t_graphicsOffset_ = 0;
		_t_home_rqOffset_ = 0;
		_t_home_sradidOffset_ = 0;
		_t_homecountOffset_ = 0;
		_t_interval_startOffset_ = 0;
		_t_io_priorityOffset_ = 0;
		_t_ipc_dataOffset_ = 0;
		_t_iprb_snpshtd_ptrOffset_ = 0;
		_t_kscpOffset_ = 0;
		_t_kthreadsegOffset_ = 0;
		_t_last_wakeupOffset_ = 0;
		_t_latency_dispctOffset_ = 0;
		_t_latency_totalOffset_ = 0;
		_t_ldispcpuOffset_ = 0;
		_t_lnextOffset_ = 0;
		_t_lockcountOffset_ = 0;
		_t_lockownerOffset_ = 0;
		_t_lockpriOffset_ = 0;
		_t_lpriorOffset_ = 0;
		_t_maj_pf_dataOffset_ = 0;
		_t_maj_pf_kernelOffset_ = 0;
		_t_maj_pf_textOffset_ = 0;
		_t_majfltOffset_ = 0;
		_t_min_pf_dataOffset_ = 0;
		_t_min_pf_kernelOffset_ = 0;
		_t_min_pf_textOffset_ = 0;
		_t_minfltOffset_ = 0;
		_t_mrcOffset_ = 0;
		_t_near_dispctOffset_ = 0;
		_t_near_rqOffset_ = 0;
		_t_nextOffset_ = 0;
		_t_niceOffset_ = 0;
		_t_norun_secsOffset_ = 0;
		_t_pad1Offset_ = 0;
		_t_peventOffset_ = 0;
		_t_pf_startOffset_ = 0;
		_t_polevelOffset_ = 0;
		_t_policyOffset_ = 0;
		_t_prefunnel_cpuOffset_ = 0;
		_t_pri_bandOffset_ = 0;
		_t_priorOffset_ = 0;
		_t_procpOffset_ = 0;
		_t_pvthreadpOffset_ = 0;
		_t_reaffin_countOffset_ = 0;
		_t_rehome_tbOffset_ = 0;
		_t_resultOffset_ = 0;
		_t_rs_attinfoOffset_ = 0;
		_t_rt_ticksOffset_ = 0;
		_t_ru_idrssOffset_ = 0;
		_t_ru_ixrssOffset_ = 0;
		_t_ru_maxrssOffset_ = 0;
		_t_run_queueOffset_ = 0;
		_t_runnable_startOffset_ = 0;
		_t_runnable_totalOffset_ = 0;
		_t_running_startOffset_ = 0;
		_t_running_totalOffset_ = 0;
		_t_sav_priOffset_ = 0;
		_t_savsignoOffset_ = 0;
		_t_sc_activeOffset_ = 0;
		_t_scpOffset_ = 0;
		_t_scpuidOffset_ = 0;
		_t_scputimeOffset_ = 0;
		_t_sigOffset_ = 0;
		_t_sigmaskOffset_ = 0;
		_t_sigprocOffset_ = 0;
		_t_slistOffset_ = 0;
		_t_slist_prevOffset_ = 0;
		_t_smt_priorityOffset_ = 0;
		_t_spurr_time_startOffset_ = 0;
		_t_stackpOffset_ = 0;
		_t_starttimeOffset_ = 0;
		_t_suspendOffset_ = 0;
		_t_swchanOffset_ = 0;
		_t_synch_sigOffset_ = 0;
		_t_threadcontrolpOffset_ = 0;
		_t_ticksOffset_ = 0;
		_t_tidOffset_ = 0;
		_t_timeOffset_ = 0;
		_t_time_startOffset_ = 0;
		_t_trcgenctOffset_ = 0;
		_t_uaddressOffset_ = 0;
		_t_uchanOffset_ = 0;
		_t_ulockOffset_ = 0;
		_t_ulock_listpOffset_ = 0;
		_t_userdataOffset_ = 0;
		_t_usidOffset_ = 0;
		_t_vtidOffset_ = 0;
		_t_waitTmOffset_ = 0;
		_t_wakepriOffset_ = 0;
		_t_wchan1Offset_ = 0;
		_t_wchan1offsetOffset_ = 0;
		_t_wchan1sidOffset_ = 0;
		_t_wchan2Offset_ = 0;
		_t_weventOffset_ = 0;
		_t_whatstopOffset_ = 0;
		_t_whystopOffset_ = 0;
		_t_wlm_chargeOffset_ = 0;
		_t_wlmevtcntOffset_ = 0;
	}

}
