/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: trusage32
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class trusage32 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _ru_idrssOffset_;
	public static final int _ru_inblockOffset_;
	public static final int _ru_isrssOffset_;
	public static final int _ru_ixrssOffset_;
	public static final int _ru_majfltOffset_;
	public static final int _ru_maxrssOffset_;
	public static final int _ru_minfltOffset_;
	public static final int _ru_msgrcvOffset_;
	public static final int _ru_msgsndOffset_;
	public static final int _ru_nivcswOffset_;
	public static final int _ru_nsignalsOffset_;
	public static final int _ru_nswapOffset_;
	public static final int _ru_nvcswOffset_;
	public static final int _ru_oublockOffset_;
	public static final int _ru_stimeOffset_;
	public static final int _ru_utimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_ru_idrssOffset_ = 0;
		_ru_inblockOffset_ = 0;
		_ru_isrssOffset_ = 0;
		_ru_ixrssOffset_ = 0;
		_ru_majfltOffset_ = 0;
		_ru_maxrssOffset_ = 0;
		_ru_minfltOffset_ = 0;
		_ru_msgrcvOffset_ = 0;
		_ru_msgsndOffset_ = 0;
		_ru_nivcswOffset_ = 0;
		_ru_nsignalsOffset_ = 0;
		_ru_nswapOffset_ = 0;
		_ru_nvcswOffset_ = 0;
		_ru_oublockOffset_ = 0;
		_ru_stimeOffset_ = 0;
		_ru_utimeOffset_ = 0;
	}

}
