/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: Elf32_PhdrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the Elf32_PhdrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=Elf32_Phdr.class)
public class Elf32_PhdrPointer extends StructurePointer {

	// NULL
	public static final Elf32_PhdrPointer NULL = new Elf32_PhdrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected Elf32_PhdrPointer(long address) {
		super(address);
	}

	public static Elf32_PhdrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static Elf32_PhdrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static Elf32_PhdrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new Elf32_PhdrPointer(address);
	}

	public Elf32_PhdrPointer add(long count) {
		return Elf32_PhdrPointer.cast(address + (Elf32_Phdr.SIZEOF * count));
	}

	public Elf32_PhdrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public Elf32_PhdrPointer addOffset(long offset) {
		return Elf32_PhdrPointer.cast(address + offset);
	}

	public Elf32_PhdrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public Elf32_PhdrPointer sub(long count) {
		return Elf32_PhdrPointer.cast(address - (Elf32_Phdr.SIZEOF * count));
	}

	public Elf32_PhdrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public Elf32_PhdrPointer subOffset(long offset) {
		return Elf32_PhdrPointer.cast(address - offset);
	}

	public Elf32_PhdrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public Elf32_PhdrPointer untag(long mask) {
		return Elf32_PhdrPointer.cast(address & ~mask);
	}

	public Elf32_PhdrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return Elf32_Phdr.SIZEOF;
	}

	// Implementation methods

	// Elf32_Word p_align
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_alignOffset_", declaredType="Elf32_Word")
	public UDATA p_align() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_alignOffset_));
	}

	// Elf32_Word p_align
	public UDATAPointer p_alignEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_alignOffset_));
	}

	// Elf32_Word p_filesz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_fileszOffset_", declaredType="Elf32_Word")
	public UDATA p_filesz() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_fileszOffset_));
	}

	// Elf32_Word p_filesz
	public UDATAPointer p_fileszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_fileszOffset_));
	}

	// Elf32_Word p_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_flagsOffset_", declaredType="Elf32_Word")
	public UDATA p_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_flagsOffset_));
	}

	// Elf32_Word p_flags
	public UDATAPointer p_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_flagsOffset_));
	}

	// Elf32_Word p_memsz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_memszOffset_", declaredType="Elf32_Word")
	public UDATA p_memsz() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_memszOffset_));
	}

	// Elf32_Word p_memsz
	public UDATAPointer p_memszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_memszOffset_));
	}

	// Elf32_Off p_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_offsetOffset_", declaredType="Elf32_Off")
	public UDATA p_offset() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_offsetOffset_));
	}

	// Elf32_Off p_offset
	public UDATAPointer p_offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_offsetOffset_));
	}

	// Elf32_Addr p_paddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_paddrOffset_", declaredType="Elf32_Addr")
	public UDATA p_paddr() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_paddrOffset_));
	}

	// Elf32_Addr p_paddr
	public UDATAPointer p_paddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_paddrOffset_));
	}

	// Elf32_Word p_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_typeOffset_", declaredType="Elf32_Word")
	public UDATA p_type() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_typeOffset_));
	}

	// Elf32_Word p_type
	public UDATAPointer p_typeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_typeOffset_));
	}

	// Elf32_Addr p_vaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_vaddrOffset_", declaredType="Elf32_Addr")
	public UDATA p_vaddr() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Phdr._p_vaddrOffset_));
	}

	// Elf32_Addr p_vaddr
	public UDATAPointer p_vaddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Phdr._p_vaddrOffset_));
	}

}
