/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9CudaJitOptionsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9CudaJitOptionsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9CudaJitOptions.class)
public class J9CudaJitOptionsPointer extends StructurePointer {

	// NULL
	public static final J9CudaJitOptionsPointer NULL = new J9CudaJitOptionsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9CudaJitOptionsPointer(long address) {
		super(address);
	}

	public static J9CudaJitOptionsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9CudaJitOptionsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9CudaJitOptionsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9CudaJitOptionsPointer(address);
	}

	public J9CudaJitOptionsPointer add(long count) {
		return J9CudaJitOptionsPointer.cast(address + (J9CudaJitOptions.SIZEOF * count));
	}

	public J9CudaJitOptionsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9CudaJitOptionsPointer addOffset(long offset) {
		return J9CudaJitOptionsPointer.cast(address + offset);
	}

	public J9CudaJitOptionsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9CudaJitOptionsPointer sub(long count) {
		return J9CudaJitOptionsPointer.cast(address - (J9CudaJitOptions.SIZEOF * count));
	}

	public J9CudaJitOptionsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9CudaJitOptionsPointer subOffset(long offset) {
		return J9CudaJitOptionsPointer.cast(address - offset);
	}

	public J9CudaJitOptionsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9CudaJitOptionsPointer untag(long mask) {
		return J9CudaJitOptionsPointer.cast(address & ~mask);
	}

	public J9CudaJitOptionsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9CudaJitOptions.SIZEOF;
	}

	// Implementation methods

	// J9CudaJitCacheMode cacheMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheModeOffset_", declaredType="J9CudaJitCacheMode")
	public long cacheMode() throws CorruptDataException {
		if (J9CudaJitCacheMode.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._cacheModeOffset_);
		} else if (J9CudaJitCacheMode.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._cacheModeOffset_);
		} else if (J9CudaJitCacheMode.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._cacheModeOffset_);
		} else if (J9CudaJitCacheMode.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._cacheModeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitCacheMode cacheMode
	public EnumPointer cacheModeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._cacheModeOffset_), J9CudaJitCacheMode.class);
	}

	// U8* errorLogBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errorLogBufferOffset_", declaredType="U8*")
	public U8Pointer errorLogBuffer() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9CudaJitOptions._errorLogBufferOffset_));
	}

	// U8* errorLogBuffer
	public PointerPointer errorLogBufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CudaJitOptions._errorLogBufferOffset_));
	}

	// U64 errorLogBufferSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errorLogBufferSizeOffset_", declaredType="U64")
	public UDATA errorLogBufferSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9CudaJitOptions._errorLogBufferSizeOffset_));
	}

	// U64 errorLogBufferSize
	public UDATAPointer errorLogBufferSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaJitOptions._errorLogBufferSizeOffset_));
	}

	// J9CudaJitFallbackStrategy fallbackStrategy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fallbackStrategyOffset_", declaredType="J9CudaJitFallbackStrategy")
	public long fallbackStrategy() throws CorruptDataException {
		if (J9CudaJitFallbackStrategy.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._fallbackStrategyOffset_);
		} else if (J9CudaJitFallbackStrategy.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._fallbackStrategyOffset_);
		} else if (J9CudaJitFallbackStrategy.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._fallbackStrategyOffset_);
		} else if (J9CudaJitFallbackStrategy.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._fallbackStrategyOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitFallbackStrategy fallbackStrategy
	public EnumPointer fallbackStrategyEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._fallbackStrategyOffset_), J9CudaJitFallbackStrategy.class);
	}

	// J9CudaJitFlag generateDebugInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_generateDebugInfoOffset_", declaredType="J9CudaJitFlag")
	public long generateDebugInfo() throws CorruptDataException {
		if (J9CudaJitFlag.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._generateDebugInfoOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._generateDebugInfoOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._generateDebugInfoOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._generateDebugInfoOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitFlag generateDebugInfo
	public EnumPointer generateDebugInfoEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._generateDebugInfoOffset_), J9CudaJitFlag.class);
	}

	// J9CudaJitFlag generateLineInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_generateLineInfoOffset_", declaredType="J9CudaJitFlag")
	public long generateLineInfo() throws CorruptDataException {
		if (J9CudaJitFlag.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._generateLineInfoOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._generateLineInfoOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._generateLineInfoOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._generateLineInfoOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitFlag generateLineInfo
	public EnumPointer generateLineInfoEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._generateLineInfoOffset_), J9CudaJitFlag.class);
	}

	// U8* infoLogBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_infoLogBufferOffset_", declaredType="U8*")
	public U8Pointer infoLogBuffer() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9CudaJitOptions._infoLogBufferOffset_));
	}

	// U8* infoLogBuffer
	public PointerPointer infoLogBufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CudaJitOptions._infoLogBufferOffset_));
	}

	// U64 infoLogBufferSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_infoLogBufferSizeOffset_", declaredType="U64")
	public UDATA infoLogBufferSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9CudaJitOptions._infoLogBufferSizeOffset_));
	}

	// U64 infoLogBufferSize
	public UDATAPointer infoLogBufferSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaJitOptions._infoLogBufferSizeOffset_));
	}

	// U32 maxRegisters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxRegistersOffset_", declaredType="U32")
	public UDATA maxRegisters() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaJitOptions._maxRegistersOffset_));
	}

	// U32 maxRegisters
	public UDATAPointer maxRegistersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaJitOptions._maxRegistersOffset_));
	}

	// J9CudaJitOptimizationLevel optimizationLevel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_optimizationLevelOffset_", declaredType="J9CudaJitOptimizationLevel")
	public long optimizationLevel() throws CorruptDataException {
		if (J9CudaJitOptimizationLevel.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._optimizationLevelOffset_);
		} else if (J9CudaJitOptimizationLevel.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._optimizationLevelOffset_);
		} else if (J9CudaJitOptimizationLevel.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._optimizationLevelOffset_);
		} else if (J9CudaJitOptimizationLevel.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._optimizationLevelOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitOptimizationLevel optimizationLevel
	public EnumPointer optimizationLevelEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._optimizationLevelOffset_), J9CudaJitOptimizationLevel.class);
	}

	// J9CudaJitFlag recordWallTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_recordWallTimeOffset_", declaredType="J9CudaJitFlag")
	public long recordWallTime() throws CorruptDataException {
		if (J9CudaJitFlag.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._recordWallTimeOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._recordWallTimeOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._recordWallTimeOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._recordWallTimeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitFlag recordWallTime
	public EnumPointer recordWallTimeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._recordWallTimeOffset_), J9CudaJitFlag.class);
	}

	// U32 target
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_targetOffset_", declaredType="U32")
	public UDATA target() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaJitOptions._targetOffset_));
	}

	// U32 target
	public UDATAPointer targetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaJitOptions._targetOffset_));
	}

	// J9CudaJitFlag targetFromContext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_targetFromContextOffset_", declaredType="J9CudaJitFlag")
	public long targetFromContext() throws CorruptDataException {
		if (J9CudaJitFlag.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._targetFromContextOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._targetFromContextOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._targetFromContextOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._targetFromContextOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitFlag targetFromContext
	public EnumPointer targetFromContextEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._targetFromContextOffset_), J9CudaJitFlag.class);
	}

	// U32 threadsPerBlock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadsPerBlockOffset_", declaredType="U32")
	public UDATA threadsPerBlock() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaJitOptions._threadsPerBlockOffset_));
	}

	// U32 threadsPerBlock
	public UDATAPointer threadsPerBlockEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaJitOptions._threadsPerBlockOffset_));
	}

	// J9CudaJitFlag verboseLogging
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_verboseLoggingOffset_", declaredType="J9CudaJitFlag")
	public long verboseLogging() throws CorruptDataException {
		if (J9CudaJitFlag.SIZEOF == 1) {
			return getByteAtOffset(J9CudaJitOptions._verboseLoggingOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 2) {
			return getShortAtOffset(J9CudaJitOptions._verboseLoggingOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 4) {
			return getIntAtOffset(J9CudaJitOptions._verboseLoggingOffset_);
		} else if (J9CudaJitFlag.SIZEOF == 8) {
			return getLongAtOffset(J9CudaJitOptions._verboseLoggingOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// J9CudaJitFlag verboseLogging
	public EnumPointer verboseLoggingEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(J9CudaJitOptions._verboseLoggingOffset_), J9CudaJitFlag.class);
	}

	// float wallTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wallTimeOffset_", declaredType="float")
	public float wallTime() throws CorruptDataException {
		return getFloatAtOffset(J9CudaJitOptions._wallTimeOffset_);
	}

	// float wallTime
	public FloatPointer wallTimeEA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(J9CudaJitOptions._wallTimeOffset_));
	}

}
