/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IO_markerPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IO_markerPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IO_marker.class)
public class _IO_markerPointer extends StructurePointer {

	// NULL
	public static final _IO_markerPointer NULL = new _IO_markerPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IO_markerPointer(long address) {
		super(address);
	}

	public static _IO_markerPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IO_markerPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IO_markerPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IO_markerPointer(address);
	}

	public _IO_markerPointer add(long count) {
		return _IO_markerPointer.cast(address + (_IO_marker.SIZEOF * count));
	}

	public _IO_markerPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IO_markerPointer addOffset(long offset) {
		return _IO_markerPointer.cast(address + offset);
	}

	public _IO_markerPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IO_markerPointer sub(long count) {
		return _IO_markerPointer.cast(address - (_IO_marker.SIZEOF * count));
	}

	public _IO_markerPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IO_markerPointer subOffset(long offset) {
		return _IO_markerPointer.cast(address - offset);
	}

	public _IO_markerPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IO_markerPointer untag(long mask) {
		return _IO_markerPointer.cast(address & ~mask);
	}

	public _IO_markerPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IO_marker.SIZEOF;
	}

	// Implementation methods

	// _IO_marker* _next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nextOffset_", declaredType="_IO_marker*")
	public _IO_markerPointer _next() throws CorruptDataException {
		return _IO_markerPointer.cast(getPointerAtOffset(_IO_marker.__nextOffset_));
	}

	// _IO_marker* _next
	public PointerPointer _nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_marker.__nextOffset_));
	}

	// I32 _pos
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__posOffset_", declaredType="I32")
	public IDATA _pos() throws CorruptDataException {
		return new I32(getIntAtOffset(_IO_marker.__posOffset_));
	}

	// I32 _pos
	public IDATAPointer _posEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_marker.__posOffset_));
	}

	// _IO_FILE* _sbuf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sbufOffset_", declaredType="_IO_FILE*")
	public _IO_FILEPointer _sbuf() throws CorruptDataException {
		return _IO_FILEPointer.cast(getPointerAtOffset(_IO_marker.__sbufOffset_));
	}

	// _IO_FILE* _sbuf
	public PointerPointer _sbufEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_marker.__sbufOffset_));
	}

}
