/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: linuxPowerVMInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the linuxPowerVMInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=linuxPowerVMInfo.class)
public class linuxPowerVMInfoPointer extends StructurePointer {

	// NULL
	public static final linuxPowerVMInfoPointer NULL = new linuxPowerVMInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected linuxPowerVMInfoPointer(long address) {
		super(address);
	}

	public static linuxPowerVMInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static linuxPowerVMInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static linuxPowerVMInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new linuxPowerVMInfoPointer(address);
	}

	public linuxPowerVMInfoPointer add(long count) {
		return linuxPowerVMInfoPointer.cast(address + (linuxPowerVMInfo.SIZEOF * count));
	}

	public linuxPowerVMInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public linuxPowerVMInfoPointer addOffset(long offset) {
		return linuxPowerVMInfoPointer.cast(address + offset);
	}

	public linuxPowerVMInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public linuxPowerVMInfoPointer sub(long count) {
		return linuxPowerVMInfoPointer.cast(address - (linuxPowerVMInfo.SIZEOF * count));
	}

	public linuxPowerVMInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public linuxPowerVMInfoPointer subOffset(long offset) {
		return linuxPowerVMInfoPointer.cast(address - offset);
	}

	public linuxPowerVMInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public linuxPowerVMInfoPointer untag(long mask) {
		return linuxPowerVMInfoPointer.cast(address & ~mask);
	}

	public linuxPowerVMInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return linuxPowerVMInfo.SIZEOF;
	}

	// Implementation methods

	// U32 capped
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cappedOffset_", declaredType="U32")
	public UDATA capped() throws CorruptDataException {
		return new U32(getIntAtOffset(linuxPowerVMInfo._cappedOffset_));
	}

	// U32 capped
	public UDATAPointer cappedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._cappedOffset_));
	}

	// U64 cpuClockSpeedMHz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpuClockSpeedMHzOffset_", declaredType="U64")
	public UDATA cpuClockSpeedMHz() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._cpuClockSpeedMHzOffset_));
	}

	// U64 cpuClockSpeedMHz
	public UDATAPointer cpuClockSpeedMHzEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._cpuClockSpeedMHzOffset_));
	}

	// U64 entitledCapacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entitledCapacityOffset_", declaredType="U64")
	public UDATA entitledCapacity() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._entitledCapacityOffset_));
	}

	// U64 entitledCapacity
	public UDATAPointer entitledCapacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._entitledCapacityOffset_));
	}

	// U64 maxEntitledCapacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxEntitledCapacityOffset_", declaredType="U64")
	public UDATA maxEntitledCapacity() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._maxEntitledCapacityOffset_));
	}

	// U64 maxEntitledCapacity
	public UDATAPointer maxEntitledCapacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._maxEntitledCapacityOffset_));
	}

	// U64 maxMemLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxMemLimitOffset_", declaredType="U64")
	public UDATA maxMemLimit() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._maxMemLimitOffset_));
	}

	// U64 maxMemLimit
	public UDATAPointer maxMemLimitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._maxMemLimitOffset_));
	}

	// U64 memUsed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memUsedOffset_", declaredType="U64")
	public UDATA memUsed() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._memUsedOffset_));
	}

	// U64 memUsed
	public UDATAPointer memUsedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._memUsedOffset_));
	}

	// U64 purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_purrOffset_", declaredType="U64")
	public UDATA purr() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._purrOffset_));
	}

	// U64 purr
	public UDATAPointer purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._purrOffset_));
	}

	// U64 timebaseFreq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timebaseFreqOffset_", declaredType="U64")
	public UDATA timebaseFreq() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._timebaseFreqOffset_));
	}

	// U64 timebaseFreq
	public UDATAPointer timebaseFreqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._timebaseFreqOffset_));
	}

	// U64 timebaseLast
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timebaseLastOffset_", declaredType="U64")
	public UDATA timebaseLast() throws CorruptDataException {
		return new U64(getLongAtOffset(linuxPowerVMInfo._timebaseLastOffset_));
	}

	// U64 timebaseLast
	public UDATAPointer timebaseLastEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(linuxPowerVMInfo._timebaseLastOffset_));
	}

}
