/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9AnnotationInfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9AnnotationInfo {

	// VM Constants

	public static final long SIZEOF;
	public static final long ANNOTATION_FLAG_INVISIBLE;
	public static final long ANNOTATION_PARM_MASK;
	public static final long ANNOTATION_PARM_SHIFT;
	public static final long ANNOTATION_TAG_MASK;
	public static final long ANNOTATION_TYPE_ANNOTATION;
	public static final long ANNOTATION_TYPE_CLASS;
	public static final long ANNOTATION_TYPE_FIELD;
	public static final long ANNOTATION_TYPE_MASK;
	public static final long ANNOTATION_TYPE_METHOD;
	public static final long ANNOTATION_TYPE_PARAMETER;

	// Offsets

	public static final int _countAnnotationOffset_;
	public static final int _countClassOffset_;
	public static final int _countFieldOffset_;
	public static final int _countMethodOffset_;
	public static final int _countParameterOffset_;
	public static final int _defaultValuesOffset_;
	public static final int _firstAnnotationOffset_;
	public static final int _firstClassOffset_;
	public static final int _firstFieldOffset_;
	public static final int _firstMethodOffset_;
	public static final int _firstParameterOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ANNOTATION_FLAG_INVISIBLE = 0;
		ANNOTATION_PARM_MASK = 0;
		ANNOTATION_PARM_SHIFT = 0;
		ANNOTATION_TAG_MASK = 0;
		ANNOTATION_TYPE_ANNOTATION = 0;
		ANNOTATION_TYPE_CLASS = 0;
		ANNOTATION_TYPE_FIELD = 0;
		ANNOTATION_TYPE_MASK = 0;
		ANNOTATION_TYPE_METHOD = 0;
		ANNOTATION_TYPE_PARAMETER = 0;
		_countAnnotationOffset_ = 0;
		_countClassOffset_ = 0;
		_countFieldOffset_ = 0;
		_countMethodOffset_ = 0;
		_countParameterOffset_ = 0;
		_defaultValuesOffset_ = 0;
		_firstAnnotationOffset_ = 0;
		_firstClassOffset_ = 0;
		_firstFieldOffset_ = 0;
		_firstMethodOffset_ = 0;
		_firstParameterOffset_ = 0;
	}

}
