/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9Object
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9Object {

	// VM Constants

	public static final long SIZEOF;
	public static final long OBJECT_HEADER_AGE_DEFAULT;
	public static final long OBJECT_HEADER_AGE_INCREMENT;
	public static final long OBJECT_HEADER_AGE_MASK;
	public static final long OBJECT_HEADER_AGE_SHIFT;
	public static final long OBJECT_HEADER_COLOR_BLACK;
	public static final long OBJECT_HEADER_COLOR_LIGHT_GREY;
	public static final long OBJECT_HEADER_COLOR_MASK;
	public static final long OBJECT_HEADER_COLOR_WHITE;
	public static final long OBJECT_HEADER_COPIED_WEAKLY;
	public static final long OBJECT_HEADER_FIXED;
	public static final long OBJECT_HEADER_FLAGS_SAVE_MASK;
	public static final long OBJECT_HEADER_FLAT_LOCK_CONTENTION;
	public static final long OBJECT_HEADER_FORWARDED;
	public static final long OBJECT_HEADER_HASH_MASK;
	public static final long OBJECT_HEADER_HAS_BEEN_HASHED;
	public static final long OBJECT_HEADER_HAS_BEEN_HASHED_IN_CLASS;
	public static final long OBJECT_HEADER_HAS_BEEN_HASHED_MASK;
	public static final long OBJECT_HEADER_HAS_BEEN_HASHED_MASK_IN_CLASS;
	public static final long OBJECT_HEADER_HAS_BEEN_MOVED;
	public static final long OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS;
	public static final long OBJECT_HEADER_ILLEGAL_MONITOR_STATE;
	public static final long OBJECT_HEADER_INDEXABLE_NHS;
	public static final long OBJECT_HEADER_INDEXABLE_STANDARD;
	public static final long OBJECT_HEADER_INVALID_ADDR_BITS;
	public static final long OBJECT_HEADER_LOCK_BITS_MASK;
	public static final long OBJECT_HEADER_LOCK_FIRST_RECURSION_BIT;
	public static final long OBJECT_HEADER_LOCK_FLC;
	public static final long OBJECT_HEADER_LOCK_INFLATED;
	public static final long OBJECT_HEADER_LOCK_LAST_RECURSION_BIT;
	public static final long OBJECT_HEADER_LOCK_LEARNING;
	public static final long OBJECT_HEADER_LOCK_LEARNING_RECURSION_OFFSET;
	public static final long OBJECT_HEADER_LOCK_RECURSION_MASK;
	public static final long OBJECT_HEADER_LOCK_RECURSION_OFFSET;
	public static final long OBJECT_HEADER_LOCK_RESERVED;
	public static final long OBJECT_HEADER_LOCK_V2_RECURSION_OFFSET;
	public static final long OBJECT_HEADER_LOWEST_REMEMBERED;
	public static final long OBJECT_HEADER_MARKED;
	public static final long OBJECT_HEADER_MONITOR_ENTER_INTERRUPTED;
	public static final long OBJECT_HEADER_NON_CM_CANDIDATE;
	public static final long OBJECT_HEADER_NOT_REMEMBERED;
	public static final long OBJECT_HEADER_OLD;
	public static final long OBJECT_HEADER_REMEMBERED;
	public static final long OBJECT_HEADER_SHAPE_BYTES;
	public static final long OBJECT_HEADER_SHAPE_DOUBLES;
	public static final long OBJECT_HEADER_SHAPE_INVALID_0;
	public static final long OBJECT_HEADER_SHAPE_LONGS;
	public static final long OBJECT_HEADER_SHAPE_MASK;
	public static final long OBJECT_HEADER_SHAPE_MIXED;
	public static final long OBJECT_HEADER_SHAPE_POINTERS;
	public static final long OBJECT_HEADER_SHAPE_UNUSED8;
	public static final long OBJECT_HEADER_SHAPE_WORDS;
	public static final long OBJECT_HEADER_SLOT_BOOLEAN;
	public static final long OBJECT_HEADER_SLOT_BYTE;
	public static final long OBJECT_HEADER_SLOT_CHAR;
	public static final long OBJECT_HEADER_SLOT_DOUBLE;
	public static final long OBJECT_HEADER_SLOT_FLOAT;
	public static final long OBJECT_HEADER_SLOT_INT;
	public static final long OBJECT_HEADER_SLOT_LONG;
	public static final long OBJECT_HEADER_SLOT_REFERENCE;
	public static final long OBJECT_HEADER_SLOT_SHORT;
	public static final long OBJECT_HEADER_SPACE_ROM;
	public static final long OBJECT_HEADER_STACCATO_MARKED;
	public static final long OBJECT_HEADER_STACK_ALLOCATED;
	public static final long OBJECT_HEADER_WEAK;

	// Offsets

	public static final int _clazzOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		OBJECT_HEADER_AGE_DEFAULT = 0;
		OBJECT_HEADER_AGE_INCREMENT = 0;
		OBJECT_HEADER_AGE_MASK = 0;
		OBJECT_HEADER_AGE_SHIFT = 0;
		OBJECT_HEADER_COLOR_BLACK = 0;
		OBJECT_HEADER_COLOR_LIGHT_GREY = 0;
		OBJECT_HEADER_COLOR_MASK = 0;
		OBJECT_HEADER_COLOR_WHITE = 0;
		OBJECT_HEADER_COPIED_WEAKLY = 0;
		OBJECT_HEADER_FIXED = 0;
		OBJECT_HEADER_FLAGS_SAVE_MASK = 0;
		OBJECT_HEADER_FLAT_LOCK_CONTENTION = 0;
		OBJECT_HEADER_FORWARDED = 0;
		OBJECT_HEADER_HASH_MASK = 0;
		OBJECT_HEADER_HAS_BEEN_HASHED = 0;
		OBJECT_HEADER_HAS_BEEN_HASHED_IN_CLASS = 0;
		OBJECT_HEADER_HAS_BEEN_HASHED_MASK = 0;
		OBJECT_HEADER_HAS_BEEN_HASHED_MASK_IN_CLASS = 0;
		OBJECT_HEADER_HAS_BEEN_MOVED = 0;
		OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS = 0;
		OBJECT_HEADER_ILLEGAL_MONITOR_STATE = 0;
		OBJECT_HEADER_INDEXABLE_NHS = 0;
		OBJECT_HEADER_INDEXABLE_STANDARD = 0;
		OBJECT_HEADER_INVALID_ADDR_BITS = 0;
		OBJECT_HEADER_LOCK_BITS_MASK = 0;
		OBJECT_HEADER_LOCK_FIRST_RECURSION_BIT = 0;
		OBJECT_HEADER_LOCK_FLC = 0;
		OBJECT_HEADER_LOCK_INFLATED = 0;
		OBJECT_HEADER_LOCK_LAST_RECURSION_BIT = 0;
		OBJECT_HEADER_LOCK_LEARNING = 0;
		OBJECT_HEADER_LOCK_LEARNING_RECURSION_OFFSET = 0;
		OBJECT_HEADER_LOCK_RECURSION_MASK = 0;
		OBJECT_HEADER_LOCK_RECURSION_OFFSET = 0;
		OBJECT_HEADER_LOCK_RESERVED = 0;
		OBJECT_HEADER_LOCK_V2_RECURSION_OFFSET = 0;
		OBJECT_HEADER_LOWEST_REMEMBERED = 0;
		OBJECT_HEADER_MARKED = 0;
		OBJECT_HEADER_MONITOR_ENTER_INTERRUPTED = 0;
		OBJECT_HEADER_NON_CM_CANDIDATE = 0;
		OBJECT_HEADER_NOT_REMEMBERED = 0;
		OBJECT_HEADER_OLD = 0;
		OBJECT_HEADER_REMEMBERED = 0;
		OBJECT_HEADER_SHAPE_BYTES = 0;
		OBJECT_HEADER_SHAPE_DOUBLES = 0;
		OBJECT_HEADER_SHAPE_INVALID_0 = 0;
		OBJECT_HEADER_SHAPE_LONGS = 0;
		OBJECT_HEADER_SHAPE_MASK = 0;
		OBJECT_HEADER_SHAPE_MIXED = 0;
		OBJECT_HEADER_SHAPE_POINTERS = 0;
		OBJECT_HEADER_SHAPE_UNUSED8 = 0;
		OBJECT_HEADER_SHAPE_WORDS = 0;
		OBJECT_HEADER_SLOT_BOOLEAN = 0;
		OBJECT_HEADER_SLOT_BYTE = 0;
		OBJECT_HEADER_SLOT_CHAR = 0;
		OBJECT_HEADER_SLOT_DOUBLE = 0;
		OBJECT_HEADER_SLOT_FLOAT = 0;
		OBJECT_HEADER_SLOT_INT = 0;
		OBJECT_HEADER_SLOT_LONG = 0;
		OBJECT_HEADER_SLOT_REFERENCE = 0;
		OBJECT_HEADER_SLOT_SHORT = 0;
		OBJECT_HEADER_SPACE_ROM = 0;
		OBJECT_HEADER_STACCATO_MARKED = 0;
		OBJECT_HEADER_STACK_ALLOCATED = 0;
		OBJECT_HEADER_WEAK = 0;
		_clazzOffset_ = 0;
	}

}
