/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_MemoryPool
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_MemoryPool {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocBytesOffset_;
	public static final int __allocCountOffset_;
	public static final int __allocDiscardedBytesOffset_;
	public static final int __allocSearchCountOffset_;
	public static final int __approximateFreeMemorySizeOffset_;
	public static final int __childrenOffset_;
	public static final int __compressObjectReferencesOffset_;
	public static final int __darkMatterBytesOffset_;
	public static final int __darkMatterSamplesOffset_;
	public static final int __extensionsOffset_;
	public static final int __freeEntryCountOffset_;
	public static final int __freeMemorySizeOffset_;
	public static final int __largeObjectAllocateStatsOffset_;
	public static final int __largestFreeEntryOffset_;
	public static final int __lastFreeBytesOffset_;
	public static final int __memorySubSpaceOffset_;
	public static final int __minimumFreeEntrySizeOffset_;
	public static final int __nextOffset_;
	public static final int __nonScannableBytesOffset_;
	public static final int __parentOffset_;
	public static final int __poolNameOffset_;
	public static final int __previousOffset_;
	public static final int __scannableBytesOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocBytesOffset_ = 0;
		__allocCountOffset_ = 0;
		__allocDiscardedBytesOffset_ = 0;
		__allocSearchCountOffset_ = 0;
		__approximateFreeMemorySizeOffset_ = 0;
		__childrenOffset_ = 0;
		__compressObjectReferencesOffset_ = 0;
		__darkMatterBytesOffset_ = 0;
		__darkMatterSamplesOffset_ = 0;
		__extensionsOffset_ = 0;
		__freeEntryCountOffset_ = 0;
		__freeMemorySizeOffset_ = 0;
		__largeObjectAllocateStatsOffset_ = 0;
		__largestFreeEntryOffset_ = 0;
		__lastFreeBytesOffset_ = 0;
		__memorySubSpaceOffset_ = 0;
		__minimumFreeEntrySizeOffset_ = 0;
		__nextOffset_ = 0;
		__nonScannableBytesOffset_ = 0;
		__parentOffset_ = 0;
		__poolNameOffset_ = 0;
		__previousOffset_ = 0;
		__scannableBytesOffset_ = 0;
	}

}
