/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ROMClassWriter
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ROMClassWriter {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __annotationInfoClassSRPKeyOffset_;
	public static final int __bufferManagerOffset_;
	public static final int __buildResultOffset_;
	public static final int __callSiteDataSRPKeyOffset_;
	public static final int __classFileOracleOffset_;
	public static final int __constantPoolMapOffset_;
	public static final int __contextOffset_;
	public static final int __cpDescriptionShapeSRPKeyOffset_;
	public static final int __enclosedInnerClassesSRPKeyOffset_;
	public static final int __enclosingMethodSRPKeyOffset_;
	public static final int __fieldsSRPKeyOffset_;
	public static final int __innerClassesSRPKeyOffset_;
	public static final int __interfacesSRPKeyOffset_;
	public static final int __intermediateClassDataSRPKeyOffset_;
	public static final int __methodNotesOffset_;
	public static final int __methodsSRPKeyOffset_;
	public static final int __nestMembersSRPKeyOffset_;
	public static final int __optionalInfoSRPKeyOffset_;
	public static final int __permittedSubclassesInfoSRPKeyOffset_;
	public static final int __recordInfoSRPKeyOffset_;
	public static final int __sourceDebugExtensionSRPKeyOffset_;
	public static final int __specialSplitTableSRPKeyOffset_;
	public static final int __srpKeyProducerOffset_;
	public static final int __srpOffsetTableOffset_;
	public static final int __stackMapsSRPKeyOffset_;
	public static final int __staticSplitTableSRPKeyOffset_;
	public static final int __typeAnnotationInfoSRPKeyOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__annotationInfoClassSRPKeyOffset_ = 0;
		__bufferManagerOffset_ = 0;
		__buildResultOffset_ = 0;
		__callSiteDataSRPKeyOffset_ = 0;
		__classFileOracleOffset_ = 0;
		__constantPoolMapOffset_ = 0;
		__contextOffset_ = 0;
		__cpDescriptionShapeSRPKeyOffset_ = 0;
		__enclosedInnerClassesSRPKeyOffset_ = 0;
		__enclosingMethodSRPKeyOffset_ = 0;
		__fieldsSRPKeyOffset_ = 0;
		__innerClassesSRPKeyOffset_ = 0;
		__interfacesSRPKeyOffset_ = 0;
		__intermediateClassDataSRPKeyOffset_ = 0;
		__methodNotesOffset_ = 0;
		__methodsSRPKeyOffset_ = 0;
		__nestMembersSRPKeyOffset_ = 0;
		__optionalInfoSRPKeyOffset_ = 0;
		__permittedSubclassesInfoSRPKeyOffset_ = 0;
		__recordInfoSRPKeyOffset_ = 0;
		__sourceDebugExtensionSRPKeyOffset_ = 0;
		__specialSplitTableSRPKeyOffset_ = 0;
		__srpKeyProducerOffset_ = 0;
		__srpOffsetTableOffset_ = 0;
		__stackMapsSRPKeyOffset_ = 0;
		__staticSplitTableSRPKeyOffset_ = 0;
		__typeAnnotationInfoSRPKeyOffset_ = 0;
	}

}
