/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.os.linux;

import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Smaps {
    private List<Range> ranges;

    protected Smaps(List<Range> ranges) {
        this.ranges = ranges;
    }

    public Range getRange(String addr) {
        BigInteger laddr = new BigInteger(addr.substring(2), 16);
        for (Range range : this.ranges) {
            if (!range.includes(laddr)) continue;
            return range;
        }
        return null;
    }

    public static Smaps parseSelf() throws Exception {
        return Smaps.parse(Path.of("/proc/self/smaps", new String[0]));
    }

    public static Smaps parse(Path smaps) throws Exception {
        return new Parser(smaps).parse();
    }

    public static class Range {
        private BigInteger start;
        private BigInteger end;
        private long pageSize;
        private boolean thpEligible;
        private boolean vmFlagHG;
        private boolean vmFlagHT;
        private boolean isTHP;

        public Range(String start, String end, String pageSize, String thpEligible, String vmFlags) {
            this.start = new BigInteger(start, 16);
            this.end = new BigInteger(end, 16);
            this.pageSize = Long.parseLong(pageSize);
            this.thpEligible = thpEligible == null ? false : Integer.parseInt(thpEligible) == 1;
            this.vmFlagHG = false;
            this.vmFlagHT = false;
            for (String flag : vmFlags.split(" ")) {
                if (flag.equals("ht")) {
                    this.vmFlagHT = true;
                    continue;
                }
                if (!flag.equals("hg")) continue;
                this.vmFlagHG = true;
            }
            this.isTHP = this.vmFlagHG || this.thpEligible;
        }

        public BigInteger getStart() {
            return this.start;
        }

        public BigInteger getEnd() {
            return this.end;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public boolean isTransparentHuge() {
            return this.isTHP;
        }

        public boolean isExplicitHuge() {
            return this.vmFlagHT;
        }

        public boolean includes(BigInteger addr) {
            boolean isGreaterThanOrEqualStart = this.start.compareTo(addr) <= 0;
            boolean isLessThanEnd = addr.compareTo(this.end) < 0;
            return isGreaterThanOrEqualStart && isLessThanEnd;
        }

        public String toString() {
            return "[" + this.start.toString(16) + ", " + this.end.toString(16) + ") pageSize=" + this.pageSize + "KB isTHP=" + this.isTHP + " isHUGETLB=" + this.vmFlagHT;
        }
    }

    private static class Parser {
        private static final Pattern SECTION_START_PATT = Pattern.compile("^([a-f0-9]+)-([a-f0-9]+) [\\-rwpsx]{4}.*");
        private static final Pattern KERNEL_PAGESIZE_PATT = Pattern.compile("^KernelPageSize:\\s*(\\d*) kB");
        private static final Pattern THP_ELIGIBLE_PATT = Pattern.compile("^THPeligible:\\s+(\\d*)");
        private static final Pattern VMFLAGS_PATT = Pattern.compile("^VmFlags: ([\\w\\? ]*)");
        String start;
        String end;
        String ps;
        String thpEligible;
        String vmFlags;
        List<Range> ranges = new LinkedList<Range>();
        Path smaps;

        Parser(Path smaps) {
            this.smaps = smaps;
            this.reset();
        }

        void reset() {
            this.start = null;
            this.end = null;
            this.ps = null;
            this.thpEligible = null;
            this.vmFlags = null;
        }

        public void finish() {
            if (this.start != null) {
                Range range = new Range(this.start, this.end, this.ps, this.thpEligible, this.vmFlags);
                this.ranges.add(range);
                this.reset();
            }
        }

        public void eatNext(String line) {
            Matcher matSectionStart = SECTION_START_PATT.matcher(line);
            if (matSectionStart.matches()) {
                this.finish();
            }
            if (matSectionStart.matches()) {
                this.start = matSectionStart.group(1);
                this.end = matSectionStart.group(2);
                this.ps = null;
                this.vmFlags = null;
                return;
            }
            Matcher matKernelPageSize = KERNEL_PAGESIZE_PATT.matcher(line);
            if (matKernelPageSize.matches()) {
                this.ps = matKernelPageSize.group(1);
                return;
            }
            Matcher matTHPEligible = THP_ELIGIBLE_PATT.matcher(line);
            if (matTHPEligible.matches()) {
                this.thpEligible = matTHPEligible.group(1);
                return;
            }
            Matcher matVmFlags = VMFLAGS_PATT.matcher(line);
            if (matVmFlags.matches()) {
                this.vmFlags = matVmFlags.group(1);
                return;
            }
        }

        private Path copySmaps() throws Exception {
            Path copy = Paths.get("smaps-copy-" + ProcessHandle.current().pid() + "-" + System.nanoTime() + ".txt", new String[0]);
            Files.copy(this.smaps, copy, StandardCopyOption.REPLACE_EXISTING);
            return copy;
        }

        public Smaps parse() throws Exception {
            Path smapsCopy = this.copySmaps();
            Files.lines(smapsCopy).forEach(this::eatNext);
            this.finish();
            return new Smaps(this.ranges);
        }
    }
}

