/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jdk.test.lib.artifacts.Artifact;
import jdk.test.lib.artifacts.ArtifactResolver;
import jdk.test.lib.artifacts.ArtifactResolverException;
import jtreg.SkippedException;

public sealed interface RepositoryFileReader
extends AutoCloseable {
    public byte[] read(String var1) throws IOException;

    @Override
    public void close() throws IOException;

    public static RepositoryFileReader of(Class<?> klass, String zipPrefix) {
        Artifact artifact = klass.getAnnotation(Artifact.class);
        String org = artifact.organization();
        String prop = System.getProperty("jdk.tests.repos.pattern");
        if (prop != null && org.startsWith("jpg.tests.jdk.repos.")) {
            prop = prop.replace("%o", org.substring(org.lastIndexOf(46) + 1));
            prop = prop.replace("%n", artifact.name());
            prop = prop.replace("%r", artifact.revision());
            System.out.println("Creating URLReader on " + prop);
            return new URLReader(prop);
        }
        try {
            Path p = (Path)((Map.Entry)ArtifactResolver.resolve(klass).entrySet().stream().findAny().get()).getValue();
            System.out.println("Creating ZipReader on " + String.valueOf(p));
            return new ZipReader(new ZipFile(p.toFile()), zipPrefix);
        }
        catch (IOException | ArtifactResolverException e) {
            throw new SkippedException("Cannot find " + artifact.name(), e);
        }
    }

    public record URLReader(String base) implements RepositoryFileReader
    {
        @Override
        public void close() {
        }

        @Override
        public byte[] read(String entry) throws IOException {
            byte[] byArray;
            block8: {
                System.out.println("Reading " + entry + "...");
                InputStream is = new URI(this.base.replace("%e", entry)).toURL().openStream();
                try {
                    byArray = is.readAllBytes();
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (URISyntaxException e) {
                        throw new IOException("Cannot create URI", e);
                    }
                }
                is.close();
            }
            return byArray;
        }
    }

    public record ZipReader(ZipFile zf, String zipPrefix) implements RepositoryFileReader
    {
        @Override
        public void close() throws IOException {
            this.zf.close();
        }

        @Override
        public byte[] read(String entry) throws IOException {
            System.out.println("Reading " + entry + "...");
            ZipEntry ze = this.zf.getEntry(this.zipPrefix + entry);
            if (ze != null) {
                return this.zf.getInputStream(ze).readAllBytes();
            }
            throw new RuntimeException("Entry not found: " + entry);
        }
    }

    @Artifact(organization="jpg.tests.jdk.repos.lamps-wg", name="cms-ml-dsa", revision="c8f0cf7", extension="zip", unpack=false)
    public static class CMS_ML_DSA {
    }

    @Artifact(organization="jpg.tests.jdk.repos.lamps-wg", name="dilithium-certificates", revision="785a549", extension="zip", unpack=false)
    public static class DILITHIUM_CERTIFICATES {
    }
}

