/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.metal.MetalBorders;

public final class TextureAnim
extends AnimatingControlsSurface {
    public static final Color colorblend = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    protected static BufferedImage textureImg;
    protected int bNum;
    protected int tilesize;
    private boolean newtexture;
    private TexturePaint texturePaint;
    private Rectangle tilerect;
    private boolean bouncesize = false;
    private boolean bouncerect = true;
    private boolean rotate = false;
    private boolean shearx = false;
    private boolean sheary = false;
    private boolean showanchor = true;
    private AnimVal w;
    private AnimVal h;
    private AnimVal x;
    private AnimVal y;
    private AnimVal rot;
    private AnimVal shx;
    private AnimVal shy;
    private static Image[] img;

    public TextureAnim() {
        TextureAnim.img[0] = this.getImage("duke.gif");
        TextureAnim.img[1] = this.getImage("duke.png");
        textureImg = this.makeImage(32, 0);
        this.tilesize = textureImg.getWidth();
        this.w = new AnimVal(0, 200, 3, 10, this.tilesize);
        this.h = new AnimVal(0, 200, 3, 10, this.tilesize);
        this.x = new AnimVal(0, 200, 3, 10, 0);
        this.y = new AnimVal(0, 200, 3, 10, 0);
        this.rot = new AnimVal(-360, 360, 5, 15, 0);
        this.shx = new AnimVal(-50, 50, 3, 10, 0);
        this.shy = new AnimVal(-50, 50, 3, 10, 0);
        this.tilerect = new Rectangle(this.x.getInt(), this.y.getInt(), this.w.getInt(), this.h.getInt());
        this.texturePaint = new TexturePaint(textureImg, this.tilerect);
        this.setControls(new Component[]{new DemoControls(this, this)});
    }

    protected BufferedImage makeImage(int size, int num) {
        this.newtexture = true;
        this.bNum = num;
        switch (this.bNum) {
            case 0: {
                return this.makeRGBImage(size);
            }
            case 1: {
                return this.makeGIFImage(size);
            }
            case 2: {
                return this.makePNGImage(size);
            }
        }
        return null;
    }

    private BufferedImage makeRGBImage(int size) {
        BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D big = bi.createGraphics();
        big.setColor(Color.WHITE);
        big.fillRect(0, 0, size, size);
        for (int j = 0; j < size; ++j) {
            float RED = (float)j / (float)size;
            for (int i = 0; i < size; ++i) {
                float GREEN = (float)i / (float)size;
                big.setColor(new Color(1.0f - RED, 1.0f - GREEN, 0.0f, 1.0f));
                big.drawLine(i, j, i, j);
            }
        }
        return bi;
    }

    private BufferedImage makeGIFImage(int d) {
        BufferedImage bi = new BufferedImage(d, d, 1);
        Graphics2D big = bi.createGraphics();
        big.drawImage(img[0], 0, 0, d, d, new Color(204, 204, 255), null);
        return bi;
    }

    private BufferedImage makePNGImage(int d) {
        BufferedImage bi = new BufferedImage(d, d, 1);
        Graphics2D big = bi.createGraphics();
        big.drawImage(img[1], 0, 0, d, d, Color.LIGHT_GRAY, null);
        return bi;
    }

    @Override
    public void reset(int width, int height) {
        this.x.newlimits(-width / 4, width / 4 - this.w.getInt());
        this.y.newlimits(-height / 4, height / 4 - this.h.getInt());
    }

    @Override
    public void step(int width, int height) {
        if (this.tilesize != textureImg.getWidth()) {
            this.tilesize = textureImg.getWidth();
        }
        if (this.bouncesize) {
            this.w.anim();
            this.h.anim();
            this.x.newlimits(-width / 4, width / 4 - this.w.getInt());
            this.y.newlimits(-height / 4, height / 4 - this.h.getInt());
        } else {
            if (this.w.getInt() != this.tilesize) {
                this.w.set(this.tilesize);
                this.x.newlimits(-width / 4, width / 4 - this.w.getInt());
            }
            if (this.h.getInt() != this.tilesize) {
                this.h.set(this.tilesize);
                this.y.newlimits(-height / 4, height / 4 - this.h.getInt());
            }
        }
        if (this.bouncerect) {
            this.x.anim();
            this.y.anim();
        }
        if (this.newtexture || this.x.getInt() != this.tilerect.x || this.y.getInt() != this.tilerect.y || this.w.getInt() != this.tilerect.width || this.h.getInt() != this.tilerect.height) {
            this.newtexture = false;
            int X = this.x.getInt();
            int Y = this.y.getInt();
            int W = this.w.getInt();
            int H = this.h.getInt();
            this.tilerect = new Rectangle(X, Y, W, H);
            this.texturePaint = new TexturePaint(textureImg, this.tilerect);
        }
    }

    @Override
    public void render(int width, int height, Graphics2D g2) {
        g2.translate(width / 2, height / 2);
        if (this.rotate) {
            this.rot.anim();
            g2.rotate(Math.toRadians(this.rot.getFlt()));
        } else {
            this.rot.set(0.0f);
        }
        if (this.shearx) {
            this.shx.anim();
            g2.shear(this.shx.getFlt() / 100.0f, 0.0);
        } else {
            this.shx.set(0.0f);
        }
        if (this.sheary) {
            this.shy.anim();
            g2.shear(0.0, this.shy.getFlt() / 100.0f);
        } else {
            this.shy.set(0.0f);
        }
        g2.setPaint(this.texturePaint);
        g2.fillRect(-1000, -1000, 2000, 2000);
        if (this.showanchor) {
            g2.setColor(Color.BLACK);
            g2.setColor(colorblend);
            g2.fill(this.tilerect);
        }
    }

    public static void main(String[] argv) {
        TextureAnim.createDemoFrame(new TextureAnim());
    }

    static {
        img = new Image[2];
    }

    static final class AnimVal {
        float curval;
        float lowval;
        float highval;
        float currate;
        float lowrate;
        float highrate;

        public AnimVal(int lowval, int highval, int lowrate, int highrate) {
            this.lowval = lowval;
            this.highval = highval;
            this.lowrate = lowrate;
            this.highrate = highrate;
            this.curval = this.randval(lowval, highval);
            this.currate = this.randval(lowrate, highrate);
        }

        public AnimVal(int lowval, int highval, int lowrate, int highrate, int pos) {
            this(lowval, highval, lowrate, highrate);
            this.set(pos);
        }

        public float randval(float low, float high) {
            return (float)((double)low + Math.random() * (double)(high - low));
        }

        public float getFlt() {
            return this.curval;
        }

        public int getInt() {
            return (int)this.curval;
        }

        public void anim() {
            this.curval += this.currate;
            this.clip();
        }

        public void set(float val) {
            this.curval = val;
            this.clip();
        }

        public void clip() {
            if (this.curval > this.highval) {
                this.curval = this.highval - (this.curval - this.highval);
                if (this.curval < this.lowval) {
                    this.curval = this.highval;
                }
                this.currate = -this.randval(this.lowrate, this.highrate);
            } else if (this.curval < this.lowval) {
                this.curval = this.lowval + (this.lowval - this.curval);
                if (this.curval > this.highval) {
                    this.curval = this.lowval;
                }
                this.currate = this.randval(this.lowrate, this.highrate);
            }
        }

        public void newlimits(int lowval, int highval) {
            this.lowval = lowval;
            this.highval = highval;
            this.clip();
        }
    }

    final class DemoControls
    extends CustomControls
    implements ActionListener {
        TextureAnim demo;
        JToolBar toolbar;
        JComboBox<String> combo;
        JMenu menu;
        JMenuItem[] menuitems;
        int iconSize;
        MetalBorders.ButtonBorder buttonBorder;
        final /* synthetic */ TextureAnim this$0;

        public DemoControls(TextureAnim this$0, TextureAnim demo) {
            TextureAnim textureAnim = this$0;
            Objects.requireNonNull(textureAnim);
            this.this$0 = textureAnim;
            super(demo.name);
            this.iconSize = 20;
            this.buttonBorder = new MetalBorders.ButtonBorder();
            this.demo = demo;
            this.menuitems = new JMenuItem[3];
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("BO", "bounce", true);
            this.addTool("SA", "show anchor", true);
            this.addTool("RS", "resize", false);
            this.addTool("RO", "rotate", false);
            this.addTool("SX", "shear x", false);
            this.addTool("SY", "shear y", false);
            this.combo = new JComboBox();
            this.add(this.combo);
            this.combo.addActionListener(this);
            this.combo.addItem("8");
            this.combo.addItem("16");
            this.combo.addItem("32");
            this.combo.addItem("64");
            this.combo.addItem("80");
            this.combo.setSelectedIndex(2);
            JMenuBar menuBar = new JMenuBar();
            this.menu = menuBar.add(new JMenu());
            for (int i = 0; i < 3; ++i) {
                BufferedImage bimg = demo.makeImage(this.iconSize, i);
                TexturedIcon icon = new TexturedIcon(this, bimg);
                this.menuitems[i] = this.menu.add(new JMenuItem(icon));
                this.menuitems[i].addActionListener(this);
            }
            this.menu.setIcon(this.menuitems[0].getIcon());
            this.add(menuBar);
            demo.bNum = 0;
        }

        public void addTool(String str, String toolTip, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setBorder(this.buttonBorder);
            b.setFocusPainted(false);
            b.setSelected(state);
            b.setToolTipText(toolTip);
            b.addActionListener(this);
            int width = b.getPreferredSize().width + 10;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj instanceof JComboBox) {
                String selItem = (String)this.combo.getSelectedItem();
                if (selItem != null) {
                    int size = Integer.parseInt(selItem);
                    textureImg = this.demo.makeImage(size, this.demo.bNum);
                }
            } else if (obj instanceof JMenuItem) {
                for (int i = 0; i < this.menuitems.length; ++i) {
                    if (!obj.equals(this.menuitems[i])) continue;
                    textureImg = this.demo.makeImage(this.demo.tilesize, i);
                    this.menu.setIcon(this.menuitems[i].getIcon());
                    break;
                }
            } else {
                JToggleButton b = (JToggleButton)obj;
                if (b.getText().equals("BO")) {
                    this.demo.bouncerect = b.isSelected();
                } else if (b.getText().equals("SA")) {
                    this.demo.showanchor = b.isSelected();
                } else if (b.getText().equals("RS")) {
                    this.demo.bouncesize = b.isSelected();
                } else if (b.getText().equals("RO")) {
                    this.demo.rotate = b.isSelected();
                } else if (b.getText().equals("SX")) {
                    this.demo.shearx = b.isSelected();
                } else if (b.getText().equals("SY")) {
                    this.demo.sheary = b.isSelected();
                }
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 41);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 2; i < this.toolbar.getComponentCount(); ++i) {
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    ((AbstractButton)this.toolbar.getComponentAtIndex(i)).doClick();
                }
            }
            this.thread = null;
        }

        class TexturedIcon
        implements Icon {
            BufferedImage bi;
            final /* synthetic */ DemoControls this$1;

            public TexturedIcon(DemoControls this$1, BufferedImage bi) {
                DemoControls demoControls = this$1;
                Objects.requireNonNull(demoControls);
                this.this$1 = demoControls;
                this.bi = bi;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Rectangle r = new Rectangle(x, y, this.this$1.iconSize, this.this$1.iconSize);
                g2.setPaint(new TexturePaint(this.bi, r));
                g2.fillRect(x, y, this.this$1.iconSize, this.this$1.iconSize);
                g2.setColor(Color.GRAY);
                g2.draw3DRect(x, y, this.this$1.iconSize - 1, this.this$1.iconSize - 1, true);
            }

            @Override
            public int getIconWidth() {
                return this.this$1.iconSize;
            }

            @Override
            public int getIconHeight() {
                return this.this$1.iconSize;
            }
        }
    }
}

